local assets =
{
    Asset("ANIM", "anim/aura_attack.zip"),
    Asset("SOUND", "sound/chess.fsb"),
}

local function OnHit(inst, owner, target)
    SpawnPrefab("eye_charge_hit").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
end

local function common(anim, bloom)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()

    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)

    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("aura_attack")
    inst.AnimState:SetBuild("aura_attack")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:PlayAnimation(anim, true)

    inst:AddTag("projectile")

    inst.persists = false

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetHoming(true)
    inst.components.projectile:SetHitDist(0.5)
    inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(inst.Remove)

    return inst
end

local function PlayHitSound(proxy)
    local inst = CreateEntity()

    --[[Non-networked entity]]

    inst.entity:AddTransform()
    inst.entity:AddSoundEmitter()

    inst.Transform:SetFromProxy(proxy.GUID)

    inst:Remove()
end

local function hit_fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()

    inst:AddTag("FX")
	   
    inst.persists = false
    inst:DoTaskInTime(0.5, inst.Remove)

    return inst
end

local function aura_attack()
    return common("idle")
end

return Prefab("aura_attack", aura_attack, assets),
		Prefab("eye_charge_hit", hit_fn)