local assets =
{
    Asset("ANIM", "anim/aurabit.zip"),
	
	Asset("ATLAS", "images/inventoryimages/aurabit.xml"),
    Asset("IMAGE", "images/inventoryimages/aurabit.tex"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aurabit")
    inst.AnimState:SetBuild("aurabit")
    inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("edible")
    inst.components.edible.healthvalue = 10
    inst.components.edible.sanityvalue = 10

	
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "aurabit"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aurabit.xml"

    return inst
end

return Prefab("aurabit", fn, assets)