local assets =
{
    Asset("ANIM", "anim/aurabit.zip"),
	
	Asset("ATLAS", "images/inventoryimages/aurabitdummy.xml"),
    Asset("IMAGE", "images/inventoryimages/aurabitdummy.tex"),
}

local prefabs = 
{
	"aurabit",
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("aurabit")
    inst.AnimState:SetBuild("aurabit")
    inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("edible")
    inst.components.edible.healthvalue = 10
    inst.components.edible.sanityvalue = 10
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(0.1)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "aurabit"

	
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "aurabitdummy"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aurabitdummy.xml"

    return inst
end

return Prefab("aurabitdummy", fn, assets)