
local assets=
{
    Asset("ANIM", "anim/aurasphere.zip"),
    Asset("ANIM", "anim/swap_aurasphere.zip"),
 
    Asset("ATLAS", "images/inventoryimages/aurasphere.xml"),
    Asset("IMAGE", "images/inventoryimages/aurasphere.tex"),
}

local prefabs =
{
	"auraspherefire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function onattack_aurasphere(inst, attacker, target)
	if GetModConfigData("spherecost", modnameActual) == "low" then
		if attacker and attacker.components.sanity and attacker.components.hunger then
        attacker.components.sanity:DoDelta(-1)
		attacker.components.hunger:DoDelta(-1)
		end
	else
		if GetModConfigData("spherecost", modnameActual) == "free" then
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-0)
			attacker.components.hunger:DoDelta(-0)
			end
		else	
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-3)
			attacker.components.hunger:DoDelta(-3)
			end	
		end
	end	
end

local function fn()
	local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()	
    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(50/255, 150/255, 255/255)
    inst.Light:SetFalloff(1)
    inst.Light:SetRadius(1)
    inst.Light:Enable(true)

	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("aurasphere")
    inst.AnimState:SetBuild("aurasphere")
    inst.AnimState:PlayAnimation("idle")
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_aurasphere", "swap_aurasphere")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")		

		inst.fire = SpawnPrefab("auraspherefire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)     
	end
 
    local function OnUnequip(inst, owner)		
		inst.fire:Remove()
		inst.fire = nil
	
		owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
	end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "aurasphere"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/aurasphere.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_aurasphere)
    inst.components.weapon:SetDamage(25)
    inst.components.weapon:SetRange(6, 8)
	inst.components.weapon:SetProjectile("aura_attack")
	
	if GetModConfigData("spheredurability", modnameActual) == "yes" then
	    inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(200)
		inst.components.finiteuses:SetUses(200)
		
	    inst.components.finiteuses:SetOnFinished(inst.Remove)
	end		
	
	
    return inst	
	
end			
	
return  Prefab("common/inventory/aurasphere", fn, assets)