local assets =
{
    Asset("ANIM", "anim/bonerush.zip"),
    Asset("ANIM", "anim/swap_bonerush.zip"),
 
    Asset("ATLAS", "images/inventoryimages/bonerush.xml"),
    Asset("IMAGE", "images/inventoryimages/bonerush.tex"),
}

local prefabs =
{
	"bonerushfire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()	

    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
    inst.Light:SetColour(237/255, 237/255, 209/255)
    inst.Light:SetFalloff(1)
    inst.Light:SetRadius(1)
    inst.Light:Enable(true)

    inst.AnimState:SetBank("bonerush")
    inst.AnimState:SetBuild("bonerush")
    inst.AnimState:PlayAnimation("idle")
	
	local function onequip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_bonerush", "swap_bonerush")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")

		inst.fire = SpawnPrefab("bonerushfire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)    
	end

	local function onunequip(inst, owner)
		inst.fire:Remove()
		inst.fire = nil
		
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
	end	

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(42.5)

    -------
	if GetModConfigData("bonerushpickaxe", modnameActual) == "yes" then
		inst:AddComponent("tool")
		inst.components.tool:SetAction(ACTIONS.MINE, 1.33)		
	end	
	

	if GetModConfigData("meleedurability", modnameActual) == "yes" then
		inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(300)
		inst.components.finiteuses:SetUses(300)
		if GetModConfigData("bonerushpickaxe", modnameActual) == "yes" then
			inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 3)	
		end		

		inst.components.finiteuses:SetOnFinished(inst.Remove)		
	end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "bonerush"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bonerush.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab( "bonerush", fn, assets)