local assets = 
{
	Asset("ANIM", "anim/bonesharddummy.zip"),

	Asset("ATLAS", "images/inventoryimages/bonesharddummy.xml"),
    Asset("IMAGE", "images/inventoryimages/bonesharddummy.tex"),
}

local prefabs = 
{
	"boneshard",
}

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    anim:SetBank("bonesharddummy")
    anim:SetBuild("bonesharddummy")
    anim:PlayAnimation("idle",false)

    MakeInventoryFloatable(inst, "idle_water", "idle")

    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "bonesharddummy"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bonesharddummy.xml"

    inst:AddComponent("stackable")

    inst:AddComponent("appeasement")
    inst.components.appeasement.appeasementvalue = TUNING.APPEASEMENT_TINY
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(.01)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "boneshard"	

	return inst
end

return Prefab("bonesharddummy", fn, assets)
