
local assets=
{
    Asset("ANIM", "anim/dreamsphere.zip"),
    Asset("ANIM", "anim/swap_dreamsphere.zip"),
 
    Asset("ATLAS", "images/inventoryimages/dreamsphere.xml"),
    Asset("IMAGE", "images/inventoryimages/dreamsphere.tex"),
}

local prefabs =
{
	"dreamspherefire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function onattack_dreamsphere(inst, attacker, target)
	if GetModConfigData("spherecost", modnameActual) == "low" then
		if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-5)
			attacker.components.hunger:DoDelta(-5)
		end
	
			if target.components.sleeper ~= nil then
			target.components.sleeper:AddSleepiness(1, 15, inst)
		elseif target.components.grogginess ~= nil then
			target.components.grogginess:AddGrogginess(1, 15)
		end
 
		if target.components.combat ~= nil and not target:HasTag("player") then
			target.components.combat:SuggestTarget(attacker)
		end
		target:PushEvent("attacked", { attacker = attacker, damage = 0, weapon = inst })
	else
		if GetModConfigData("spherecost", modnameActual) == "free" then
			if attacker and attacker.components.sanity and attacker.components.hunger then
				attacker.components.sanity:DoDelta(-0)
				attacker.components.hunger:DoDelta(-0)
			end
	
				if target.components.sleeper ~= nil then
				target.components.sleeper:AddSleepiness(1, 15, inst)
			elseif target.components.grogginess ~= nil then
				target.components.grogginess:AddGrogginess(1, 15)
			end
 
			if target.components.combat ~= nil and not target:HasTag("player") then
				target.components.combat:SuggestTarget(attacker)
			end
			target:PushEvent("attacked", { attacker = attacker, damage = 0, weapon = inst })
		else	
			if attacker and attacker.components.sanity and attacker.components.hunger then
				attacker.components.sanity:DoDelta(-10)
				attacker.components.hunger:DoDelta(-10)
			end
	
				if target.components.sleeper ~= nil then
				target.components.sleeper:AddSleepiness(1, 15, inst)
			elseif target.components.grogginess ~= nil then
				target.components.grogginess:AddGrogginess(1, 15)
			end
 
			if target.components.combat ~= nil and not target:HasTag("player") then
				target.components.combat:SuggestTarget(attacker)
			end
			target:PushEvent("attacked", { attacker = attacker, damage = 0, weapon = inst })
		end
	end
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()	
    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(100/255, 205/255, 100/255)
    inst.Light:SetFalloff(1)
    inst.Light:SetRadius(1)
    inst.Light:Enable(true)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("dreamsphere")
    inst.AnimState:SetBuild("dreamsphere")
    inst.AnimState:PlayAnimation("idle")
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_dreamsphere", "swap_aurasphere")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")		

		inst.fire = SpawnPrefab("dreamspherefire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)     
	end
 
    local function OnUnequip(inst, owner)		
		inst.fire:Remove()
		inst.fire = nil
	
		owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
	end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "dreamsphere"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/dreamsphere.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_dreamsphere)
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("dreamaura_attack")
	
	if GetModConfigData("spheredurability", modnameActual) == "yes" then
	    inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(150)
		inst.components.finiteuses:SetUses(150)
		
	    inst.components.finiteuses:SetOnFinished(inst.Remove)
	end		
		
    return inst
	
end		
	
return  Prefab("common/inventory/dreamsphere", fn, assets)