local assets=
{
    Asset("ANIM", "anim/lucariofur.zip"),
	
	Asset("ATLAS", "images/inventoryimages/lucariofur.xml"),
    Asset("IMAGE", "images/inventoryimages/lucariofur.tex"),
}


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("lucariofur")
    anim:SetBuild("lucariofur")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "lucariofur"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lucariofur.xml"
 
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM


    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
    
    MakeSmallBurnable(inst, TUNING.LARGE_BURNTIME)
    MakeSmallPropagator(inst)
    
    
    return inst
end

return Prefab( "lucariofur", fn, assets) 
