local assets =
{ 
    Asset("ANIM", "anim/lucariohat.zip"),
    Asset("ANIM", "anim/lucariohat_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/lucariohat.xml"),
    Asset("IMAGE", "images/inventoryimages/lucariohat.tex"),
}

local prefabs = 
{
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "lucariohat_swap", "swap_hat")

    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAIR")
    end

    if inst.components.fueled ~= nil then
		inst.components.fueled:StartConsuming()
    end			
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
    end
	
	if inst.components.fueled ~= nil then
        inst.components.fueled:StopConsuming()
    end		
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("lucariohat")
    inst.AnimState:SetBuild("lucariohat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")
	
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst:AddTag("waterproofer")

		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	end
    
	inst:AddComponent("inspectable")

    inst:AddComponent("tradable")
	
--	if GetModConfigData("hatdurability", modnameActual) == "yes" then
--        inst:AddComponent("fueled")
--        inst.components.fueled.fueltype = FUELTYPE.USAGE
--        inst.components.fueled:InitializeFuelLevel(3.00 * TUNING.TOPHAT_PERISHTIME )
--        inst.components.fueled:SetDepletedFn(--[[generic_perish]]inst.Remove)
--	end		

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lucariohat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lucariohat.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL

    return inst	
end	

return  Prefab("common/inventory/lucariohat", fn, assets, prefabs)