local assets =
{ 
    Asset("ANIM", "anim/lucariohati.zip"),
    Asset("ANIM", "anim/lucariohati_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/lucariohati.xml"),
    Asset("IMAGE", "images/inventoryimages/lucariohati.tex"),
}

local prefabs = 
{
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "lucariohati_swap", "swap_hat")

    owner.AnimState:Show("HAT")
	
    if inst.components.fueled ~= nil then
		inst.components.fueled:StartConsuming()
    end			
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
	
	if inst.components.fueled ~= nil then
        inst.components.fueled:StopConsuming()
    end			
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("lucariohati")
    inst.AnimState:SetBuild("lucariohati")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")
	
	if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
		inst:AddTag("waterproofer")

		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	end
    
	inst:AddComponent("inspectable")

    inst:AddComponent("tradable")
	
--	if GetModConfigData("hatdurability", modnameActual) == "yes" then
--        inst:AddComponent("fueled")
--        inst.components.fueled.fueltype = FUELTYPE.USAGE
--        inst.components.fueled:InitializeFuelLevel(3.00 * TUNING.TOPHAT_PERISHTIME )
--        inst.components.fueled:SetDepletedFn(--[[generic_perish]]inst.Remove)
--	end	

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "lucariohati"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lucariohati.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL

    return inst	
end	

return  Prefab("common/inventory/lucariohati", fn, assets, prefabs)