local assets =
{
    Asset("ANIM", "anim/metalclaw.zip"),
    Asset("ANIM", "anim/swap_metalclaw.zip"),
 
    Asset("ATLAS", "images/inventoryimages/metalclaw.xml"),
    Asset("IMAGE", "images/inventoryimages/metalclaw.tex"),
}

local prefabs =
{
	"bonerushfire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()
	
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("metalclaw")
    inst.AnimState:SetBuild("metalclaw")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("sharp")
	
	local function onequip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_metalclaw", "swap_metalclaw")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")

		inst.fire = SpawnPrefab("bonerushfire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)    
	end

	local function onunequip(inst, owner)
		inst.fire:Remove()
		inst.fire = nil
		
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
	end	

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(36)

    -------

	if GetModConfigData("meleedurability", modnameActual) == "yes" then
		inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(300)
		inst.components.finiteuses:SetUses(300)

		inst.components.finiteuses:SetOnFinished(inst.Remove)		
	end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "metalclaw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/metalclaw.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab( "metalclaw", fn, assets)