
local MakePlayerCharacter = require ("prefabs/player_common")

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
		Asset( "IMAGE", "images/hud/auratab.tex" ),
        Asset( "ATLAS", "images/hud/auratab.xml" ), 

        Asset( "ANIM", "anim/mlucario.zip" ),	
		Asset( "ANIM", "anim/lucario_beard.zip" ),
}

local prefabs = 
{
	"aurabit",
	"aurabitdummy",
	"aurasphere",
	"aurastaff",	
	"bonerush",
	"boneshard",
	"bonesharddummy",
	"beardhair",
	"dreamsphere",
	"lucariofur",
	"lucariohat",
	"lucariohati",	
	"metalclaw",
	"shadowclaw",
	"solarsphere",
	"swiftsphere",
	"violentsphere",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

-- Custom starting items
local start_inv = {
	"aurasphere",
}

--Conditional Stats
local function healthlevel(inst)

	local health_mult = 1.2
	local conditional_sanity = 1
	
	if inst.condition == "hurt" then
		health_mult = 1.3
		conditional_sanity = 1.1

	elseif inst.condition == "badlyhurt" then
		health_mult = 1.4
		conditional_sanity = 1.3

	elseif inst.condition == "critical" then
		health_mult = 1.5
		conditional_sanity = 1.5	

	elseif inst.condition == "byathread" then
		health_mult = 2.0
		conditional_sanity = 2.0
	end	
	
	if GetModConfigData("sanitydifficulty", modnameActual) == "hard" then
		inst.components.sanity.night_drain_mult = 1 * conditional_sanity
		inst.components.sanity.neg_aura_mult = 1.5 * conditional_sanity
	else
		if GetModConfigData("sanitydifficulty", modnameActual) == "easy" then
			inst.components.sanity.night_drain_mult = 0.3 * conditional_sanity
			inst.components.sanity.neg_aura_mult = 0.5 * conditional_sanity
		else
			if GetModConfigData("sanitydifficulty", modnameActual) == "off" then
				inst.components.sanity.night_drain_mult = 0 * conditional_sanity
				inst.components.sanity.neg_aura_mult = 0 * conditional_sanity
			else
				inst.components.sanity.night_drain_mult = 0.6 * conditional_sanity
				inst.components.sanity.neg_aura_mult = 1 * conditional_sanity
			end	
		end
	end	

	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = health_mult	
	
end

--Health Condition Changes
local function healthconditionchange (inst, data)
	local health = data.newpercent
	
    --Change Condition
	if health > .75 then
		if inst.condition ~= "fine" then
			inst.condition = "fine"
			inst.components.talker:Say("Much better.")
		end	

	elseif health > .5 and health <= .75 then
		if inst.condition ~= "hurt" then	
			inst.condition = "hurt"
		end
	elseif health > .25 and health <= .5 then
		if inst.condition ~= "badlyhurt" and inst.condition ~= "critical" and inst.condition ~= "byathread" then
			inst.condition = "badlyhurt"
			inst.components.talker:Say("The aura comes to my aid.")
		elseif inst.condition ~= "badlyhurt" then
			inst.condition = "badlyhurt"					
		end
	elseif health > .1 and health <= .25 then
		if inst.condition ~= "critical"	and inst.condition ~= "byathread" then
			inst.condition = "critical"
			inst.components.talker:Say("Feel the aura's wrath!")
		elseif inst.condition ~= "critical" then
			inst.condition = "critical"		
		end
	elseif health <= .1 then
		if inst.condition ~= "byathread" then	
			inst.condition = "byathread"
			inst.components.talker:Say("Everything is going dark...")	
		end	
	end	

	healthlevel(inst)
end

-- Fire Sanity Loss
local function sanityfn(inst)
    local x, y, z = inst.Transform:GetWorldPosition() 
    local delta = 0
    local max_rad = 10
    local ents = TheSim:FindEntities(x, y, z, max_rad, { "fire" })
    for i, v in ipairs(ents) do
        if v.components.burnable ~= nil and v.components.burnable:IsBurning() then
            local rad = v.components.burnable:GetLargestLightRadius() or 1
            local sz = -TUNING.SANITYAURA_TINY * math.min(max_rad, rad) / max_rad
            local distsq = inst:GetDistanceSqToInst(v) - 9
            -- shift the value so that a distance of 3 is the minimum
            delta = delta + sz / math.max(3, distsq)
        end
    end
    return delta
end

local fn = function(inst)

	-- immune to poison, but still need the poisonable component
	if IsDLCInstalled(CAPY_DLC) and IsDLCEnabled(CAPY_DLC) then
		inst:RemoveTag("poisonable")
		inst.components.health.vulnerabletopoisondamage = false
		inst.components.health.poison_damage_scale = 0
	end	

	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "mlucario.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(140)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(200)
	inst.components.health.fire_damage_scale = 4.0
	inst.components.sanity.custom_rate_fn = sanityfn	
	
	-- Hunger rate (optional)
	if GetModConfigData("hungerdifficulty", modnameActual) == "hard" then
		inst.components.hunger.hungerrate = 1.6 * TUNING.WILSON_HUNGER_RATE
	else
		if GetModConfigData("hungerdifficulty", modnameActual) == "easy" then
			inst.components.hunger.hungerrate = 0.5 * TUNING.WILSON_HUNGER_RATE
		else
			if GetModConfigData("hungerdifficulty", modnameActual) == "off" then
				inst.components.hunger.hungerrate = 0 * TUNING.WILSON_HUNGER_RATE
			else
				inst.components.hunger.hungerrate = 1.1 * TUNING.WILSON_HUNGER_RATE
			end	
		end
	end	

	if GetModConfigData("customitems", modnameActual) == "enabled" then
		--Crafting
		STRINGS.TABS.Aura = "Aura"
		local auratab = {str = "Aura", sort=448, icon = "auratab.tex", icon_atlas = "images/hud/auratab.xml"}
		inst.components.builder:AddRecipeTab(auratab)
	
		local aurasphere = Ingredient( "aurasphere", 1)
		aurasphere.atlas = "images/inventoryimages/aurasphere.xml"

		local aurabit = Ingredient( "aurabit", 3)
		aurabit.atlas = "images/inventoryimages/aurabit.xml"
	
		local lucariofur = Ingredient( "lucariofur", 6)
		lucariofur.atlas = "images/inventoryimages/lucariofur.xml"
	
		local metalclaw = Ingredient( "metalclaw", 1)
		metalclaw.atlas = "images/inventoryimages/metalclaw.xml"
	
		local solarsphere = Ingredient( "solarsphere", 1)
		solarsphere.atlas = "images/inventoryimages/solarsphere.xml"

		local AuraBitRecipe = Recipe("aurabit", {Ingredient("rabbit", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
		AuraBitRecipe.atlas = "images/inventoryimages/aurabit.xml"	

		if GetModConfigData("aurasphere", modnameActual) == "enabled" then
			local AurasphereRecipe = Recipe("aurasphere", {aurabit}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
			AurasphereRecipe.atlas = "images/inventoryimages/aurasphere.xml"

			if GetModConfigData("aurastaff", modnameActual) == "enabled" then
				local AurastaffRecipe = Recipe("aurastaff", {aurasphere, Ingredient("icestaff", 1), Ingredient("goldnugget", 2)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				AurastaffRecipe.atlas = "images/inventoryimages/aurastaff.xml"			
			end
			if GetModConfigData("dreamsphere", modnameActual) == "enabled" then
				local DreamsphereRecipe = Recipe("dreamsphere", {aurasphere, Ingredient("greengem", 1), Ingredient("panflute", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				DreamsphereRecipe.atlas = "images/inventoryimages/dreamsphere.xml"
			end
			if GetModConfigData("solarsphere", modnameActual) == "enabled" then
				local SolarsphereRecipe = Recipe("solarsphere", {aurasphere, Ingredient("redgem", 2), Ingredient("gunpowder", 5)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				SolarsphereRecipe.atlas = "images/inventoryimages/solarsphere.xml"
				
				if GetModConfigData("violentsphere", modnameActual) == "enabled" then
					local ViolentsphereRecipe = Recipe("violentsphere", {solarsphere, Ingredient("redgem", 3), Ingredient("nightmarefuel", 3)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
					ViolentsphereRecipe.atlas = "images/inventoryimages/violentsphere.xml"
				end
			end	
			if GetModConfigData("swiftsphere", modnameActual) == "enabled" then
				local SwiftsphereRecipe = Recipe("swiftsphere", {aurasphere, Ingredient("cane", 1), Ingredient("goldnugget", 2)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				SwiftsphereRecipe.atlas = "images/inventoryimages/swiftsphere.xml"
			end				
		end

		if GetModConfigData("bonerush", modnameActual) == "enabled" then		
			if IsDLCEnabled(REIGN_OF_GIANTS) or IsDLCEnabled(CAPY_DLC) then
				local BonerushRecipe = Recipe("bonerush", {aurabit, Ingredient("boneshard", 2)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				BonerushRecipe.atlas = "images/inventoryimages/bonerush.xml"
		
				local BoneshardRecipe = Recipe("boneshard", {Ingredient("fish", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})		
			else
				local Bonerush2Recipe = Recipe("bonerush", {aurabit, Ingredient("houndstooth", 2)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				Bonerush2Recipe.atlas = "images/inventoryimages/bonerush.xml"	
			end
		end	
	
		if IsDLCEnabled(CAPY_DLC) then
			local Boneshard2Recipe = Recipe("bonesharddummy", {Ingredient("tropical_fish", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
			Boneshard2Recipe.atlas = "images/inventoryimages/bonesharddummy.xml"	
			local AuraBit2Recipe = Recipe("aurabitdummy", {Ingredient("crab", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
			AuraBit2Recipe.atlas = "images/inventoryimages/aurabitdummy.xml"
		end

		if GetModConfigData("lucariohattoggle", modnameActual) == "enabled" then
			local LucarioHatRecipe = Recipe("lucariohat", {Ingredient("strawhat", 1), aurabit, lucariofur}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
			LucarioHatRecipe.atlas = "images/inventoryimages/lucariohat.xml"

			if GetModConfigData("lucariohatitoggle", modnameActual) == "enabled" then
				local LucarioHatiRecipe = Recipe("lucariohati", {Ingredient("strawhat", 1), aurabit, lucariofur}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				LucarioHatiRecipe.atlas = "images/inventoryimages/lucariohati.xml"
			end
		end

		if GetModConfigData("claws", modnameActual) == "enabled" then
			local MetalClawRecipe = Recipe("metalclaw", {Ingredient("rocks", 4), Ingredient("flint", 1)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
			MetalClawRecipe.atlas = "images/inventoryimages/metalclaw.xml"

			if GetModConfigData("shadowclaw", modnameActual) == "enabled" then			
				local ShadowClawRecipe = Recipe("shadowclaw", {metalclaw, Ingredient("nightmarefuel", 3)}, auratab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
				ShadowClawRecipe.atlas = "images/inventoryimages/shadowclaw.xml"
			end
		end	
	end



	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	
	inst:ListenForEvent("healthdelta", healthconditionchange)
	healthlevel(inst)
	
end

return MakePlayerCharacter("mlucario", prefabs, assets, fn, start_inv)
