local assets =
{
    Asset("ANIM", "anim/shadowclaw.zip"),
    Asset("ANIM", "anim/swap_shadowclaw.zip"),
 
    Asset("ATLAS", "images/inventoryimages/shadowclaw.xml"),
    Asset("IMAGE", "images/inventoryimages/shadowclaw.tex"),
}

local prefabs =
{
	"shadowclawfire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddLight()	

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("shadowclaw")
    inst.AnimState:SetBuild("shadowclaw")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("sharp")
	inst:AddTag("shadow")
	
	local function onequip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_shadowclaw", "swap_metalclaw")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")

		inst.fire = SpawnPrefab("shadowclawfire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)    
	end

	local function onunequip(inst, owner)
		inst.fire:Remove()
		inst.fire = nil
		
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
	end	

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(68)

    -------

	if GetModConfigData("meleedurability", modnameActual) == "yes" then
		inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(200)
		inst.components.finiteuses:SetUses(200)

		inst.components.finiteuses:SetOnFinished(inst.Remove)		
	end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "shadowclaw"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowclaw.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.dapperness = TUNING.CRAZINESS_SMALL

    return inst
end

return Prefab( "shadowclaw", fn, assets)