
local assets=
{
    Asset("ANIM", "anim/solarsphere.zip"),
    Asset("ANIM", "anim/swap_solarsphere.zip"),
 
    Asset("ATLAS", "images/inventoryimages/solarsphere.xml"),
    Asset("IMAGE", "images/inventoryimages/solarsphere.tex"),
}

local prefabs =
{
	"solarspherefire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function onattack_solarsphere(inst, attacker, target)
	if GetModConfigData("spherecost", modnameActual) == "low" then
		if attacker and attacker.components.sanity and attacker.components.hunger then
		attacker.components.sanity:DoDelta(-3)
		attacker.components.hunger:DoDelta(-3)
		end
	else
		if GetModConfigData("spherecost", modnameActual) == "free" then
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-0)
			attacker.components.hunger:DoDelta(-0)
			end
		else		
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-7)
			attacker.components.hunger:DoDelta(-7)
			end
		end
	end	
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()	
    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(197/255, 197/255, 50/255)
    inst.Light:SetFalloff(0.6)
    inst.Light:SetRadius(4)
    inst.Light:Enable(true)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("solarsphere")
    inst.AnimState:SetBuild("solarsphere")
    inst.AnimState:PlayAnimation("idle")
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_solarsphere", "swap_aurasphere")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")		

		inst.fire = SpawnPrefab("solarspherefire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)     
	end
 
    local function OnUnequip(inst, owner)		
		inst.fire:Remove()
		inst.fire = nil
	
		owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
	end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "solarsphere"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/solarsphere.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_solarsphere)
    inst.components.weapon:SetDamage(50)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("solar_attack")

	if GetModConfigData("spheredurability", modnameActual) == "yes" then
	    inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(300)
		inst.components.finiteuses:SetUses(300)
		
	    inst.components.finiteuses:SetOnFinished(inst.Remove)
	end		
	
    return inst
	
end	
	
return  Prefab("common/inventory/solarsphere", fn, assets)