
local assets=
{
    Asset("ANIM", "anim/swiftsphere.zip"),
    Asset("ANIM", "anim/swap_swiftsphere.zip"),
 
    Asset("ATLAS", "images/inventoryimages/swiftsphere.xml"),
    Asset("IMAGE", "images/inventoryimages/swiftsphere.tex"),
}

local prefabs =
{
	"swiftspherefire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function onattack_swiftsphere(inst, attacker, target)
	if GetModConfigData("spherecost", modnameActual) == "low" then
		if attacker and attacker.components.sanity and attacker.components.hunger then
        attacker.components.sanity:DoDelta(-2)
		attacker.components.hunger:DoDelta(-2)
		end
	else
		if GetModConfigData("spherecost", modnameActual) == "free" then
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-0)
			attacker.components.hunger:DoDelta(-0)
			end
		else		
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-5)
			attacker.components.hunger:DoDelta(-5)
			end
		end
	end	
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()	
    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(255/255, 255/255, 100/255)
    inst.Light:SetFalloff(1)
    inst.Light:SetRadius(1)
    inst.Light:Enable(true)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("swiftsphere")
    inst.AnimState:SetBuild("swiftsphere")
    inst.AnimState:PlayAnimation("idle")
 
    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_swiftsphere", "swap_aurasphere")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")		

		inst.fire = SpawnPrefab("swiftspherefire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)     
	end
 
    local function OnUnequip(inst, owner)		
		inst.fire:Remove()
		inst.fire = nil
	
		owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
	end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "swiftsphere"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/swiftsphere.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT

	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_swiftsphere)
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("swiftaura_attack")
	
	if GetModConfigData("spheredurability", modnameActual) == "yes" then
	    inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(400)
		inst.components.finiteuses:SetUses(400)
		
	    inst.components.finiteuses:SetOnFinished(inst.Remove)
	end		
	
	
    return inst

end		


	
return  Prefab("common/inventory/swiftsphere", fn, assets)