
local assets=
{
    Asset("ANIM", "anim/violentsphere.zip"),
    Asset("ANIM", "anim/swap_violentsphere.zip"),
 
    Asset("ATLAS", "images/inventoryimages/violentsphere.xml"),
    Asset("IMAGE", "images/inventoryimages/violentsphere.tex"),
}

local prefabs =
{
	"violentspherefire",
}

local modnameFancy = "Lucario"
local modnameActual = KnownModIndex:GetModActualName(modnameFancy)

local function OnDropped(inst)
    inst.Light:Enable(true)
end

local function OnPickup(inst)
    inst.Light:Enable(false)
end

local function onattack_violentsphere(inst, attacker, target)
	if GetModConfigData("spherecost", modnameActual) == "low" then
		if attacker and attacker.components.sanity and attacker.components.health then
        attacker.components.sanity:DoDelta(-5)
		attacker.components.health:DoDelta(-5)
		end
	else
		if GetModConfigData("spherecost", modnameActual) == "free" then
			if attacker and attacker.components.sanity and attacker.components.hunger then
			attacker.components.sanity:DoDelta(-0)
			attacker.components.health:DoDelta(-0)
			end
		else		
			if attacker and attacker.components.sanity and attacker.components.health then
			attacker.components.sanity:DoDelta(-10)
			attacker.components.health:DoDelta(-10)
			end
		end
	end	
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddLight()	
    MakeInventoryPhysics(inst)
	
	inst.Light:SetIntensity(.75)
	inst.Light:SetColour(255/255, 50/255, 50/255)
    inst.Light:SetFalloff(1)
    inst.Light:SetRadius(1)
    inst.Light:Enable(true)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
	inst.AnimState:SetBank("violentsphere")
    inst.AnimState:SetBuild("violentsphere")
    inst.AnimState:PlayAnimation("idle")

    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_violentsphere", "swap_aurasphere")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")		

		inst.fire = SpawnPrefab("violentspherefire")
		local follower = inst.fire.entity:AddFollower()
		follower:FollowSymbol(owner.GUID, "swap_object", 0, -110, 1)     
	end
 
    local function OnUnequip(inst, owner)		
		inst.fire:Remove()
		inst.fire = nil
	
		owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
	end
 
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "violentsphere"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/violentsphere.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )

	inst:AddComponent("inspectable")
			
	inst:AddTag("shadow")
 	inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack_violentsphere)
    inst.components.weapon:SetDamage(100)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("violentaura_attack")

	if GetModConfigData("spheredurability", modnameActual) == "yes" then
	    inst:AddComponent("finiteuses")
		inst.components.finiteuses:SetMaxUses(150)
		inst.components.finiteuses:SetUses(150)
		
	    inst.components.finiteuses:SetOnFinished(inst.Remove)
	end			

    return inst

end	



return  Prefab("common/inventory/violentsphere", fn, assets)