// This file is generated by the scripts available at https://github.com/hauuau/magpie-prescalers
// Please don't edit this file directly.
// Generated by: nnedi3.py --nns 16 --win 8x6 --use-compute-shader --use-magpie
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

//!MAGPIE EFFECT
//!VERSION 4
//!SORT_NAME NNEDI3_016_6

//!TEXTURE
Texture2D INPUT;

//!SAMPLER
//!FILTER POINT
SamplerState sam_INPUT;

//!TEXTURE
//!WIDTH  INPUT_WIDTH * 1 * 2
//!HEIGHT INPUT_HEIGHT * 2 * 1
Texture2D OUTPUT;

//!SAMPLER
//!FILTER LINEAR
SamplerState sam_INPUT_LINEAR;

//!TEXTURE
//!FORMAT R16_FLOAT
//!WIDTH  INPUT_WIDTH * 1
//!HEIGHT INPUT_HEIGHT * 2
Texture2D temp;

//!SAMPLER
//!FILTER POINT
SamplerState sam_temp;

//!COMMON
#include "prescalers.hlsli"

#define LAST_PASS 2

//!PASS 1
//!DESC NNEDI3 (double_y, nns16, win8x6)
//!IN INPUT
//!OUT temp
//!BLOCK_SIZE 32, 16
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 =
		W(0, -1126897990, 1027745880, 1024250604, 1024642508) + W(1, -1121959908, -1149906049, -1130469888, -1121396864)
		+ W(2, 1039079928, -1107295041, -1147395201, -1126556538)
		+ W(3, -1113607518, 1041026790, 1022159130, 1044630722) + W(4, -1107136294, 1005058137, -1116173177, 1042195560)
		+ W(5, -1098313415, 999141354, 1019497054, 1007702352) + W(6, 1015526727, 1018714920, 1042189511, -1106681307)
		+ W(7, 1035880216, -1121374916, -1133977224, 1026239260)
		+ W(8, -1106606352, 1038936227, -1124106064, 1025050132) + W(9, 990390561, -1131068140, 1013770942, -1122507740)
		+ W(10, -1136584888, -1135809122, -1122292152, 1015308851)
		+ W(11, -1122039043, 1031978820, -1116330759, 1018900008);
	sum2 = W(0, 1017133506, 1011515348, -1139818306, -1123730089) + W(1, 996184056, -1138856554, 1023321012, 1029416248)
		 + W(2, -1115999672, 1020129658, 1015618084, 1007066512)
		 + W(3, -1119553894, 1057587887, -1090489276, -1109933138)
		 + W(4, 1016266760, -1145378916, -1112177411, 1071604647)
		 + W(5, -1079392139, -1097028615, 1028448562, 1008681896)
		 + W(6, -1165256880, 1051025857, -1098617840, -1105405946)
		 + W(7, -1155286464, 1000343320, -1133574805, 1035052104)
		 + W(8, -1139515542, -1135392452, -1138601606, 991053648)
		 + W(9, 1020043526, 1010374724, -1121583660, -1142174380)
		 + W(10, 997185888, -1155288808, -1135761830, 1018728192)
		 + W(11, 1024878156, 1002597928, -1131188096, -1132781834);
	WS(1018288640, 1027735986);
	sum1 =
		W(0, 1012158232, -1178449286, 1044498160, -1128542910) + W(1, -1115962871, 1002517720, 1006778572, -1114624234)
		+ W(2, 1032943202, 1027108853, 1017365062, 964628492) + W(3, 1025063871, -1104570115, 1059928494, -1088743921)
		+ W(4, 1032615126, -1134936888, -1156175041, 1028919475)
		+ W(5, -1097612337, -1106124541, 1026836706, -1146238776)
		+ W(6, 1010747802, 1034856692, -1085331503, 1059914122)
		+ W(7, -1114177498, 1020458158, -1140348884, -1127457566)
		+ W(8, 1031833306, 1032056909, -1122073627, 1016604174) + W(9, 1020162890, -1122825993, -1119592595, 1033999672)
		+ W(10, 1022377282, 998219705, -1172026051, -1115773453)
		+ W(11, 1038136595, 1027508251, -1129465364, 1023799671);
	sum2 =
		W(0, -1126840972, -1130460798, 1019075916, 1017322604) + W(1, -1131054760, -1131047996, -1145399745, 985194115)
		+ W(2, -1120812206, -1129997452, 1006903064, -1143360737)
		+ W(3, -1139273136, -1112997847, -1139625904, 1042717692)
		+ W(4, -1114175000, -1130986946, 991527106, -1120456092) + W(5, 1043975251, 1051048254, -1113881740, 1007107280)
		+ W(6, -1135317632, 1001121889, -1150833602, -1121880440)
		+ W(7, 978663174, -1143215153, -1139461992, 1017866680)
		+ W(8, -1128878392, -1112673669, 1026044394, -1125685806)
		+ W(9, -1129486378, 1006765920, -1133504840, -1126929736)
		+ W(10, 1014584312, -1144361281, 995542402, 1000306721)
		+ W(11, -1142139489, -1114488494, 1007041936, -1134951296);
	WS(1042433344, -1111851638);
	sum1 = W(0, -1128612156, -1112658226, -1119638967, 1043958886)
		 + W(1, -1120465263, -1128976934, -1139940268, -1123380939)
		 + W(2, -1126908022, 1033805831, -1115346894, -1142120768)
		 + W(3, -1122042583, -1128727592, -1097703246, 1057665642)
		 + W(4, -1104545545, 1005565040, 984858240, -1107767030)
		 + W(5, 1052387104, 1046318672, -1108167869, -1148354296)
		 + W(6, 999630836, -1114896432, 1054789077, -1095395475)
		 + W(7, 1029397739, -1133849404, -1146630760, -1115281716)
		 + W(8, 1030603948, -1117224401, -1163176544, -1117808895)
		 + W(9, -1126512698, -1129996802, 1028419819, -1123618471)
		 + W(10, -1117439993, 1013349902, 996431920, -1123547845)
		 + W(11, 1026334318, -1113258842, -1134051464, -1120421311);
	sum2 =
		W(0, 1022431497, -1109389142, 1004613154, 1028727631) + W(1, 1029503922, -1132574761, -1132240188, -1119299282)
		+ W(2, -1139248009, -1129989652, -1140046689, -1114039002)
		+ W(3, 1024165374, -1107432916, 1041447926, 1047487962) + W(4, 1017218352, -1135952741, -1114822837, 1044244351)
		+ W(5, -1108646182, -1100679909, 1040665470, -1123756570)
		+ W(6, -1120729932, 1031006195, 1047688354, -1126089152)
		+ W(7, -1120804126, -1148002498, -1124855948, 983982854) + W(8, 1009435309, 1033956847, -1107003694, 1028342876)
		+ W(9, -1126342960, -1158996358, -1122846542, -1123334894)
		+ W(10, -1140927562, -1117057946, -1128289576, -1121099750)
		+ W(11, 1036127241, 1039673953, -1102421772, 1026336008);
	WS(1015433728, 1058400049);
	sum1 =
		W(0, -1139873791, 1031161269, -1113693508, 1033801204) + W(1, -1119172737, -1143910182, -1133909491, 1032977294)
		+ W(2, -1112917766, -1131731326, 989007258, 1019358132) + W(3, 1023506921, -1116372870, -1116140698, 1045725159)
		+ W(4, -1122523445, 1008313039, -1230944644, 1035249566)
		+ W(5, -1103376612, -1102794347, 1044071755, -1115540344)
		+ W(6, -1118840528, -1120831281, 1044830734, -1116748777)
		+ W(7, 1030473357, -1126204226, 1028378783, -1114963068)
		+ W(8, -1141442286, 1032646513, 1018738506, -1118552369)
		+ W(9, -1121050287, 1032892305, 1023234585, -1112562780)
		+ W(10, 1021910870, 1016154651, 1033465034, -1105610222)
		+ W(11, 1034039600, 1030129285, -1122899972, -1124368226);
	sum2 = W(0, -1138428449, -1158711528, -1124467432, -1140697417)
		 + W(1, 1030243467, 1012442941, 992976916, 1013039401) + W(2, -1130455464, -1123518198, 1033499227, 975746961)
		 + W(3, -1142924106, -1128734961, -1113146735, -1099387353)
		 + W(4, 1051222006, -1122081826, 976851025, 1036130613)
		 + W(5, -1097860430, -1077268149, 1072898808, -1117904739)
		 + W(6, 989093448, 1010050489, -1108810723, -1091225653) + W(7, 1056060393, -1131990027, 997652548, -1137359275)
		 + W(8, -1122996798, 1032494444, 1025590581, 951236744) + W(9, -1153131756, 990210276, -1140348735, -1115493835)
		 + W(10, 1025171621, 1006284898, -1134977059, -1138876101)
		 + W(11, -1127238416, 1018469149, 1026307569, -1146863422);
	WS(-1143089152, 1030017260);
	sum1 =
		W(0, 1012276081, -1116644609, 1019444907, -1124688427) + W(1, 1029853709, -1130860131, 1001605962, -1127223379)
		+ W(2, -1119160665, 1035777366, -1136557285, -1130309965)
		+ W(3, 1024406997, -1109637089, 1048989101, -1098625404)
		+ W(4, 1038057505, -1130883561, -1155861797, -1115433381)
		+ W(5, 1044433671, 1006101820, -1111190908, 1009046005) + W(6, -1155627981, 1036571679, -1098184025, 1048780603)
		+ W(7, -1112291813, 1025361773, -1122534699, 1028189701)
		+ W(8, 1039597237, -1104960796, -1130076067, 1018788475)
		+ W(9, 1018348791, -1126280255, -1117935161, 1029641477)
		+ W(10, 1012573277, -1125993892, -1120990241, 1036379833)
		+ W(11, -1136463217, -1111599465, -1154886405, 1020397819);
	sum2 = W(0, -1153319600, 1008405084, -1118973116, -1140784820)
		 + W(1, 1012585128, 1010769460, -1147284080, 985822624) + W(2, 1010505984, -1129308604, 1021293048, 1001814848)
		 + W(3, 1008968960, -1142311064, -1101248908, 1037448945) + W(4, 1024969278, -1160749952, 995456320, 1022276922)
		 + W(5, -1089187936, 1057794596, 1033366347, -1123619202)
		 + W(6, -1140178660, -1140411728, -1109859050, 1029773785)
		 + W(7, 1024400778, -1136545168, -1146954776, 1005012008) + W(8, 1017518401, 1015531414, 1007802556, 1000322872)
		 + W(9, -1142030464, 1003782736, 982409184, 974134143) + W(10, 1003482728, -1152799248, -1170856127, 1006946188)
		 + W(11, 995727232, 960534268, 1009923956, 985284128);
	WS(1064472528, -1121594920);
	sum1 =
		W(0, -1142654991, 1027230343, -1112807213, 1027061019) + W(1, -1128825126, -1164359388, -1143599223, 1032290711)
		+ W(2, -1113392623, 1016010466, 991342574, 1014490160) + W(3, 1014568428, -1136037408, -1115590690, 1034098395)
		+ W(4, 1008695068, -1148094031, 1010500896, 1002050167)
		+ W(5, -1113734161, -1112872467, 1027642302, -1127829894)
		+ W(6, -1124387333, -1122938499, 1038834309, -1130883382)
		+ W(7, 1013984188, -1138058188, 1020884834, -1120250507) + W(8, 1029912912, 1015162858, 1015817710, -1124941766)
		+ W(9, -1131205634, 1025589157, 1019867389, -1123484555)
		+ W(10, 1015459258, 1008886302, 1026841191, -1110863224)
		+ W(11, 1031947569, 1019435182, -1129521612, -1130075526);
	sum2 =
		W(0, 1003807591, -1154115373, 1000124719, 1017182228) + W(1, -1126980607, -1130234859, -1147429191, -1139843175)
		+ W(2, 1001833687, 1024488826, -1116401990, 987658746) + W(3, 1002635095, 1018649088, 1008095031, 1040714709)
		+ W(4, -1105844805, 1013729967, -1132089351, 1016729308)
		+ W(5, -1105992985, 1063780536, -1085442794, 1024604622) + W(6, -1147602519, 1024344696, 1014141127, 1047200342)
		+ W(7, -1101306502, 995366957, -1151072125, -1155997437)
		+ W(8, -1132427785, 1020609216, -1122913939, -1147894927) + W(9, 964968041, 1001714367, -1141957575, 1023684454)
		+ W(10, -1125194898, -1146690231, 1011860423, -1141691791)
		+ W(11, -1139390003, 1017456200, -1128761080, -1146063807);
	WS(1061878800, -1131153991);
	sum1 =
		W(0, -1123872727, 1015115512, -1099302516, 1041224340) + W(1, -1144166978, -1171049230, 1018625288, 1031144036)
		+ W(2, -1102371221, 1009910425, 1014687697, 1022902338) + W(3, -1127640224, 1036357847, -1085394744, 1052022073)
		+ W(4, -1115552350, -1132534141, 1026350045, -1108974562)
		+ W(5, 1059569738, 1058525661, -1125187302, 1016189168) + W(6, 1013916191, -1107191102, 1050617832, -1088226291)
		+ W(7, 1037730450, -1123531112, 1018183052, 1006433282) + W(8, 1032504563, -1097316565, 1040234099, -1127405808)
		+ W(9, -1145362866, 1014427177, 1031877738, -1109508096) + W(10, 1015825508, 1018548825, 1016048056, 1026198990)
		+ W(11, 1033421596, -1098228398, 1035235966, -1137247201);
	sum2 = W(0, -1131301730, 1031269327, -1127010401, -1109842974)
		 + W(1, -1181736700, -1180777340, 973798558, -1131640108)
		 + W(2, 1028981651, -1125259759, -1167651134, -1160957999)
		 + W(3, -1127780866, 1013454096, -1149526184, -1113692773)
		 + W(4, -1123287814, 993986728, 1013478572, -1109509101) + W(5, 1051779317, 1047088883, -1109788940, 1020962386)
		 + W(6, -1160424319, -1117315078, 1028380081, -1134194124)
		 + W(7, -1115287133, -1136947718, -1135840779, -1131160392)
		 + W(8, -1137527992, 1028175261, -1121515979, -1138138790)
		 + W(9, -1164912671, -1145619912, 998238336, 1018886164)
		 + W(10, -1125209194, -1152989064, -1138738786, -1127332243)
		 + W(11, -1148504424, 1027237057, -1142455024, -1123011340);
	WS(-1146021888, 1053974589);
	sum1 =
		W(0, 1029642476, -1119368753, 1042969521, -1095098901) + W(1, 1046685039, 984849429, 1013890275, -1134074211)
		+ W(2, 1042359026, -1107285127, 1031018217, -1135393367)
		+ W(3, -1176939092, 1007708103, 1045769551, -1096985546) + W(4, 1036262392, -1139413615, 1022266947, 1017736689)
		+ W(5, -1101301107, 1034918881, 1003810877, 1024875117) + W(6, -1146466657, 1027345005, -1094644679, 1050538529)
		+ W(7, -1120828825, -1172526890, 1004183253, 1032510570) + W(8, -1091538585, 1051699648, 1011534979, 1017671961)
		+ W(9, -1160650069, 1019378973, -1107179580, 1036824506)
		+ W(10, -1133351451, -1160823333, -1127783457, 1031489314)
		+ W(11, -1095508207, 1048776768, 1035618600, 1006585957);
	sum2 = W(0, 1031363252, -1091101506, 1048232756, 1057852755) + W(1, -1095952784, 1016290300, 1030774484, 1001500224)
		 + W(2, -1110436898, -1132290932, -1131305343, -1126601761)
		 + W(3, 1015165558, -1110787951, 1016237906, 1043794074) + W(4, -1113356328, 1003743696, 1007437656, 965388167)
		 + W(5, 1014973676, 1047525730, -1152923833, 1022650220) + W(6, 1020087968, 1003188992, -1123006886, 1011818344)
		 + W(7, -1111245491, 1021501454, -1158035650, 1041338676)
		 + W(8, -1105090874, -1129296549, -1131940021, 1017537464)
		 + W(9, -1137051446, -1134903850, -1123217223, 1034851396)
		 + W(10, -1117639196, -1133259176, 1018262350, 1033269727)
		 + W(11, -1104724635, -1106365430, 1024945328, 1019937714);
	WS(-1077057896, -1083600334);
	sum1 = W(0, 1017420011, 1011471785, 1029223422, -1116040414) + W(1, 1017123181, 1016511669, 1014201033, 1019976613)
		 + W(2, -1126437509, 1015478313, 1024110818, -1167731667)
		 + W(3, 1017846781, -1138042285, 1049638570, -1103217262) + W(4, 1023111893, 1009386661, 999765850, 1040273597)
		 + W(5, -1090770241, -1087230893, 1030676769, 1023090125)
		 + W(6, -1162024122, 1016487629, 1029091694, 1046437488) + W(7, -1112046985, 1020460717, 985808522, 1027730222)
		 + W(8, 1037672698, 1024768280, -1120839802, 1025489318) + W(9, 1019153993, 1010855969, 1027546578, 1028909230)
		 + W(10, 1023955584, -1134545259, 1011766057, 1025127228)
		 + W(11, 1025680213, 1017109109, -1128064723, 1027741830);
	sum2 =
		W(0, 1023774756, -1107003878, 1020767940, -1118294055) + W(1, -1113997093, 1021408408, -1152708847, 1013240776)
		+ W(2, -1108605887, -1128830540, -1139588328, -1119578529)
		+ W(3, 1005727232, -1108761818, 1050907301, -1097736561)
		+ W(4, 1032528025, -1135972104, -1128030280, 1032847770) + W(5, 1058054639, 1008347200, 1039669350, -1131826954)
		+ W(6, 1004577664, 1024878510, -1106188814, 1049418167) + W(7, -1108856812, 999382680, -1116453887, -1129071264)
		+ W(8, 1040942692, -1105809360, -1104688291, 1019392776)
		+ W(9, 1020705336, -1124253692, -1115446820, 1014050712)
		+ W(10, 1018266740, -1117167612, -1127775332, -1114566712)
		+ W(11, 1042743894, -1132221182, -1103534695, 1022204104);
	WS(1034686080, -1080904524);
	sum1 =
		W(0, -1139332721, 1025190657, -1143163562, 1041601261) + W(1, 1024768205, -1137907141, -1156631187, 1024127465)
		+ W(2, 1040892278, 1028605547, -1129308018, 1012089369) + W(3, 1023562901, 1006799241, -1104914606, 1052908885)
		+ W(4, -1117860929, 1019594656, 1011454089, -1145135178)
		+ W(5, -1089193318, -1091833281, 1036300940, -1143330794)
		+ W(6, 1009225011, -1129417722, 1043909393, -1103073573) + W(7, 1040987970, 992909011, 1012327853, 1017495114)
		+ W(8, -1119873834, 1025246703, 1033652713, -1123933213)
		+ W(9, 1010687981, 1027561839, -1136185891, -1124345098) + W(10, 1024209623, 1018355139, 1010798725, 1010795083)
		+ W(11, -1118482716, 1032670633, 1027144528, -1123266333);
	sum2 =
		W(0, 998154484, -1124228589, -1132108902, -1115676434) + W(1, -1123985162, 1004957466, -1136847690, 1028193069)
		+ W(2, -1123281782, -1123302060, -1132306691, 1011392625)
		+ W(3, -1120010648, 1043298286, -1097765474, 1027211577)
		+ W(4, -1114822183, -1127542967, -1145824866, -1115567961)
		+ W(5, 1059221182, 1034703777, -1131429597, 1022587458) + W(6, 1015307650, -1106126812, 1048600788, -1099334080)
		+ W(7, 1029215805, -1127163397, 994166396, -1111174068) + W(8, -1130476352, 1015056080, 1023836215, -1122559367)
		+ W(9, 1000606426, -1128437454, 1026255089, -1137618020)
		+ W(10, -1127893362, -1171736302, 1010815409, -1110538383)
		+ W(11, -1118584150, 1028199647, 1025007180, -1124423270);
	WS(-1097173920, -1100403112);
	sum1 = W(0, -1133792968, -1126599342, 1026626987, -1109988694)
		 + W(1, -1128510918, -1124691470, -1124511038, -1134319356)
		 + W(2, -1112479512, -1122054529, -1138055228, -1131431128)
		 + W(3, -1133667884, -1113753548, 1051379210, -1097159959)
		 + W(4, 1031366423, -1128464692, -1126404688, -1113718896)
		 + W(5, 1058852431, 1058630415, -1108453759, -1122909907)
		 + W(6, -1129657589, 1034489098, -1097104011, 1049904553)
		 + W(7, -1111244112, 1006087192, -1123548289, 1017816566)
		 + W(8, 1007326848, -1104990865, -1129654222, -1138955724)
		 + W(9, -1134226372, -1122628437, -1112737379, 983139170)
		 + W(10, -1143321192, -1123473736, -1120375479, 1029275393)
		 + W(11, -1116837058, -1110311540, -1132471000, -1149064600);
	sum2 = W(0, -1133003813, -1145103116, -1105221269, 1033080040)
		 + W(1, 1016862101, -1129731365, -1170659932, 1024883426)
		 + W(2, -1117429423, 1028547885, -1128891234, -1147341896)
		 + W(3, 1006656308, -1122208183, -1098340061, 1042272545)
		 + W(4, -1121562483, -1121650606, 1031055883, -1101651786)
		 + W(5, 1055658740, 1058321046, -1100689547, 1031708925)
		 + W(6, -1122785076, -1107240567, 1035604404, -1112738821)
		 + W(7, -1115182870, -1123396988, -1138148825, -1137951645)
		 + W(8, -1131811521, 1003752088, 1026865631, -1133076983)
		 + W(9, -1134424500, -1131665157, -1130287800, 1015669581)
		 + W(10, -1129373191, -1131162259, -1131089901, -1116779622)
		 + W(11, -1123356625, 1033205575, -1134576021, -1127933595);
	WS(1049422752, 1064394145);
	sum1 = W(0, 1016583527, -1106085006, 995307718, 1042273115) + W(1, -1113049442, 1025810280, 997641734, -1123841888)
		 + W(2, 1031369872, 1021597381, -1122854832, 1006187755)
		 + W(3, -1129211865, 1041111742, -1088517333, 1058826428)
		 + W(4, -1113933244, 1019889767, -1131677043, 1032245856)
		 + W(5, -1098988005, -1105331685, 1032610296, -1131685097)
		 + W(6, 1021172552, -1110939130, 1058612208, -1090507155)
		 + W(7, 1037338632, -1155049030, 1021691141, -1105269375)
		 + W(8, 1030057089, 1043687978, -1122591528, -1134096210)
		 + W(9, -1133007562, -1137128282, 1036830720, -1120823228)
		 + W(10, -1116248270, 1025994697, 1026669144, -1106745812)
		 + W(11, 1034516890, 1038691348, -1117945591, -1126546729);
	sum2 = W(0, 1015668141, -1138201662, -1111996311, -1127284815)
		 + W(1, -1125087482, 1020174885, -1124041461, -1140877219)
		 + W(2, -1116450062, -1123578506, 1024732308, -1139064970)
		 + W(3, 1005775275, 1027346708, -1125910350, -1106280325)
		 + W(4, 1034158307, -1133423524, 1015274173, 1016303395)
		 + W(5, -1108948194, 1052974100, 1032925063, -1161498797)
		 + W(6, -1138139200, -1106503093, -1104963655, 1053021197)
		 + W(7, -1107449032, -1134898868, 992639399, -1117618841) + W(8, 1031763952, 957951850, 994113735, 1013272790)
		 + W(9, -1132053353, -1115775134, 1015724405, 1016609913)
		 + W(10, -1132927280, -1132485274, -1129319398, -1122071744)
		 + W(11, 1034411590, -1140595900, -1140186580, -1164791981);
	WS(-1101497152, -1084603877);
	sum1 =
		W(0, -1136425045, 1016522037, 967194407, 1019848413) + W(1, -1129523533, -1142614610, -1140218249, -1157845066)
		+ W(2, 1029505522, -1119357636, -1140249161, -1135395837)
		+ W(3, -1121565262, 1035402982, 1022903246, 1027088345)
		+ W(4, -1121932442, -1148904362, -1122160667, 1027884002)
		+ W(5, -1107598171, 1024422013, -1127296803, 1002411186) + W(6, 1006883159, 1025282390, 1025270942, -1117602990)
		+ W(7, 1030372258, -1130529549, -1132497425, 1022271101)
		+ W(8, -1120772739, 1030415880, -1129818261, 1018540973)
		+ W(9, 1004502690, -1138792353, -1154700189, -1171556244)
		+ W(10, -1138666305, -1138856043, -1128604789, 995143101)
		+ W(11, -1128284203, 1025955498, -1121511513, 1011955033);
	sum2 = W(0, -1126668299, -1131366283, 1024971228, 1000957181)
		 + W(1, -1151515419, 1005199725, -1137964827, -1117612139)
		 + W(2, 1034620123, -1119890411, -1145021381, -1136862175)
		 + W(3, 1015963121, -1097765254, 1049249869, 1026062254) + W(4, 1001872029, 1007955643, 1030757650, -1083955387)
		 + W(5, 1064229708, -1107214224, 1026637176, -1125717658)
		 + W(6, -1137547503, -1103492737, 1047078464, -1122275403)
		 + W(7, 1027173860, -1169614250, 997720155, -1118797430) + W(8, 1017921725, 1016072153, -1135832789, 923654805)
		 + W(9, -1132279825, -1131387718, 1024786888, -1133941049)
		 + W(10, -1148432117, 1002011725, -1152589275, -1140632131)
		 + W(11, -1144191965, 996433547, -1140699475, 1005736109);
	WS(1059552336, -1136539026);
	sum1 =
		W(0, 990367896, 1041343484, -1096612504, 1033353841) + W(1, -1125599349, 1028944863, 1010957914, 1036710283)
		+ W(2, -1107358947, 1029016441, -1132821402, 1024290996)
		+ W(3, -1154541352, 1045269292, -1087221074, 1042554433)
		+ W(4, -1154580200, 1023892422, 1017372383, -1112141659) + W(5, 1058232297, 1029783110, -1114120867, 1023410731)
		+ W(6, 1026284586, -1116984235, 1051438086, -1087458720) + W(7, 1033522371, -1144215764, 1015461809, 1018013925)
		+ W(8, 1047713030, -1095293300, 1032365167, -1144750420) + W(9, 1014364322, 1006339428, 1032067931, -1114380761)
		+ W(10, 1004597796, 1001346936, 1021777309, 1032228520)
		+ W(11, 1045851190, -1099415088, 1030006574, -1130073781);
	sum2 = W(0, -1153914788, -1101809160, 1052877341, 1046574229)
		 + W(1, -1095334336, 1023520281, -1126180245, -1115520194)
		 + W(2, 1022007580, 1000424166, -1113807813, 1021218858) + W(3, 995844276, -1114410922, 1055965696, 1034680258)
		 + W(4, -1109583292, 1008634443, -1141303142, 1033573989)
		 + W(5, -1098900400, -1098051352, 1033797491, -1115608949) + W(6, 1026951758, 998799030, 1023481081, 1045079279)
		 + W(7, 1032986287, 1032307290, 990856044, -1110191966) + W(8, 1023185808, -1106708743, 1025876178, -1128938562)
		 + W(9, 1004850742, -1129252703, 1031073312, 984863273) + W(10, -1137844345, 1017335440, 1015235936, 1016759632)
		 + W(11, -1104219784, -1103050031, 1038371038, 1020607644);
	WS(-1080660584, -1085825159);
	sum1 =
		W(0, 1013708199, -1123370319, -1145658646, -1118786339) + W(1, 1028171867, -1144908790, 998525366, -1131079022)
		+ W(2, -1111041043, 1035331132, 1017605134, -1131113128)
		+ W(3, 1026247587, -1110742584, 1047524760, -1095527502)
		+ W(4, 1042485668, -1130744068, 1009982783, -1113918027) + W(5, 1038280501, 1041941518, -1110999603, 992723116)
		+ W(6, -1136883881, 1032009669, -1096311074, 1051037928)
		+ W(7, -1106204846, 1025830203, -1128223794, 1025751155)
		+ W(8, 1042402294, -1106649743, -1132447358, 1017749654) + W(9, 999596614, -1126831290, -1118872454, 1032615945)
		+ W(10, 1002160934, -1127230527, -1126850910, 1033490448)
		+ W(11, 1023947050, -1111971999, 971034337, 1018668086);
	sum2 = W(0, 988660617, 1017543700, 1015794522, -1133704409) + W(1, 1003471274, -1140119133, -1145776834, 1002138986)
		 + W(2, 1001599498, 1024621822, -1135257421, -1136500105)
		 + W(3, -1133422913, 1031822055, 1041494739, -1102581932)
		 + W(4, 970658596, -1163479081, -1126488793, 1032911160) + W(5, 1056510750, -1089051586, 1026713544, 1009057465)
		 + W(6, 999416722, 1018658069, 1023998101, -1111744235) + W(7, 945757471, 1000517690, 999055930, 1007351961)
		 + W(8, -1138508317, 1009295285, 998080468, -1137960905) + W(9, 987033481, -1162261577, 991201876, -1140892226)
		 + W(10, -1156050276, -1186683976, -1179419172, 999395634)
		 + W(11, -1141702058, -1147317506, 1007988669, -1146609818);
	WS(1064784784, -1120346387);
	sum1 = W(0, -1150678408, 1015721531, 1049255678, -1099108228)
		 + W(1, -1149551256, -1136953142, 1000581420, -1110077251)
		 + W(2, 1043607805, -1107416484, 1017163947, -1140022794)
		 + W(3, 1006062348, -1107299655, 1059242626, -1089544734)
		 + W(4, 1023526494, -1139533474, 1015088861, -1132691862)
		 + W(5, -1123916922, -1130977491, 1022505321, 1012221798)
		 + W(6, -1136518116, -1148196556, -1096371932, 1057929313)
		 + W(7, -1104456865, 1014035238, -1126533711, 1013224070)
		 + W(8, -1100407642, 1048500643, -1111675367, 1026165050)
		 + W(9, 1012432222, -1124886999, -1132580564, 1035479729)
		 + W(10, -1127245287, -1136458552, -1122704190, 1014270588)
		 + W(11, -1102354822, 1044504531, 1007459698, 1017479699);
	sum2 = W(0, -1140771860, 1031694512, -1104948969, -1115570202)
		 + W(1, 1040745971, -1127298441, -1125513054, -1122230843) + W(2, 993388690, 1042093481, -1111499166, 995262946)
		 + W(3, -1131667695, 979286214, 1026183534, 1042830623) + W(4, -1119680402, 1002124441, -1131288705, 1025077104)
		 + W(5, -1111209187, -1112764939, 982469091, -1123012516) + W(6, 978159878, -1108853537, 1041617383, 1043422569)
		 + W(7, -1120447085, -1129740789, 1012596136, -1102087836)
		 + W(8, 1045410736, 1034771561, -1109907689, -1125016939)
		 + W(9, 1011933560, -1117751010, 1030126174, 1014235016)
		 + W(10, -1127258987, 1004566649, -1121534607, -1113389694)
		 + W(11, 1044425994, 1025820984, -1115100280, -1119639931);
	WS(-1088649680, 1067112300);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[507];

#define CURRENT_PASS 1

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) { temp[pos] = (value); }

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define HOOKED_tex(pos) INPUT_tex(pos)
#define HOOKED_size INPUT_size
#define HOOKED_pt INPUT_pt

void Pass1(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 13 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 507; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 13, y = (uint)id % 13;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (3)) + 0.5, float(group_base.y + y - (2)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 13];
	samples[1][3] = inp[local_pos + 14];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 26];
	samples[3][1] = inp[local_pos + 27];
	samples[3][2] = inp[local_pos + 28];
	samples[3][3] = inp[local_pos + 29];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 39];
	samples[4][3] = inp[local_pos + 40];
	samples[5][0] = inp[local_pos + 41];
	samples[5][1] = inp[local_pos + 42];
	samples[5][2] = inp[local_pos + 43];
	samples[5][3] = inp[local_pos + 44];
	samples[6][0] = inp[local_pos + 52];
	samples[6][1] = inp[local_pos + 53];
	samples[6][2] = inp[local_pos + 54];
	samples[6][3] = inp[local_pos + 55];
	samples[7][0] = inp[local_pos + 56];
	samples[7][1] = inp[local_pos + 57];
	samples[7][2] = inp[local_pos + 65];
	samples[7][3] = inp[local_pos + 66];
	samples[8][0] = inp[local_pos + 67];
	samples[8][1] = inp[local_pos + 68];
	samples[8][2] = inp[local_pos + 69];
	samples[8][3] = inp[local_pos + 70];
	samples[9][0] = inp[local_pos + 78];
	samples[9][1] = inp[local_pos + 79];
	samples[9][2] = inp[local_pos + 80];
	samples[9][3] = inp[local_pos + 81];
	samples[10][0] = inp[local_pos + 82];
	samples[10][1] = inp[local_pos + 83];
	samples[10][2] = inp[local_pos + 91];
	samples[10][3] = inp[local_pos + 92];
	samples[11][0] = inp[local_pos + 93];
	samples[11][1] = inp[local_pos + 94];
	samples[11][2] = inp[local_pos + 95];
	samples[11][3] = inp[local_pos + 96];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 41];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(1, 2) + ivec2(0, 1), ret);
}
//!PASS 2
//!DESC NNEDI3 (double_x, nns16, win8x6)
//!IN INPUT, temp
//!OUT OUTPUT
//!BLOCK_SIZE 64, 8
//!NUM_THREADS 32, 8
#pragma optionNV(inline none)
float nnedi3(vec4 samples[12]) {
	float sum = 0.0, sumsq = 0.0;
	[unroll] for (int i = 0; i < 12; i++) {
		sum += dot(samples[i], vec4(1.0, 1.0, 1.0, 1.0));
		sumsq += dot(samples[i], samples[i]);
	}
	float mstd0 = sum / 48.0;
	float mstd1 = sumsq / 48.0 - mstd0 * mstd0;
	float mstd2 = mix(0.0, inversesqrt(mstd1), mstd1 >= 1.192092896e-7);
	mstd1 *= mstd2;
	float vsum = 0.0, wsum = 0.0, sum1, sum2;
#define T(x) intBitsToFloat(x)
#define W(i, w0, w1, w2, w3) dot(samples[i], vec4(T(w0), T(w1), T(w2), T(w3)))
#define WS(w0, w1)                                                                                                     \
	sum1 = exp(sum1 * mstd2 + T(w0));                                                                                  \
	sum2 = sum2 * mstd2 + T(w1);                                                                                       \
	wsum += sum1;                                                                                                      \
	vsum += sum1 * (sum2 / (1.0 + abs(sum2)));
	sum1 = W(0, -1126897990, -1130469888, -1113607518, -1116173177)
		 + W(1, 1015526727, -1133977224, 990390561, -1122292152) + W(2, 1027745880, -1121396864, 1041026790, 1042195560)
		 + W(3, 1018714920, 1026239260, -1131068140, 1015308851) + W(4, 1024250604, 1039079928, 1022159130, -1098313415)
		 + W(5, 1042189511, -1106606352, 1013770942, -1122039043) + W(6, 1024642508, -1107295041, 1044630722, 999141354)
		 + W(7, -1106681307, 1038936227, -1122507740, 1031978820)
		 + W(8, -1121959908, -1147395201, -1107136294, 1019497054)
		 + W(9, 1035880216, -1124106064, -1136584888, -1116330759)
		 + W(10, -1149906049, -1126556538, 1005058137, 1007702352)
		 + W(11, -1121374916, 1025050132, -1135809122, 1018900008);
	sum2 = W(0, 1017133506, 1023321012, -1119553894, -1112177411)
		 + W(1, -1165256880, -1133574805, 1020043526, -1135761830)
		 + W(2, 1011515348, 1029416248, 1057587887, 1071604647) + W(3, 1051025857, 1035052104, 1010374724, 1018728192)
		 + W(4, -1139818306, -1115999672, -1090489276, -1079392139)
		 + W(5, -1098617840, -1139515542, -1121583660, 1024878156)
		 + W(6, -1123730089, 1020129658, -1109933138, -1097028615)
		 + W(7, -1105405946, -1135392452, -1142174380, 1002597928) + W(8, 996184056, 1015618084, 1016266760, 1028448562)
		 + W(9, -1155286464, -1138601606, 997185888, -1131188096)
		 + W(10, -1138856554, 1007066512, -1145378916, 1008681896)
		 + W(11, 1000343320, 991053648, -1155288808, -1132781834);
	WS(1018288640, 1027735986);
	sum1 =
		W(0, 1012158232, 1006778572, 1025063871, -1156175041) + W(1, 1010747802, -1140348884, 1020162890, -1172026051)
		+ W(2, -1178449286, -1114624234, -1104570115, 1028919475)
		+ W(3, 1034856692, -1127457566, -1122825993, -1115773453)
		+ W(4, 1044498160, 1032943202, 1059928494, -1097612337) + W(5, -1085331503, 1031833306, -1119592595, 1038136595)
		+ W(6, -1128542910, 1027108853, -1088743921, -1106124541) + W(7, 1059914122, 1032056909, 1033999672, 1027508251)
		+ W(8, -1115962871, 1017365062, 1032615126, 1026836706)
		+ W(9, -1114177498, -1122073627, 1022377282, -1129465364)
		+ W(10, 1002517720, 964628492, -1134936888, -1146238776) + W(11, 1020458158, 1016604174, 998219705, 1023799671);
	sum2 = W(0, -1126840972, -1145399745, -1139273136, 991527106)
		 + W(1, -1135317632, -1139461992, -1129486378, 995542402)
		 + W(2, -1130460798, 985194115, -1112997847, -1120456092) + W(3, 1001121889, 1017866680, 1006765920, 1000306721)
		 + W(4, 1019075916, -1120812206, -1139625904, 1043975251)
		 + W(5, -1150833602, -1128878392, -1133504840, -1142139489)
		 + W(6, 1017322604, -1129997452, 1042717692, 1051048254)
		 + W(7, -1121880440, -1112673669, -1126929736, -1114488494)
		 + W(8, -1131054760, 1006903064, -1114175000, -1113881740) + W(9, 978663174, 1026044394, 1014584312, 1007041936)
		 + W(10, -1131047996, -1143360737, -1130986946, 1007107280)
		 + W(11, -1143215153, -1125685806, -1144361281, -1134951296);
	WS(1042433344, -1111851638);
	sum1 = W(0, -1128612156, -1139940268, -1122042583, 984858240) + W(1, 999630836, -1146630760, -1126512698, 996431920)
		 + W(2, -1112658226, -1123380939, -1128727592, -1107767030)
		 + W(3, -1114896432, -1115281716, -1129996802, -1123547845)
		 + W(4, -1119638967, -1126908022, -1097703246, 1052387104)
		 + W(5, 1054789077, 1030603948, 1028419819, 1026334318) + W(6, 1043958886, 1033805831, 1057665642, 1046318672)
		 + W(7, -1095395475, -1117224401, -1123618471, -1113258842)
		 + W(8, -1120465263, -1115346894, -1104545545, -1108167869)
		 + W(9, 1029397739, -1163176544, -1117439993, -1134051464)
		 + W(10, -1128976934, -1142120768, 1005565040, -1148354296)
		 + W(11, -1133849404, -1117808895, 1013349902, -1120421311);
	sum2 =
		W(0, 1022431497, -1132240188, 1024165374, -1114822837)
		+ W(1, -1120729932, -1124855948, -1126342960, -1128289576)
		+ W(2, -1109389142, -1119299282, -1107432916, 1044244351)
		+ W(3, 1031006195, 983982854, -1158996358, -1121099750) + W(4, 1004613154, -1139248009, 1041447926, -1108646182)
		+ W(5, 1047688354, 1009435309, -1122846542, 1036127241) + W(6, 1028727631, -1129989652, 1047487962, -1100679909)
		+ W(7, -1126089152, 1033956847, -1123334894, 1039673953) + W(8, 1029503922, -1140046689, 1017218352, 1040665470)
		+ W(9, -1120804126, -1107003694, -1140927562, -1102421772)
		+ W(10, -1132574761, -1114039002, -1135952741, -1123756570)
		+ W(11, -1148002498, 1028342876, -1117057946, 1026336008);
	WS(1015433728, 1058400049);
	sum1 =
		W(0, -1139873791, -1133909491, 1023506921, -1230944644) + W(1, -1118840528, 1028378783, -1121050287, 1033465034)
		+ W(2, 1031161269, 1032977294, -1116372870, 1035249566)
		+ W(3, -1120831281, -1114963068, 1032892305, -1105610222)
		+ W(4, -1113693508, -1112917766, -1116140698, -1103376612)
		+ W(5, 1044830734, -1141442286, 1023234585, 1034039600) + W(6, 1033801204, -1131731326, 1045725159, -1102794347)
		+ W(7, -1116748777, 1032646513, -1112562780, 1030129285) + W(8, -1119172737, 989007258, -1122523445, 1044071755)
		+ W(9, 1030473357, 1018738506, 1021910870, -1122899972)
		+ W(10, -1143910182, 1019358132, 1008313039, -1115540344)
		+ W(11, -1126204226, -1118552369, 1016154651, -1124368226);
	sum2 = W(0, -1138428449, 992976916, -1142924106, 976851025) + W(1, 989093448, 997652548, -1153131756, -1134977059)
		 + W(2, -1158711528, 1013039401, -1128734961, 1036130613)
		 + W(3, 1010050489, -1137359275, 990210276, -1138876101)
		 + W(4, -1124467432, -1130455464, -1113146735, -1097860430)
		 + W(5, -1108810723, -1122996798, -1140348735, -1127238416)
		 + W(6, -1140697417, -1123518198, -1099387353, -1077268149)
		 + W(7, -1091225653, 1032494444, -1115493835, 1018469149) + W(8, 1030243467, 1033499227, 1051222006, 1072898808)
		 + W(9, 1056060393, 1025590581, 1025171621, 1026307569) + W(10, 1012442941, 975746961, -1122081826, -1117904739)
		 + W(11, -1131990027, 951236744, 1006284898, -1146863422);
	WS(-1143089152, 1030017260);
	sum1 = W(0, 1012276081, 1001605962, 1024406997, -1155861797)
		 + W(1, -1155627981, -1122534699, 1018348791, -1120990241)
		 + W(2, -1116644609, -1127223379, -1109637089, -1115433381)
		 + W(3, 1036571679, 1028189701, -1126280255, 1036379833) + W(4, 1019444907, -1119160665, 1048989101, 1044433671)
		 + W(5, -1098184025, 1039597237, -1117935161, -1136463217)
		 + W(6, -1124688427, 1035777366, -1098625404, 1006101820)
		 + W(7, 1048780603, -1104960796, 1029641477, -1111599465)
		 + W(8, 1029853709, -1136557285, 1038057505, -1111190908)
		 + W(9, -1112291813, -1130076067, 1012573277, -1154886405)
		 + W(10, -1130860131, -1130309965, -1130883561, 1009046005)
		 + W(11, 1025361773, 1018788475, -1125993892, 1020397819);
	sum2 = W(0, -1153319600, -1147284080, 1008968960, 995456320)
		 + W(1, -1140178660, -1146954776, -1142030464, -1170856127)
		 + W(2, 1008405084, 985822624, -1142311064, 1022276922) + W(3, -1140411728, 1005012008, 1003782736, 1006946188)
		 + W(4, -1118973116, 1010505984, -1101248908, -1089187936) + W(5, -1109859050, 1017518401, 982409184, 995727232)
		 + W(6, -1140784820, -1129308604, 1037448945, 1057794596) + W(7, 1029773785, 1015531414, 974134143, 960534268)
		 + W(8, 1012585128, 1021293048, 1024969278, 1033366347) + W(9, 1024400778, 1007802556, 1003482728, 1009923956)
		 + W(10, 1010769460, 1001814848, -1160749952, -1123619202)
		 + W(11, -1136545168, 1000322872, -1152799248, 985284128);
	WS(1064472528, -1121594920);
	sum1 = W(0, -1142654991, -1143599223, 1014568428, 1010500896)
		 + W(1, -1124387333, 1020884834, -1131205634, 1026841191)
		 + W(2, 1027230343, 1032290711, -1136037408, 1002050167)
		 + W(3, -1122938499, -1120250507, 1025589157, -1110863224)
		 + W(4, -1112807213, -1113392623, -1115590690, -1113734161)
		 + W(5, 1038834309, 1029912912, 1019867389, 1031947569) + W(6, 1027061019, 1016010466, 1034098395, -1112872467)
		 + W(7, -1130883382, 1015162858, -1123484555, 1019435182) + W(8, -1128825126, 991342574, 1008695068, 1027642302)
		 + W(9, 1013984188, 1015817710, 1015459258, -1129521612)
		 + W(10, -1164359388, 1014490160, -1148094031, -1127829894)
		 + W(11, -1138058188, -1124941766, 1008886302, -1130075526);
	sum2 =
		W(0, 1003807591, -1147429191, 1002635095, -1132089351) + W(1, -1147602519, -1151072125, 964968041, 1011860423)
		+ W(2, -1154115373, -1139843175, 1018649088, 1016729308)
		+ W(3, 1024344696, -1155997437, 1001714367, -1141691791) + W(4, 1000124719, 1001833687, 1008095031, -1105992985)
		+ W(5, 1014141127, -1132427785, -1141957575, -1139390003) + W(6, 1017182228, 1024488826, 1040714709, 1063780536)
		+ W(7, 1047200342, 1020609216, 1023684454, 1017456200)
		+ W(8, -1126980607, -1116401990, -1105844805, -1085442794)
		+ W(9, -1101306502, -1122913939, -1125194898, -1128761080)
		+ W(10, -1130234859, 987658746, 1013729967, 1024604622)
		+ W(11, 995366957, -1147894927, -1146690231, -1146063807);
	WS(1061878800, -1131153991);
	sum1 =
		W(0, -1123872727, 1018625288, -1127640224, 1026350045) + W(1, 1013916191, 1018183052, -1145362866, 1016048056)
		+ W(2, 1015115512, 1031144036, 1036357847, -1108974562) + W(3, -1107191102, 1006433282, 1014427177, 1026198990)
		+ W(4, -1099302516, -1102371221, -1085394744, 1059569738) + W(5, 1050617832, 1032504563, 1031877738, 1033421596)
		+ W(6, 1041224340, 1009910425, 1052022073, 1058525661)
		+ W(7, -1088226291, -1097316565, -1109508096, -1098228398)
		+ W(8, -1144166978, 1014687697, -1115552350, -1125187302) + W(9, 1037730450, 1040234099, 1015825508, 1035235966)
		+ W(10, -1171049230, 1022902338, -1132534141, 1016189168)
		+ W(11, -1123531112, -1127405808, 1018548825, -1137247201);
	sum2 =
		W(0, -1131301730, 973798558, -1127780866, 1013478572) + W(1, -1160424319, -1135840779, -1164912671, -1138738786)
		+ W(2, 1031269327, -1131640108, 1013454096, -1109509101)
		+ W(3, -1117315078, -1131160392, -1145619912, -1127332243)
		+ W(4, -1127010401, 1028981651, -1149526184, 1051779317) + W(5, 1028380081, -1137527992, 998238336, -1148504424)
		+ W(6, -1109842974, -1125259759, -1113692773, 1047088883)
		+ W(7, -1134194124, 1028175261, 1018886164, 1027237057)
		+ W(8, -1181736700, -1167651134, -1123287814, -1109788940)
		+ W(9, -1115287133, -1121515979, -1125209194, -1142455024)
		+ W(10, -1180777340, -1160957999, 993986728, 1020962386)
		+ W(11, -1136947718, -1138138790, -1152989064, -1123011340);
	WS(-1146021888, 1053974589);
	sum1 =
		W(0, 1029642476, 1013890275, -1176939092, 1022266947) + W(1, -1146466657, 1004183253, -1160650069, -1127783457)
		+ W(2, -1119368753, -1134074211, 1007708103, 1017736689) + W(3, 1027345005, 1032510570, 1019378973, 1031489314)
		+ W(4, 1042969521, 1042359026, 1045769551, -1101301107)
		+ W(5, -1094644679, -1091538585, -1107179580, -1095508207)
		+ W(6, -1095098901, -1107285127, -1096985546, 1034918881) + W(7, 1050538529, 1051699648, 1036824506, 1048776768)
		+ W(8, 1046685039, 1031018217, 1036262392, 1003810877) + W(9, -1120828825, 1011534979, -1133351451, 1035618600)
		+ W(10, 984849429, -1135393367, -1139413615, 1024875117)
		+ W(11, -1172526890, 1017671961, -1160823333, 1006585957);
	sum2 = W(0, 1031363252, 1030774484, 1015165558, 1007437656) + W(1, 1020087968, -1158035650, -1137051446, 1018262350)
		 + W(2, -1091101506, 1001500224, -1110787951, 965388167) + W(3, 1003188992, 1041338676, -1134903850, 1033269727)
		 + W(4, 1048232756, -1110436898, 1016237906, 1014973676)
		 + W(5, -1123006886, -1105090874, -1123217223, -1104724635)
		 + W(6, 1057852755, -1132290932, 1043794074, 1047525730)
		 + W(7, 1011818344, -1129296549, 1034851396, -1106365430)
		 + W(8, -1095952784, -1131305343, -1113356328, -1152923833)
		 + W(9, -1111245491, -1131940021, -1117639196, 1024945328)
		 + W(10, 1016290300, -1126601761, 1003743696, 1022650220)
		 + W(11, 1021501454, 1017537464, -1133259176, 1019937714);
	WS(-1077057896, -1083600334);
	sum1 = W(0, 1017420011, 1014201033, 1017846781, 999765850) + W(1, -1162024122, 985808522, 1019153993, 1011766057)
		 + W(2, 1011471785, 1019976613, -1138042285, 1040273597) + W(3, 1016487629, 1027730222, 1010855969, 1025127228)
		 + W(4, 1029223422, -1126437509, 1049638570, -1090770241) + W(5, 1029091694, 1037672698, 1027546578, 1025680213)
		 + W(6, -1116040414, 1015478313, -1103217262, -1087230893)
		 + W(7, 1046437488, 1024768280, 1028909230, 1017109109) + W(8, 1017123181, 1024110818, 1023111893, 1030676769)
		 + W(9, -1112046985, -1120839802, 1023955584, -1128064723)
		 + W(10, 1016511669, -1167731667, 1009386661, 1023090125)
		 + W(11, 1020460717, 1025489318, -1134545259, 1027741830);
	sum2 =
		W(0, 1023774756, -1152708847, 1005727232, -1128030280) + W(1, 1004577664, -1116453887, 1020705336, -1127775332)
		+ W(2, -1107003878, 1013240776, -1108761818, 1032847770)
		+ W(3, 1024878510, -1129071264, -1124253692, -1114566712)
		+ W(4, 1020767940, -1108605887, 1050907301, 1058054639) + W(5, -1106188814, 1040942692, -1115446820, 1042743894)
		+ W(6, -1118294055, -1128830540, -1097736561, 1008347200)
		+ W(7, 1049418167, -1105809360, 1014050712, -1132221182)
		+ W(8, -1113997093, -1139588328, 1032528025, 1039669350)
		+ W(9, -1108856812, -1104688291, 1018266740, -1103534695)
		+ W(10, 1021408408, -1119578529, -1135972104, -1131826954)
		+ W(11, 999382680, 1019392776, -1117167612, 1022204104);
	WS(1034686080, -1080904524);
	sum1 = W(0, -1139332721, -1156631187, 1023562901, 1011454089) + W(1, 1009225011, 1012327853, 1010687981, 1010798725)
		 + W(2, 1025190657, 1024127465, 1006799241, -1145135178) + W(3, -1129417722, 1017495114, 1027561839, 1010795083)
		 + W(4, -1143163562, 1040892278, -1104914606, -1089193318)
		 + W(5, 1043909393, -1119873834, -1136185891, -1118482716)
		 + W(6, 1041601261, 1028605547, 1052908885, -1091833281)
		 + W(7, -1103073573, 1025246703, -1124345098, 1032670633)
		 + W(8, 1024768205, -1129308018, -1117860929, 1036300940) + W(9, 1040987970, 1033652713, 1024209623, 1027144528)
		 + W(10, -1137907141, 1012089369, 1019594656, -1143330794)
		 + W(11, 992909011, -1123933213, 1018355139, -1123266333);
	sum2 = W(0, 998154484, -1136847690, -1120010648, -1145824866) + W(1, 1015307650, 994166396, 1000606426, 1010815409)
		 + W(2, -1124228589, 1028193069, 1043298286, -1115567961)
		 + W(3, -1106126812, -1111174068, -1128437454, -1110538383)
		 + W(4, -1132108902, -1123281782, -1097765474, 1059221182)
		 + W(5, 1048600788, -1130476352, 1026255089, -1118584150)
		 + W(6, -1115676434, -1123302060, 1027211577, 1034703777)
		 + W(7, -1099334080, 1015056080, -1137618020, 1028199647)
		 + W(8, -1123985162, -1132306691, -1114822183, -1131429597)
		 + W(9, 1029215805, 1023836215, -1127893362, 1025007180)
		 + W(10, 1004957466, 1011392625, -1127542967, 1022587458)
		 + W(11, -1127163397, -1122559367, -1171736302, -1124423270);
	WS(-1097173920, -1100403112);
	sum1 = W(0, -1133792968, -1124511038, -1133667884, -1126404688)
		 + W(1, -1129657589, -1123548289, -1134226372, -1120375479)
		 + W(2, -1126599342, -1134319356, -1113753548, -1113718896)
		 + W(3, 1034489098, 1017816566, -1122628437, 1029275393) + W(4, 1026626987, -1112479512, 1051379210, 1058852431)
		 + W(5, -1097104011, 1007326848, -1112737379, -1116837058)
		 + W(6, -1109988694, -1122054529, -1097159959, 1058630415)
		 + W(7, 1049904553, -1104990865, 983139170, -1110311540)
		 + W(8, -1128510918, -1138055228, 1031366423, -1108453759)
		 + W(9, -1111244112, -1129654222, -1143321192, -1132471000)
		 + W(10, -1124691470, -1131431128, -1128464692, -1122909907)
		 + W(11, 1006087192, -1138955724, -1123473736, -1149064600);
	sum2 = W(0, -1133003813, -1170659932, 1006656308, 1031055883)
		 + W(1, -1122785076, -1138148825, -1134424500, -1131089901)
		 + W(2, -1145103116, 1024883426, -1122208183, -1101651786)
		 + W(3, -1107240567, -1137951645, -1131665157, -1116779622)
		 + W(4, -1105221269, -1117429423, -1098340061, 1055658740)
		 + W(5, 1035604404, -1131811521, -1130287800, -1123356625)
		 + W(6, 1033080040, 1028547885, 1042272545, 1058321046) + W(7, -1112738821, 1003752088, 1015669581, 1033205575)
		 + W(8, 1016862101, -1128891234, -1121562483, -1100689547)
		 + W(9, -1115182870, 1026865631, -1129373191, -1134576021)
		 + W(10, -1129731365, -1147341896, -1121650606, 1031708925)
		 + W(11, -1123396988, -1133076983, -1131162259, -1127933595);
	WS(1049422752, 1064394145);
	sum1 = W(0, 1016583527, 997641734, -1129211865, -1131677043) + W(1, 1021172552, 1021691141, -1133007562, 1026669144)
		 + W(2, -1106085006, -1123841888, 1041111742, 1032245856)
		 + W(3, -1110939130, -1105269375, -1137128282, -1106745812)
		 + W(4, 995307718, 1031369872, -1088517333, -1098988005) + W(5, 1058612208, 1030057089, 1036830720, 1034516890)
		 + W(6, 1042273115, 1021597381, 1058826428, -1105331685)
		 + W(7, -1090507155, 1043687978, -1120823228, 1038691348)
		 + W(8, -1113049442, -1122854832, -1113933244, 1032610296)
		 + W(9, 1037338632, -1122591528, -1116248270, -1117945591)
		 + W(10, 1025810280, 1006187755, 1019889767, -1131685097)
		 + W(11, -1155049030, -1134096210, 1025994697, -1126546729);
	sum2 =
		W(0, 1015668141, -1124041461, 1005775275, 1015274173) + W(1, -1138139200, 992639399, -1132053353, -1129319398)
		+ W(2, -1138201662, -1140877219, 1027346708, 1016303395)
		+ W(3, -1106503093, -1117618841, -1115775134, -1122071744)
		+ W(4, -1111996311, -1116450062, -1125910350, -1108948194)
		+ W(5, -1104963655, 1031763952, 1015724405, 1034411590)
		+ W(6, -1127284815, -1123578506, -1106280325, 1052974100) + W(7, 1053021197, 957951850, 1016609913, -1140595900)
		+ W(8, -1125087482, 1024732308, 1034158307, 1032925063) + W(9, -1107449032, 994113735, -1132927280, -1140186580)
		+ W(10, 1020174885, -1139064970, -1133423524, -1161498797)
		+ W(11, -1134898868, 1013272790, -1132485274, -1164791981);
	WS(-1101497152, -1084603877);
	sum1 =
		W(0, -1136425045, -1140218249, -1121565262, -1122160667)
		+ W(1, 1006883159, -1132497425, 1004502690, -1128604789) + W(2, 1016522037, -1157845066, 1035402982, 1027884002)
		+ W(3, 1025282390, 1022271101, -1138792353, 995143101) + W(4, 967194407, 1029505522, 1022903246, -1107598171)
		+ W(5, 1025270942, -1120772739, -1154700189, -1128284203)
		+ W(6, 1019848413, -1119357636, 1027088345, 1024422013) + W(7, -1117602990, 1030415880, -1171556244, 1025955498)
		+ W(8, -1129523533, -1140249161, -1121932442, -1127296803)
		+ W(9, 1030372258, -1129818261, -1138666305, -1121511513)
		+ W(10, -1142614610, -1135395837, -1148904362, 1002411186)
		+ W(11, -1130529549, 1018540973, -1138856043, 1011955033);
	sum2 =
		W(0, -1126668299, -1137964827, 1015963121, 1030757650) + W(1, -1137547503, 997720155, -1132279825, -1152589275)
		+ W(2, -1131366283, -1117612139, -1097765254, -1083955387)
		+ W(3, -1103492737, -1118797430, -1131387718, -1140632131)
		+ W(4, 1024971228, 1034620123, 1049249869, 1064229708) + W(5, 1047078464, 1017921725, 1024786888, -1144191965)
		+ W(6, 1000957181, -1119890411, 1026062254, -1107214224) + W(7, -1122275403, 1016072153, -1133941049, 996433547)
		+ W(8, -1151515419, -1145021381, 1001872029, 1026637176)
		+ W(9, 1027173860, -1135832789, -1148432117, -1140699475)
		+ W(10, 1005199725, -1136862175, 1007955643, -1125717658)
		+ W(11, -1169614250, 923654805, 1002011725, 1005736109);
	WS(1059552336, -1136539026);
	sum1 = W(0, 990367896, 1010957914, -1154541352, 1017372383) + W(1, 1026284586, 1015461809, 1014364322, 1021777309)
		 + W(2, 1041343484, 1036710283, 1045269292, -1112141659) + W(3, -1116984235, 1018013925, 1006339428, 1032228520)
		 + W(4, -1096612504, -1107358947, -1087221074, 1058232297)
		 + W(5, 1051438086, 1047713030, 1032067931, 1045851190) + W(6, 1033353841, 1029016441, 1042554433, 1029783110)
		 + W(7, -1087458720, -1095293300, -1114380761, -1099415088)
		 + W(8, -1125599349, -1132821402, -1154580200, -1114120867)
		 + W(9, 1033522371, 1032365167, 1004597796, 1030006574) + W(10, 1028944863, 1024290996, 1023892422, 1023410731)
		 + W(11, -1144215764, -1144750420, 1001346936, -1130073781);
	sum2 = W(0, -1153914788, -1126180245, 995844276, -1141303142) + W(1, 1026951758, 990856044, 1004850742, 1015235936)
		 + W(2, -1101809160, -1115520194, -1114410922, 1033573989)
		 + W(3, 998799030, -1110191966, -1129252703, 1016759632) + W(4, 1052877341, 1022007580, 1055965696, -1098900400)
		 + W(5, 1023481081, 1023185808, 1031073312, -1104219784) + W(6, 1046574229, 1000424166, 1034680258, -1098051352)
		 + W(7, 1045079279, -1106708743, 984863273, -1103050031)
		 + W(8, -1095334336, -1113807813, -1109583292, 1033797491)
		 + W(9, 1032986287, 1025876178, -1137844345, 1038371038)
		 + W(10, 1023520281, 1021218858, 1008634443, -1115608949)
		 + W(11, 1032307290, -1128938562, 1017335440, 1020607644);
	WS(-1080660584, -1085825159);
	sum1 = W(0, 1013708199, 998525366, 1026247587, 1009982783) + W(1, -1136883881, -1128223794, 999596614, -1126850910)
		 + W(2, -1123370319, -1131079022, -1110742584, -1113918027)
		 + W(3, 1032009669, 1025751155, -1126831290, 1033490448)
		 + W(4, -1145658646, -1111041043, 1047524760, 1038280501)
		 + W(5, -1096311074, 1042402294, -1118872454, 1023947050)
		 + W(6, -1118786339, 1035331132, -1095527502, 1041941518)
		 + W(7, 1051037928, -1106649743, 1032615945, -1111971999)
		 + W(8, 1028171867, 1017605134, 1042485668, -1110999603) + W(9, -1106204846, -1132447358, 1002160934, 971034337)
		 + W(10, -1144908790, -1131113128, -1130744068, 992723116)
		 + W(11, 1025830203, 1017749654, -1127230527, 1018668086);
	sum2 = W(0, 988660617, -1145776834, -1133422913, -1126488793) + W(1, 999416722, 999055930, 987033481, -1179419172)
		 + W(2, 1017543700, 1002138986, 1031822055, 1032911160) + W(3, 1018658069, 1007351961, -1162261577, 999395634)
		 + W(4, 1015794522, 1001599498, 1041494739, 1056510750) + W(5, 1023998101, -1138508317, 991201876, -1141702058)
		 + W(6, -1133704409, 1024621822, -1102581932, -1089051586)
		 + W(7, -1111744235, 1009295285, -1140892226, -1147317506)
		 + W(8, 1003471274, -1135257421, 970658596, 1026713544) + W(9, 945757471, 998080468, -1156050276, 1007988669)
		 + W(10, -1140119133, -1136500105, -1163479081, 1009057465)
		 + W(11, 1000517690, -1137960905, -1186683976, -1146609818);
	WS(1064784784, -1120346387);
	sum1 =
		W(0, -1150678408, 1000581420, 1006062348, 1015088861) + W(1, -1136518116, -1126533711, 1012432222, -1122704190)
		+ W(2, 1015721531, -1110077251, -1107299655, -1132691862)
		+ W(3, -1148196556, 1013224070, -1124886999, 1014270588) + W(4, 1049255678, 1043607805, 1059242626, -1123916922)
		+ W(5, -1096371932, -1100407642, -1132580564, -1102354822)
		+ W(6, -1099108228, -1107416484, -1089544734, -1130977491)
		+ W(7, 1057929313, 1048500643, 1035479729, 1044504531) + W(8, -1149551256, 1017163947, 1023526494, 1022505321)
		+ W(9, -1104456865, -1111675367, -1127245287, 1007459698)
		+ W(10, -1136953142, -1140022794, -1139533474, 1012221798)
		+ W(11, 1014035238, 1026165050, -1136458552, 1017479699);
	sum2 = W(0, -1140771860, -1125513054, -1131667695, -1131288705)
		 + W(1, 978159878, 1012596136, 1011933560, -1121534607) + W(2, 1031694512, -1122230843, 979286214, 1025077104)
		 + W(3, -1108853537, -1102087836, -1117751010, -1113389694)
		 + W(4, -1104948969, 993388690, 1026183534, -1111209187) + W(5, 1041617383, 1045410736, 1030126174, 1044425994)
		 + W(6, -1115570202, 1042093481, 1042830623, -1112764939) + W(7, 1043422569, 1034771561, 1014235016, 1025820984)
		 + W(8, 1040745971, -1111499166, -1119680402, 982469091)
		 + W(9, -1120447085, -1109907689, -1127258987, -1115100280)
		 + W(10, -1127298441, 995262946, 1002124441, -1123012516)
		 + W(11, -1129740789, -1125016939, 1004566649, -1119639931);
	WS(-1088649680, 1067112300);

	return clamp(mstd0 + 5.0 * vsum / wsum * mstd1, 0.0, 1.0);
}

shared float inp[555];

#define CURRENT_PASS 2

#define GET_SAMPLE(x) dot(x.rgb, rgb2y)
#define imageStore(out_image, pos, val) imageStoreOverride(pos, val.x)
void imageStoreOverride(uint2 pos, float value) {
	float2 UV = mul(rgb2uv, INPUT.SampleLevel(sam_INPUT_LINEAR, HOOKED_map(pos), 0).rgb);
	OUTPUT[pos] = float4(mul(yuv2rgb, float3(value.x, UV)), 1.0);
}

#define INPUT_tex(pos) GET_SAMPLE(vec4(texture(INPUT, pos)))
static const float2 INPUT_size = float2(GetInputSize());
static const float2 INPUT_pt = float2(GetInputPt());

#define temp_tex(pos) (float(texture(temp, pos).x))
static const float2 temp_size = float2(GetInputSize().x * 1, GetInputSize().y * 2);
static const float2 temp_pt = float2(1.0 / (temp_size.x), 1.0 / (temp_size.y));

#define HOOKED_tex(pos) temp_tex(pos)
#define HOOKED_size temp_size
#define HOOKED_pt temp_pt

void Pass2(uint2 blockStart, uint3 threadId) {
	ivec2 group_base = ivec2(gl_WorkGroupID) * ivec2(gl_WorkGroupSize);
	int local_pos = int(gl_LocalInvocationID.x) * 15 + int(gl_LocalInvocationID.y);
	for (int id = int(gl_LocalInvocationIndex); id < 555; id += int(gl_WorkGroupSize.x * gl_WorkGroupSize.y)) {
		uint x = (uint)id / 15, y = (uint)id % 15;
		inp[id] =
			HOOKED_tex(HOOKED_pt * vec2(float(group_base.x + x - (2)) + 0.5, float(group_base.y + y - (3)) + 0.5)).x;
	}
	barrier();
	vec4 ret = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 ret0 = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 samples[12];
	samples[0][0] = inp[local_pos + 0];
	samples[0][1] = inp[local_pos + 1];
	samples[0][2] = inp[local_pos + 2];
	samples[0][3] = inp[local_pos + 3];
	samples[1][0] = inp[local_pos + 4];
	samples[1][1] = inp[local_pos + 5];
	samples[1][2] = inp[local_pos + 6];
	samples[1][3] = inp[local_pos + 7];
	samples[2][0] = inp[local_pos + 15];
	samples[2][1] = inp[local_pos + 16];
	samples[2][2] = inp[local_pos + 17];
	samples[2][3] = inp[local_pos + 18];
	samples[3][0] = inp[local_pos + 19];
	samples[3][1] = inp[local_pos + 20];
	samples[3][2] = inp[local_pos + 21];
	samples[3][3] = inp[local_pos + 22];
	samples[4][0] = inp[local_pos + 30];
	samples[4][1] = inp[local_pos + 31];
	samples[4][2] = inp[local_pos + 32];
	samples[4][3] = inp[local_pos + 33];
	samples[5][0] = inp[local_pos + 34];
	samples[5][1] = inp[local_pos + 35];
	samples[5][2] = inp[local_pos + 36];
	samples[5][3] = inp[local_pos + 37];
	samples[6][0] = inp[local_pos + 45];
	samples[6][1] = inp[local_pos + 46];
	samples[6][2] = inp[local_pos + 47];
	samples[6][3] = inp[local_pos + 48];
	samples[7][0] = inp[local_pos + 49];
	samples[7][1] = inp[local_pos + 50];
	samples[7][2] = inp[local_pos + 51];
	samples[7][3] = inp[local_pos + 52];
	samples[8][0] = inp[local_pos + 60];
	samples[8][1] = inp[local_pos + 61];
	samples[8][2] = inp[local_pos + 62];
	samples[8][3] = inp[local_pos + 63];
	samples[9][0] = inp[local_pos + 64];
	samples[9][1] = inp[local_pos + 65];
	samples[9][2] = inp[local_pos + 66];
	samples[9][3] = inp[local_pos + 67];
	samples[10][0] = inp[local_pos + 75];
	samples[10][1] = inp[local_pos + 76];
	samples[10][2] = inp[local_pos + 77];
	samples[10][3] = inp[local_pos + 78];
	samples[11][0] = inp[local_pos + 79];
	samples[11][1] = inp[local_pos + 80];
	samples[11][2] = inp[local_pos + 81];
	samples[11][3] = inp[local_pos + 82];
	ret[0] = nnedi3(samples);
	ret0[0] = inp[local_pos + 33];
#if CURRENT_PASS == LAST_PASS
	uint2 destPos = blockStart + threadId.xy * 2;
	uint2 outputSize = GetOutputSize();
	if (destPos.x >= outputSize.x || destPos.y >= outputSize.y) {
		return;
	}
#endif
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1), ret0);
	imageStore(out_image, ivec2(gl_GlobalInvocationID) * ivec2(2, 1) + ivec2(1, 0), ret);
}
