local assets =
{
	Asset("ANIM", "anim/levinsword.zip"),
	Asset("ANIM", "anim/swap_levinsword.zip"),

    Asset("ATLAS", "images/inventoryimages/levinsword.xml"),
    Asset("IMAGE", "images/inventoryimages/levinsword.tex"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_levinsword", "swap_levinsword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	inst.SoundEmitter:PlaySound("dontstarve/common/lightningrod")
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("levinsword")
    inst.AnimState:SetBuild("levinsword")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")


    if not TheWorld.ismastersim then
        return inst
    end


    inst.entity:SetPristine()

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40)
    inst.components.weapon:SetElectric()

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")    
    inst.components.inventoryitem.imagename = "levinsword"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/levinsword.xml"

    MakeHauntableLaunchAndPerish(inst)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab("common/inventory/levinsword", fn, assets)