local assets =
{
	Asset("ANIM", "anim/valflame.zip"),
	Asset("ANIM", "anim/swap_valflame.zip"),

    Asset("ATLAS", "images/inventoryimages/valflame.xml"),
    Asset("IMAGE", "images/inventoryimages/valflame.tex"),
}

local function onattack_valflame(inst, attacker, target)

    if attacker and attacker.components.sanity then
        attacker.components.sanity:DoDelta(-2)
    end

    if target.components.burnable and not target.components.burnable:IsBurning() then
        if target.components.freezable and target.components.freezable:IsFrozen() then           
            target.components.freezable:Unfreeze()            
        else            
            target.components.burnable:Ignite(true, attacker)
        end   
    end

   if target.components.freezable then
        target.components.freezable:AddColdness(-1) --Does this break ice staff?
        if target.components.freezable:IsFrozen() then
            target.components.freezable:Unfreeze()            
        end
    end

    attacker.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")

end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_valflame", "swap_valflame")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("valflame")
    inst.AnimState:SetBuild("valflame")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("shadow")


    if not TheWorld.ismastersim then
        return inst
    end


    inst.entity:SetPristine()

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(35)
	inst.components.weapon:SetOnAttack(onattack_valflame)
    inst.components.weapon:SetRange(8, 10)
	inst.components.weapon:SetProjectile("fire_projectile")

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(100)
    inst.components.finiteuses:SetUses(100)
    
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")    
    inst.components.inventoryitem.imagename = "valflame"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/valflame.xml"

    MakeHauntableLaunchAndPerish(inst)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    return inst
end

return Prefab("common/inventory/valflame", fn, assets)