local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH
local Craft = GetModConfigData("Craft")
GLOBAL.TUNING.MIKU = {}
TUNING.MIKU.SanAdd = GetModConfigData("San")
TUNING.MIKU.Light = GetModConfigData("Lightness")
TUNING.MIKU.radius = GetModConfigData("Radius")
PrefabFiles = {
    "sin", "ty", 
}

Assets = {
    Asset("ANIM", "anim/ty.zip"), 
    Asset("SOUND", "sound/ty.fsb"), 
    Asset("SOUNDPACKAGE", "sound/ty.fev"), 
    Asset("ATLAS", "images/inventoryimages/ty.xml"), 
    Asset("IMAGE", "images/inventoryimages/ty.tex"), 

    Asset("ANIM", "anim/sin.zip"), 
    Asset("SOUND", "sound/mzz.fsb"), 
    Asset("SOUNDPACKAGE", "sound/mzz.fev"), 
    Asset("ATLAS", "images/inventoryimages/sin.xml"), 
    Asset("IMAGE", "images/inventoryimages/sin.tex"), 

}

RemapSoundEvent("mzz/play", "mzz/sound/play")
RemapSoundEvent("mzz/end", "mzz/sound/end")

RemapSoundEvent("ty/play", "ty/sound/play")
RemapSoundEvent("ty/end", "ty/sound/end")

local makings = nil
if Craft == 'VeryEasy' then
    makings = {Ingredient("boards", 3)}
    local ty = GLOBAL.Recipe("ty", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_ONE, "ty_placer")
    AddPrefabPostInit("images/inventoryimages/ty.tex")
    ty.atlas = "images/inventoryimages/ty.xml"
    local sin = GLOBAL.Recipe("sin", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_ONE, "sin_placer")
    AddPrefabPostInit("images/inventoryimages/sin.tex")
    sin.atlas = "images/inventoryimages/sin.xml"
elseif Craft == 'Easy' then
    makings = {Ingredient("canary", 1), Ingredient("orangegem", 1), Ingredient("boards", 3)}
    local ty = GLOBAL.Recipe("ty", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "ty_placer")
    AddPrefabPostInit("images/inventoryimages/ty.tex")
    ty.atlas = "images/inventoryimages/ty.xml"
    local sin = GLOBAL.Recipe("sin", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "sin_placer")
    AddPrefabPostInit("images/inventoryimages/sin.tex")
    sin.atlas = "images/inventoryimages/sin.xml"
elseif Craft == 'Normal' then
    makings = {Ingredient("canary", 3), Ingredient("orangegem", 2), Ingredient("boards", 4)}
    local ty = GLOBAL.Recipe("ty", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "ty_placer")
    AddPrefabPostInit("images/inventoryimages/ty.tex")
    ty.atlas = "images/inventoryimages/ty.xml"
    local sin = GLOBAL.Recipe("sin", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "sin_placer")
    AddPrefabPostInit("images/inventoryimages/sin.tex")
    sin.atlas = "images/inventoryimages/sin.xml"
else
    makings = {Ingredient("canary", 5), Ingredient("orangegem", 5), Ingredient("boards", 5)}
    local ty = GLOBAL.Recipe("ty", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "ty_placer")
    AddPrefabPostInit("images/inventoryimages/ty.tex")
    ty.atlas = "images/inventoryimages/ty.xml"
    local sin = GLOBAL.Recipe("sin", makings, RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, "sin_placer")
    AddPrefabPostInit("images/inventoryimages/sin.tex")
    sin.atlas = "images/inventoryimages/sin.xml"
end


GLOBAL.STRINGS.RECIPE_DESC.SIN = "音乐人偶" 
GLOBAL.STRINGS.NAMES.SIN = "初音音乐人偶"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SIN = "公主殿下"


GLOBAL.STRINGS.RECIPE_DESC.TY = "音乐人偶" 
GLOBAL.STRINGS.NAMES.TY = "洛天依音乐人偶"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TY = "她饿了"
