SanAdd = TUNING.MIKU.SanAdd
assets = 
{
    Asset("ANIM", "anim/sin.zip"), 
    Asset("SOUND", "sound/mzz.fsb"), 
}

local prefabs = 
{
    
}

local function onhammered(inst, worker)
    inst.components.lootdropper:DropLoot()
    SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
    inst:Remove()
end

local function onhit(inst, worker)
    inst.AnimState:PushAnimation("idle", true)
end

local function onbuilt(inst)
    inst.AnimState:PlayAnimation("place")
end


local function turn_on(inst)
    inst.AnimState:PlayAnimation("loop", true)
    inst.SoundEmitter:PlaySound(inst.songToPlay, "mzz/play")
    inst:PushEvent("turnedon")
    --回脑光环
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL * SanAdd
    --inst.components.sanityaura.aurafn = 5
    inst.Light:Enable(true)
end

local function turn_off(inst)
    inst.AnimState:PlayAnimation("idle", true)
    inst.SoundEmitter:KillSound("mzz/play")
    inst.SoundEmitter:PlaySound("mzz/end")
    inst:PushEvent("turnedoff")
    inst:RemoveComponent("sanityaura")
    inst.Light:Enable(false)
end

local function player_increment(inst)
    inst.count_player = inst.count_player + 1
    if inst.count_player == 1 then
        turn_on(inst)
    end
end


local function player_decrement(inst)
    inst.count_player = inst.count_player - 1
    if inst.count_player <= 0 then
        inst.count_player = 0
        turn_off(inst)
    end
end



local function fn()
    local inst = CreateEntity()
    --local trans = inst.entity:AddTransform()
    --local anim = inst.entity:AddAnimState()
    --local sound = inst.entity:AddSoundEmitter()
    --local shadow = inst.entity:AddDynamicShadow()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddDynamicShadow()
    inst.entity:AddNetwork()
    inst.DynamicShadow:SetSize(3.7, 3)
    MakeObstaclePhysics(inst, 0.5)
    inst.AnimState:SetBank("sin")
    inst.AnimState:SetBuild("sin")
    inst.AnimState:PlayAnimation("idle", true)

    inst.songToPlay = "mzz/play"
    --inst:AddComponent("inspectable")
    --inst:AddComponent("machine")
    --inst.components.machine.turnonfn = play
    --inst.components.machine.turnofffn = stop

    --inst._light = SpawnPrefab("mzzlight")
    --inst._light.entity:SetParent(inst.entity)
    local light = inst.entity:AddLight()
    light:SetFalloff(1)
    light:SetIntensity(.8)
    light:SetRadius(5 * TUNING.MIKU.Light)
    light:SetColour(255 / 85, 255 / 85, 255 / 85)
    light:Enable(false)
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit) 
    inst:ListenForEvent("onbuilt", onbuilt)
    MakeSnowCovered(inst) 


    -- 启用玩家靠近触发
    inst:AddComponent("playerprox")
    inst.components.playerprox:SetDist(5 * TUNING.MIKU.radius + 5, 5 * TUNING.MIKU.radius + 10)
    inst.count_player = 0
    inst.components.playerprox:SetOnPlayerNear(player_increment)
    inst.components.playerprox:SetOnPlayerFar(player_decrement)

    return inst
end
local function mzzlightfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddLight()
    inst.entity:AddNetwork()

    inst.Light:SetFalloff(0.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetRadius(5)
    inst.Light:SetColour(255 / 255, 255 / 255, 0 / 255)
    inst.Light:Enable(true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.persists = false

    return inst
end

return Prefab("sin", fn, assets), 
MakePlacer("sin_placer", "sin", "sin", "place"), 
Prefab("mzzlight", mzzlightfn)

