
modimport("engine.lua")


Load "chatinputscreen"
Load "consolescreen"
Load "textedit"

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local TECH = GLOBAL.TECH
local SpawnPrefab=GLOBAL.SpawnPrefab





PrefabFiles = 
{

	"guanghuan",
	"sleepcloud_extra",
	"bianhuaspear",
	"lfy_packim",
	"luofeiya",
	"renew_staff",
	"hat_tuer",
	"lfy_ice_fx",
	"lfy_wing",
}
Assets = {

	Asset("SOUNDPACKAGE", "sound/petdonpackimsounds.fev"),
	Asset("SOUND", "sound/petdonpackimsounds_bank00.fsb"),	
	
	-------------
	    Asset( "IMAGE", "images/saveslot_portraits/luofeiya.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/luofeiya.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/luofeiya.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/luofeiya.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/luofeiya_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/luofeiya_silho.xml" ),

    Asset( "IMAGE", "bigportraits/luofeiya.tex" ),
    Asset( "ATLAS", "bigportraits/luofeiya.xml" ),
	
	Asset( "IMAGE", "images/map_icons/luofeiya.tex" ),
	Asset( "ATLAS", "images/map_icons/luofeiya.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_luofeiya.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_luofeiya.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_luofeiya.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_luofeiya.xml" ),
	Asset("ATLAS", "images/inventoryimages/hat_tuer.xml"),
	Asset("IMAGE", "images/inventoryimages/hat_tuer.tex"),
	Asset("ATLAS", "images/inventoryimages/lfy_wing.xml"),
	Asset("IMAGE", "images/inventoryimages/lfy_wing.tex"),
	Asset("ATLAS", "images/inventoryimages/bianhuaspear.xml"),
	Asset("IMAGE", "images/inventoryimages/bianhuaspear.tex"),
	Asset("ATLAS", "images/inventoryimages/renew_staff.xml"),
	Asset("IMAGE", "images/inventoryimages/renew_staff.tex"),
	Asset("ATLAS", "images/inventoryimages/lfy_packim.xml"),
	Asset("IMAGE", "images/inventoryimages/lfy_packim.tex"),
	Asset("ATLAS", "images/hud/luofeiya.xml"),
	Asset("IMAGE", "images/hud/luofeiya.tex"),
}





-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.



STRINGS.TABS.LUOFEIYA_TAB="洛菲雅"
RECIPETABS['LUOFEIYA_TAB'] = {str = "LUOFEIYA_TAB", sort=100, icon = "luofeiya.tex", icon_atlas = "images/hud/luofeiya.xml"}

local hat_tuer = AddRecipe("hat_tuer", { Ingredient("manrabbit_tail", 2),Ingredient("pigskin", 4)}, RECIPETABS.LUOFEIYA_TAB, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/hat_tuer.xml", "hat_tuer.tex" )
hat_tuer.builder_tag ="luofeiya"
local lfy_wing = AddRecipe("lfy_wing", { Ingredient("feather_robin", 8),Ingredient("feather_canary", 2)}, RECIPETABS.LUOFEIYA_TAB, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/lfy_wing.xml", "lfy_wing.tex" )
lfy_wing.builder_tag ="luofeiya"
local bianhuaspear = AddRecipe("bianhuaspear", { Ingredient("thulecite", 3),Ingredient("nightmarefuel", 3),Ingredient("yellowgem", 1)}, RECIPETABS.LUOFEIYA_TAB, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "images/inventoryimages/bianhuaspear.xml", "bianhuaspear.tex" )
bianhuaspear.builder_tag ="luofeiya"
local renew_staff = AddRecipe("renew_staff", { Ingredient("nightmarefuel", 4),Ingredient("purplegem", 2),Ingredient(CHARACTER_INGREDIENT.HEALTH, 40)}, RECIPETABS.LUOFEIYA_TAB, TECH.MAGIC_THREE, nil, nil, nil, nil, nil, "images/inventoryimages/renew_staff.xml", "renew_staff.tex" )
renew_staff.builder_tag ="luofeiya"
local lfy_packim = AddRecipe("lfy_packim", {Ingredient(CHARACTER_INGREDIENT.HEALTH, 100)}, RECIPETABS.LUOFEIYA_TAB, TECH.MAGIC_THREE, nil, nil, nil, nil, nil, "images/inventoryimages/lfy_packim.xml", "lfy_packim.tex" )
lfy_packim.builder_tag ="luofeiya"

local function OnAttacked(inst,data)
	if data.attacker and data.attacker.components.health and not data.attacker.components.health:IsDead() then
		data.attacker.components.health:DoDelta(-30)
		local deer_fire=SpawnPrefab("deer_fire_flakes")
		deer_fire.entity:SetParent(data.attacker.entity)
		deer_fire:DoTaskInTime(1, function(inst)
			inst:Remove()
		end)
	end
end



local function bianshen(inst)
	local player = GLOBAL.ThePlayer
	if inst:HasTag("playerghost") then return end
	if not inst.transformed then
		inst.components.talker:Say("燃烧真元！")
		if inst.bianshen1==nil then
			inst.bianshen1 = SpawnPrefab("guanghuan_back")
			inst.bianshen2 = SpawnPrefab("deer_fire_charge")
			inst.bianshen1.entity:SetParent(inst.entity)
			inst.bianshen2.entity:SetParent(inst.entity)
		end
		--GLOBAL.SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
		inst.components.locomotor.walkspeed = 7
		inst.components.locomotor.runspeed = 9
		inst.components.health.absorb = 0.75
		inst:ListenForEvent("attacked", OnAttacked)
		inst.components.sanity.dapperness =-10/(inst.level*2.4+9) 
		inst.components.hunger.hungerrate = (9-0.11*inst.level)* TUNING.WILSON_HUNGER_RATE
	else
		if inst.bianshen1 then
			inst.bianshen1:Remove()
			inst.bianshen1=nil
		end
		if inst.bianshen2 then
			inst.bianshen2:Remove()
			inst.bianshen2=nil
		end
		--GLOBAL.SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
		inst.components.locomotor.walkspeed = 4
		inst.components.locomotor.runspeed = 6
		inst.components.health.absorb = 0
		inst.components.sanity.dapperness =0 
		inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	end
	inst.transformed = not inst.transformed
	inst.components.health:DoDelta(-5)
	return true
end
 
AddModRPCHandler("luofeiya", "luo1", bianshen)
local function casticepool(x, z,inst)
    local pool = SpawnPrefab("lfy_ice_circle")
	pool.Transform:SetPosition(x, 0, z)
	pool:DoTaskInTime(0, pool.TriggerFX)
	pool:DoTaskInTime(10, pool.KillFX)
	pool._helltask = inst:DoPeriodicTask(0.66, function()						
    	local ents = TheSim:FindEntities(x, 0, z, 6, { "_health" }, { "INLIMBO", "player", "shadowcreature", "notarget","worm" })
    	if #ents > 0 then
        	for i, v in ipairs(ents) do
				--incinerate(inst, dragonfly, v)
        	end
		end
	end)
		pool:DoTaskInTime(10, function() pool._helltask:Cancel() end)		
end

AddModRPCHandler("luofeiya", "luo2", function(player)
	if not player:HasTag("playerghost") and player.prefab == "luofeiya"  then
		if not player:HasTag("cdright") then
			if player.components.hunger.current>=(30-player.level/3) and player.components.sanity.current>=(30-player.level/3) then
				player.components.locomotor:Stop()
				player.AnimState:PlayAnimation("action_uniqueitem_pre")
				player.AnimState:PushAnimation("book", false)
				player.AnimState:Show("ARM_normal")
				player.components.talker:Say("霜雪凝！")
				player.components.hunger:DoDelta(player.level/3-30)
				player.components.sanity:DoDelta(player.level/3-30)
				player.SoundEmitter:PlaySound("dontstarve/rain/thunder_close")
				player:AddTag("cdright")
				player:DoTaskInTime( 10, function() player:RemoveTag("cdright") end)
				local x, y, z = player.Transform:GetWorldPosition()
					local pos = {
						{ x =  3.8*1.5, z =  3.8*1.5 },
						{ x = -5.4*1.5, z =  1.6*1.5 },
						{ x =  1.6*1.5, z = -5.4*1.5 },
						{ x =  -3.8*1.5, z =  -3.8*1.5 },
						{ x = 5.4*1.5, z =  -1.6*1.5 },
						{ x =  -1.6*1.5, z = 5.4*1.5},
						{ x =  0, z =  0 },
						}			
				for k = 1, 7 do
					local x2, z2 = x + pos[k].x, z + pos[k].z				
					casticepool(x2, z2,player)
				end
			else
				player.components.talker:Say("饱食度或精神不足!")
			end
		else
			player.components.talker:Say("未冷却...")
		end
	end
	
end)

local hqghandlers = {}
 
AddPlayerPostInit(function(inst)
	inst:DoTaskInTime(0, function()
		if inst == GLOBAL.ThePlayer then
			if inst.prefab == "luofeiya"   then
				hqghandlers[120] = GLOBAL.TheInput:AddKeyDownHandler(KEY_X, function()
					SendModRPCToServer(MOD_RPC["luofeiya"]["luo2"])
				end)

			else
				for k, v in pairs(hqghandlers) do
					hqghandlers[k] = nil
				end
			end
		end
	end)
end)

local _G = GLOBAL
local old_BUILD = _G.ACTIONS.BUILD.fn
_G.ACTIONS.BUILD.fn = function(act)
	if act.recipe  and act.recipe == "lfy_packim"  then 
		if act.doer.lfy_packim == nil then
			local baobao = SpawnPrefab("lfy_packim")
			if baobao and baobao.components.follower then
				baobao.Transform:SetPosition(act.doer.Transform:GetWorldPosition())
				baobao:AddTag("lfy_packim")
				baobao:LinkToPlayer(act.doer)
				act.doer.components.health:DoDelta(-100)
				return false
			end
			if act.doer ~= nil and act.doer.components.talker  then
				act.doer:DoTaskInTime(0.01,function()
					act.doer.components.talker:Say("出来吧,小醍醐")
				end)
			end
		else
			if act.doer ~= nil and act.doer.components.talker  then
				act.doer:DoTaskInTime(0.01,function()
					act.doer.components.talker:Say("我已经拥有了一个小醍醐")
				end)
			end
			return false
		end
		return old_BUILD(act)
	end
	return old_BUILD(act)
end

--[[AddPrefabPostInit("",function(inst)
	if inst.prefab=="luofeiya" then
		local old = inst.OnNewSpawn or function() return true end
			inst.OnNewSpawn = function(inst)
				inst:DoTaskInTime(0, function()
					if inst.lfy_packim == nil then
						local baobao = SpawnPrefab("lfy_packim")
							if baobao and baobao.components.follower then
								baobao.Transform:SetPosition(inst.Transform:GetWorldPosition())
								baobao:AddTag("lfy_packim")
								baobao:LinkToPlayer(inst)
								return old(inst)
							end
					end
				end)
			end		
	end
end)--]]

-- The character select screen lines
STRINGS.CHARACTER_TITLES.luofeiya = "洛菲雅"
STRINGS.CHARACTER_NAMES.luofeiya = "洛菲雅"
STRINGS.CHARACTER_DESCRIPTIONS.luofeiya = "升级\n燃烧真元\n专属装备"
STRINGS.CHARACTER_QUOTES.luofeiya = "\"洛菲雅公主\""

-- Custom speech strings
STRINGS.CHARACTERS.luofeiya = require "speech_luofeiya"

-- The character's name as appears in-game 
STRINGS.NAMES.luofeiya = "洛菲雅"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.luofeiya = 
{
	GENERIC = "这个是洛菲雅!",
	ATTACKER = "那个洛菲雅看上去很诡异...",
	MURDERER = "凶手!",
	REVIVER = "洛菲雅, 鬼魂的朋友.",
	GHOST = "洛菲雅需要一个救赎之心.",
}

AddMinimapAtlas("images/map_icons/luofeiya.xml")

STRINGS.NAMES.HAT_TUER = "兔耳帽"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HAT_TUER = "看上去很萌很厉害!"
STRINGS.RECIPE_HAT_TUER = "兔耳帽"
STRINGS.RECIPE_DESC.HAT_TUER = "被打有几率触发无敌盾"

STRINGS.NAMES.LFY_WING = "洛菲雅之翼"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LFY_WING = "我可以飞的更远！"
STRINGS.RECIPE_LFY_WING = "洛菲雅之翼"
STRINGS.RECIPE_DESC.LFY_WING = "冬暖夏凉\n升级装备"

STRINGS.NAMES.BIANHUASPEAR = "四转极杀矛"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BIANHUASPEAR = "打架前最好磨一磨"
STRINGS.RECIPE_BIANHUASPEAR = "四转极杀矛"
STRINGS.RECIPE_DESC.BIANHUASPEAR = "耐久越低伤害越高"

STRINGS.NAMES.RENEW_STAFF = "赤霄法杖"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.RENEW_STAFF = "给予队友无私的关怀"
STRINGS.RECIPE_RENEW_STAFF= "赤霄法杖"
STRINGS.RECIPE_DESC.RENEW_STAFF = "召唤回血回脑残的结界"

STRINGS.NAMES.LFY_PACKIM = "小鹈鹕"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LFY_PACKIM = "一个忠实的小跟班"
STRINGS.RECIPE_LFY_PACKIM= "小鹈鹕"
STRINGS.RECIPE_DESC.LFY_PACKIM = "可以砍树挖矿"

AddModCharacter("luofeiya", "FEMALE")