--[[****************************************************************************
  * Copyright (c) 2016. LongFei
  ****************************************************************************]]

--[[
  * 
  * Author: user9_000
  * Date: 2016/12/11
  * Time: 16:10
  * 
--]]

assets =
{
    Asset("ANIM", "anim/hat_tuer.zip"),
    Asset("IMAGE", "images/inventoryimages/hat_tuer.tex"),
    Asset("ATLAS", "images/inventoryimages/hat_tuer.xml")
}
prefabs =
{
	"forcefieldfx",
	"lightning_rod_fx",
}
local function ruinshat_fxanim(inst)
    inst._fx.AnimState:PlayAnimation("hit")
    inst._fx.AnimState:PushAnimation("idle_loop")
end

local function ruinshat_oncooldown(inst)
    inst._task = nil
end

local function ruinshat_unproc(inst)
    if inst:HasTag("forcefield") then
        inst:RemoveTag("forcefield")
        if inst._fx ~= nil then
            inst._fx:kill_fx()
            inst._fx = nil
        end
        inst:RemoveEventCallback("armordamaged", ruinshat_fxanim)

        inst.components.armor:SetAbsorption(0.85)
        inst.components.armor.ontakedamage = nil

        if inst._task ~= nil then
            inst._task:Cancel()
        end
        inst._task = inst:DoTaskInTime(TUNING.ARMOR_RUINSHAT_COOLDOWN, ruinshat_oncooldown)
     end
end

local function ruinshat_proc(inst, owner)
    inst:AddTag("forcefield")
    if inst._fx ~= nil then
        inst._fx:kill_fx()
    end
    inst._fx = SpawnPrefab("forcefieldfx")
    inst._fx.entity:SetParent(owner.entity)
    inst._fx.Transform:SetPosition(0, 0.2, 0)
    inst:ListenForEvent("armordamaged", ruinshat_fxanim)

    inst.components.armor:SetAbsorption(TUNING.FULL_ABSORPTION)
    inst.components.armor.ontakedamage = function(inst, damage_amount)
        if owner ~= nil and owner.components.sanity ~= nil then
            owner.components.sanity:DoDelta(-damage_amount * TUNING.ARMOR_RUINSHAT_DMG_AS_SANITY, false)
        end
    end

    if inst._task ~= nil then
       inst._task:Cancel()
    end
    inst._task = inst:DoTaskInTime(TUNING.ARMOR_RUINSHAT_DURATION, ruinshat_unproc)
end

local function tryproc(inst, owner, data)
    if inst._task == nil and
        not data.redirected and
        math.random() < TUNING.ARMOR_RUINSHAT_PROC_CHANCE then
        ruinshat_proc(inst, owner)
    end
end
local function ruins_onremove(inst)
    if inst._fx ~= nil then
        inst._fx:kill_fx()
		inst._fx = nil
	end
end
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", "hat_tuer", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
	inst.onattach(owner)
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")
	inst.ondetach()
end
local function OnAttacked(inst,data,owner)
	if data.attacker and data.attacker.components.health and not data.attacker.components.health:IsDead() and math.random()<0.3 then
		SpawnPrefab("lightning_rod_fx").Transform:SetPosition(data.attacker.Transform:GetWorldPosition())
		owner.components.talker:Say("闪电！")
	end
end
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)


    inst.AnimState:SetBank("hat_tuer")
    inst.AnimState:SetBuild("hat_tuer")
    inst.AnimState:PlayAnimation("idle")--anim_90s


    inst.entity:AddNetwork()
    inst.entity:SetPristine()
    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.imagename = "images/inventoryimages/hat_tuer.tex"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_tuer.xml"


    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

	inst.OnRemoveEntity = ruins_onremove
	inst._fx = nil
    inst._task = nil
    inst._owner = nil
    inst.procfn = function(owner, data) tryproc(inst, owner, data) end
    inst.onattach = function(owner)
    if inst._owner ~= nil then
        inst:RemoveEventCallback("attacked", inst.procfn, inst._owner)
        inst:RemoveEventCallback("onremove", inst.ondetach, inst._owner)
    end
    inst:ListenForEvent("attacked", inst.procfn, owner)
        inst:ListenForEvent("onremove", inst.ondetach, owner)
        inst._owner = owner
        inst._fx = nil
    end
    inst.ondetach = function()
        ruinshat_unproc(inst)
        if inst._owner ~= nil then
			inst:RemoveEventCallback("attacked", inst.procfn, inst._owner)
			inst:RemoveEventCallback("onremove", inst.ondetach, inst._owner)
			inst._owner = nil
			inst._fx = nil
		end
    end
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(1000, 0.85)
	
	
	inst:ListenForEvent("attacked",OnAttacked)
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)

    return inst
end


return Prefab( "common/inventory/hat_tuer", fn, assets, prefabs)