
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/luofeiya.zip" ),
        Asset( "ANIM", "anim/ghost_luofeiya_build.zip" ),
		Asset("SOUNDPACKAGE", "sound/shengji.fev"),
		Asset("SOUND", "sound/shengji0.fsb"),	
}
local prefabs = {}

-- Custom starting items
local start_inv = {
}

local function applyupgrades(inst)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()
	if inst.level  then
		inst.components.health.maxhealth = math.ceil (120 +(inst.level)*2)
		inst.components.sanity.max = math.ceil (150+2*(inst.level))
		inst.components.hunger.max =math.ceil (120+(inst.level)*2)
	end
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
end

local function oneat(inst, food)
	if food and food.prefab=="durian" and   inst.level < 45 then
		if math.random()<0.7-inst.level*0.0144 then
			inst.level = inst.level + 1
			applyupgrades(inst)	
			inst.SoundEmitter:PlaySound("shengji/shengji0/shengji0")
			local deer_ice=SpawnPrefab("deer_ice_flakes")
			deer_ice.entity:SetParent(inst.entity)
			deer_ice:DoTaskInTime(1.5, function(inst)
				inst:Remove()
			end)
			inst.components.talker:Say("LV：".. (inst.level))
		else
			inst.components.talker:Say("升级失败")
		end
	elseif food and food.prefab=="durian" and  inst.level >= 45 then
		inst.components.talker:Say("MAX!")
	end
end
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end

end
local function loadon(inst,data)

	if data and data.lfy_packim ~= nil and inst.lfy_packim == nil then
        local lfy_packim = SpawnSaveRecord(data.lfy_packim)
        if lfy_packim ~= nil then
            if inst.migrationpets ~= nil then
                table.insert(inst.migrationpets, lfy_packim)
            end
            lfy_packim:LinkToPlayer(inst)
        end
    end
end
local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			--re-set these from the save data, because of load-order clipping issues
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end

end
local function onsave(inst, data)
	data.level = inst.level
	if inst.lfy_packim~= nil then
        data.lfy_packim = inst.lfy_packim:GetSaveRecord()
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "luofeiya.tex" )
	inst.transformed = false 
	inst:AddComponent("keyhandler")
    inst.components.keyhandler:AddActionListener("luofeiya", 122, "luo1")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	inst:AddTag("luofeiya")
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(120)
	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(150)
	
	inst.level = 0
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1

	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.components.talker.fontsize = 25
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(1, 0.8, 0.95, 1)
    inst.components.talker.offset = Vector3(0,-250,0)
	
	inst.OnSave = onsave
	inst.OnLoad=loadon
	inst.OnPreLoad = onpreload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("luofeiya", prefabs, assets, common_postinit, master_postinit, start_inv)
