/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.config;

import chococraft.common.ModChocoCraft;
import chococraft.common.config.Constants;
import chococraft.common.helper.ChocoboBiomeHelper;
import chococraft.common.helper.ChocoboMathHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.world.biome.BiomeGenBase;

public class ChocoboConfig {
    static String CONFIG_FILE_NAME = "chocobo_config.txt";
    static String CFG_TOKEN_COMMENT = "//";
    static String CFG_KEY_SHOW_CHOCO_NAMES = "showChocoboNames";
    static String CFG_KEY_SPAWN_BIOMES = "spawnBiomes";
    static String CFG_KEY_SPAWN_TIME_DELAY = "spawnTimeDelay";
    static String CFG_KEY_SPAWN_GROUP_MIN = "spawnGroupMin";
    static String CFG_KEY_SPAWN_GROUP_MAX = "spawnGroupMax";
    static String CFG_KEY_SPAWN_TOTAL_MAX = "spawnTotalMax";
    static String CFG_KEY_SPAWN_PROBABILITY = "spawnProbability";
    static String CFG_KEY_SPAWN_LIMIT_CHUNK_RADIUS = "spawnLimitChunkRadius";
    static String CFG_KEY_SPAWN_DIST_NEXT_WILD = "distanceNextWild";
    static String CFG_KEY_CHOCOBO_WING_FLUTTER = "chocoboWingFlutter";
    static String CFG_KEY_WILD_CAN_DESPAWN = "wildCanDespawn";
    static String CFG_KEY_HUNGER_ENABLED = "hungerEnabled";
    static String CFG_KEY_RIDER_BUFFS_ENABLED = "riderBuffsEnabled";
    static String CFG_TOKEN_ALL = "all";
    static String CFG_KEY_FEATHER_DELAY_RANDOM = "featherDelayRandom";
    static String CFG_KEY_FEATHER_DELAY_STATIC = "featherDelayStatic";
    static String CFG_KEY_FEATHER_DROP_CHANCE = "featherDropChance";
    static String CFG_KEY_RENDER_NAME_HEIGHT = "renderNameHeight";
    static String CFG_KEY_PEN_HEAL_PROBABILITY = "penHealProbability";
    static String CFG_KEY_PEN_HEAL_CAULDRON_RANGE = "penHealCauldronRange";
    static String CFG_KEY_BREEDING_DELAY_MALE = "breedingDelayMale";
    static String CFG_KEY_BREEDING_DELAY_FEMALE = "breedingDelayFemale";
    static String CFG_KEY_GROWUP_DELAY_STATIC = "growUpDelayStatic";
    static String CFG_KEY_GROWUP_DELAY_RANDOM = "growUpDelayRandom";
    static String CFG_KEY_HUNGER_DELAY_CHOCOBO = "hungerDelayChocobo";
    static String CFG_KEY_HUNGER_DELAY_CHICOBO = "hungerDelayChicobo";
    static String CFG_KEY_LIVING_SOUND_PROB = "livingSoundProbability";
    static String CFG_KEY_GYS_GREEN_MUT_RATE = "gysahlGreenMutationRate";
    static String CFG_KEY_GYS_LOVE_MUT_RATE = "gysahlLoverlyMutationRate";
    static String CFG_KEY_GYS_WORLD_GEN_RATE = "gysahlGreenWorldGenerationRate";
    static String CFG_KEY_SADDLED_CAN_WANDER = "saddledCanWander";
    static String CFG_KEY_CHOCOPEDIA_IN_DUNGEONS = "chocopediaInDungeons";
    static String CFG_KEY_DEBUG_MODE = "debugMode";

    public static void readConfigFileInit() {
        try {
            String line;
            BufferedReader reader = ChocoboConfig.getConfigReader();
            while (null != (line = reader.readLine())) {
                String[] temp;
                if (0 >= line.trim().length() || line.trim().startsWith(CFG_TOKEN_COMMENT) || 2 != (temp = line.split("=")).length) continue;
                String key = temp[0].trim();
                String value = temp[1].trim();
                if (key.isEmpty() || value.isEmpty() || !key.equalsIgnoreCase(CFG_KEY_SPAWN_BIOMES)) continue;
                ModChocoCraft.spawnBiomes = ChocoboConfig.getBiomeGenBaseArray(value);
            }
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void readConfigFilePreInit() {
        try {
            String line;
            BufferedReader reader = ChocoboConfig.getConfigReader();
            while (null != (line = reader.readLine())) {
                String[] temp;
                if (0 >= line.trim().length() || line.trim().startsWith(CFG_TOKEN_COMMENT) || 2 != (temp = line.split("=")).length) continue;
                String key = temp[0].trim();
                String value = temp[1].trim();
                if (key.isEmpty() || value.isEmpty()) continue;
                try {
                    if (key.equalsIgnoreCase(CFG_KEY_SHOW_CHOCO_NAMES)) {
                        ModChocoCraft.showChocoboNames = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_BIOMES)) {
                        ModChocoCraft.spawnBiomes = ChocoboConfig.getBiomeGenBaseArray(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_TIME_DELAY)) {
                        ModChocoCraft.spawnTimeDelay = ChocoboMathHelper.minLimit(Integer.parseInt(value), 50);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_PROBABILITY)) {
                        ModChocoCraft.spawnProbability = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 100);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_GROUP_MIN)) {
                        ModChocoCraft.spawnGroupMin = ChocoboMathHelper.minLimit(Integer.parseInt(value), 1);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_GROUP_MAX)) {
                        ModChocoCraft.spawnGroupMax = ChocoboMathHelper.minLimit(Integer.parseInt(value), 1);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_TOTAL_MAX)) {
                        ModChocoCraft.spawnTotalMax = ChocoboMathHelper.minLimit(Integer.parseInt(value), 1);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_LIMIT_CHUNK_RADIUS)) {
                        ModChocoCraft.spawnLimitChunkRadius = ChocoboMathHelper.minLimit(Integer.parseInt(value), 1);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SPAWN_DIST_NEXT_WILD)) {
                        ModChocoCraft.spawnDistanceNextWild = ChocoboMathHelper.minLimit(Integer.parseInt(value), 60);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_CHOCOBO_WING_FLUTTER)) {
                        ModChocoCraft.chocoboWingFlutter = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_WILD_CAN_DESPAWN)) {
                        ModChocoCraft.wildCanDespawn = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_HUNGER_ENABLED)) continue;
                    if (key.equalsIgnoreCase(CFG_KEY_RIDER_BUFFS_ENABLED)) {
                        ModChocoCraft.riderBuffsEnabled = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_FEATHER_DELAY_RANDOM)) {
                        ModChocoCraft.featherDelayRandom = ChocoboMathHelper.minLimit(Integer.parseInt(value), 60);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_FEATHER_DELAY_STATIC)) {
                        ModChocoCraft.featherDelayStatic = ChocoboMathHelper.minLimit(Integer.parseInt(value), 60);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_FEATHER_DROP_CHANCE)) {
                        ModChocoCraft.featherDropChance = ChocoboMathHelper.minLimit(Integer.parseInt(value), 1);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_RENDER_NAME_HEIGHT)) {
                        double tmprnh = Double.parseDouble(value);
                        if (tmprnh < 0.0) {
                            ModChocoCraft.renderNameHeight = -2.2;
                            continue;
                        }
                        if (tmprnh > 10.0) {
                            ModChocoCraft.renderNameHeight = 7.7;
                            continue;
                        }
                        ModChocoCraft.renderNameHeight = tmprnh;
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_LIVING_SOUND_PROB)) {
                        ModChocoCraft.livingSoundProb = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 100);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_PEN_HEAL_PROBABILITY)) {
                        ModChocoCraft.penHealProbability = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 100);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_PEN_HEAL_CAULDRON_RANGE)) {
                        ModChocoCraft.penHealCauldronRange = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 15);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_BREEDING_DELAY_MALE)) {
                        ModChocoCraft.breedingDelayMale = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_BREEDING_DELAY_FEMALE)) {
                        ModChocoCraft.breedingDelayFemale = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equals(CFG_KEY_GROWUP_DELAY_RANDOM)) {
                        ModChocoCraft.growupDelayRandom = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equals(CFG_KEY_GROWUP_DELAY_STATIC)) {
                        ModChocoCraft.growupDelayStatic = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equals(CFG_KEY_HUNGER_DELAY_CHICOBO)) {
                        ModChocoCraft.hungerDelayChicobo = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equals(CFG_KEY_HUNGER_DELAY_CHOCOBO)) {
                        ModChocoCraft.hungerDelayChocobo = ChocoboMathHelper.minLimit(Integer.parseInt(value), 20);
                        continue;
                    }
                    if (key.equals(CFG_KEY_GYS_GREEN_MUT_RATE)) {
                        ModChocoCraft.gysahlGreenMutationRate = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 1000);
                        continue;
                    }
                    if (key.equals(CFG_KEY_GYS_LOVE_MUT_RATE)) {
                        ModChocoCraft.gysahlLoveMutationRate = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 1000);
                        continue;
                    }
                    if (key.equals(CFG_KEY_GYS_WORLD_GEN_RATE)) {
                        ModChocoCraft.gysahlWorldGenRate = ChocoboMathHelper.clamp(Integer.parseInt(value), 1, 999);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_SADDLED_CAN_WANDER)) {
                        ModChocoCraft.saddledCanWander = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (key.equalsIgnoreCase(CFG_KEY_CHOCOPEDIA_IN_DUNGEONS)) {
                        ModChocoCraft.chocopediaInDungeons = Boolean.parseBoolean(value);
                        continue;
                    }
                    if (!key.equalsIgnoreCase(CFG_KEY_DEBUG_MODE)) continue;
                    ModChocoCraft.debugMode = Boolean.parseBoolean(value);
                }
                catch (NumberFormatException e) {}
            }
            reader.close();
        }
        catch (FileNotFoundException fnfe) {
            ChocoboConfig.createNewConfigFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BiomeGenBase[] getBiomeGenBaseArray(String valueString) {
        if (valueString.equals(CFG_TOKEN_ALL)) {
            return ChocoboBiomeHelper.getBiomeGenBaseArray();
        }
        String[] values = valueString.split(",");
        ArrayList<BiomeGenBase> bgbList = new ArrayList<BiomeGenBase>();
        for (String value : values) {
            if (value.trim().isEmpty()) continue;
            if (value.trim().equals(CFG_TOKEN_ALL)) {
                return ChocoboBiomeHelper.getBiomeGenBaseArray();
            }
            for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
                if (biomeGenBase == null || !value.trim().equals(biomeGenBase.field_76791_y)) continue;
                bgbList.add(biomeGenBase);
            }
        }
        BiomeGenBase[] bgbArray = new BiomeGenBase[bgbList.size()];
        int i = 0;
        Iterator iterator = bgbList.iterator();
        while (iterator.hasNext()) {
            BiomeGenBase bgb;
            bgbArray[i] = bgb = (BiomeGenBase)iterator.next();
            ++i;
        }
        if (0 < bgbArray.length) {
            return bgbArray;
        }
        return ChocoboBiomeHelper.getBiomeGenBaseArray();
    }

    private static void createNewConfigFile() {
        File file = ChocoboConfig.getConfigFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            writer.write("\n");
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SHOW_CHOCO_NAMES, Boolean.toString(Constants.DEFAULT_SHOW_CHOCOBO_NAMES)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_CHOCOBO_WING_FLUTTER, Boolean.toString(Constants.DEFAULT_CHOCOBO_WING_FLUTTER)));
            writer.write(ChocoboConfig.getCommentLine("hunger not yet active"));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_HUNGER_ENABLED, Boolean.toString(Constants.DEFAULT_HUNGER_ENABLED)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_RIDER_BUFFS_ENABLED, Boolean.toString(Constants.DEFAULT_RIDER_BUFFS_ENABLED)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SADDLED_CAN_WANDER, Boolean.toString(Constants.DEFAULT_SADDLED_CAN_WANDER)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("The default name height is 2.3 blocks from the ground. You can add height"));
            writer.write(ChocoboConfig.getCommentLine("up to 10 blocks by the number given as " + CFG_KEY_RENDER_NAME_HEIGHT + "."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_RENDER_NAME_HEIGHT, Double.toString(Constants.DEFAULT_RENDER_NAME_HEIGHT)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("The value given as " + CFG_KEY_LIVING_SOUND_PROB + "will determine the Chocobo 'Kweh' frequency."));
            writer.write(ChocoboConfig.getCommentLine("The system will call a method to trigger the living sound and the Chocobo will do a"));
            writer.write(ChocoboConfig.getCommentLine("'Kweh'. The number set with this key will reduce the frequency to this number in 100."));
            writer.write(ChocoboConfig.getCommentLine("Thus if it is set to 50 only every second 'Kweh' will be heared. If set to 1 only "));
            writer.write(ChocoboConfig.getCommentLine("every 100th etc..."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_LIVING_SOUND_PROB, Integer.toString(Constants.DEFAULT_LIVING_SOUND_PROB)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Mutation rates of planted and grown gysahl greens. There is a " + CFG_KEY_GYS_GREEN_MUT_RATE + " permille chance"));
            writer.write(ChocoboConfig.getCommentLine("the gysahl plant will mutate into a breeding gysahl. If the plant has mutated into"));
            writer.write(ChocoboConfig.getCommentLine("a breeding gysahl, there is a " + CFG_KEY_GYS_LOVE_MUT_RATE + " permille change of it being a golden Gysahl."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_GYS_GREEN_MUT_RATE, Integer.toString(Constants.DEFAULT_GYSAHL_GREEN_MUTATION_RATE)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_GYS_LOVE_MUT_RATE, Integer.toString(Constants.DEFAULT_GYSAHL_LOVE_MUTATION_RATE)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("value between 1 and 999, with 1 for very few wild gysahl and 999 very many."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_GYS_WORLD_GEN_RATE, Integer.toString(Constants.DEFAULT_GYSAHL_WORLD_GEN_RATE)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Cool down phase between breeding"));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_BREEDING_DELAY_FEMALE, Integer.toString(Constants.DEFAULT_BREEDING_DELAY_FEMALE)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_BREEDING_DELAY_MALE, Integer.toString(Constants.DEFAULT_BREEDING_DELAY_MALE)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Chicobos will grow up into Chocobos after " + CFG_KEY_GROWUP_DELAY_STATIC + " plus"));
            writer.write(ChocoboConfig.getCommentLine("0 - " + CFG_KEY_GROWUP_DELAY_RANDOM + " ticks."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_GROWUP_DELAY_STATIC, Integer.toString(Constants.DEFAULT_GROWUP_DELAY_STATIC)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_GROWUP_DELAY_RANDOM, Integer.toString(Constants.DEFAULT_GROWUP_DELAY_RANDOM)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Time after which Chicobos and Chocobos will get hungry again (disabled)"));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_HUNGER_DELAY_CHICOBO, Integer.toString(Constants.DEFAULT_HUNGER_DELAY_CHICOBO)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_HUNGER_DELAY_CHOCOBO, Integer.toString(Constants.DEFAULT_HUNGER_DELAY_CHOCOBO)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Whenever a hurt Chocobo is standing on straw less than " + CFG_KEY_PEN_HEAL_CAULDRON_RANGE + " blocks away from"));
            writer.write(ChocoboConfig.getCommentLine("a filled cauldron, it has a" + CFG_KEY_PEN_HEAL_PROBABILITY + " chance every 2 seconds to heal one health point."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_PEN_HEAL_PROBABILITY, Integer.toString(Constants.DEFAULT_PEN_HEAL_PROBABILITY)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_PEN_HEAL_CAULDRON_RANGE, Integer.toString(Constants.DEFAULT_PEN_HEAL_CAULDRON_RANGE)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Whenever or not wild Chocobos will be able to despawn if no player is around"));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_WILD_CAN_DESPAWN, Boolean.toString(Constants.DEFAULT_WILD_CAN_DESPAWN)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("Whenever or not the Chocopedia can be found in dungeon, jungle and desert pyramid, stronghold and mine chests"));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_CHOCOPEDIA_IN_DUNGEONS, Boolean.toString(Constants.DEFAULT_CHOCOPEDIA_IN_DUNGEONS)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("add any name of the following list as comma separated values to"));
            writer.write(ChocoboConfig.getCommentLine("the " + CFG_KEY_SPAWN_BIOMES + "key, to have Chocobos spawn in the"));
            writer.write(ChocoboConfig.getCommentLine("designated biomes. Add the token 'all' to have Chocobos spawn in "));
            writer.write(ChocoboConfig.getCommentLine("all biomes."));
            writer.write(ChocoboConfig.getCommentLine("Possible biome names:"));
            writer.write(ChocoboConfig.getCommentLine(ChocoboConfig.getAllBiomeNames()));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_BIOMES, ChocoboConfig.writeCSVBiomeNames(ModChocoCraft.spawnBiomes)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("A group of " + CFG_KEY_SPAWN_GROUP_MIN + " to " + CFG_KEY_SPAWN_GROUP_MAX + " Yellow Chocobos will spawn with the"));
            writer.write(ChocoboConfig.getCommentLine("probability of " + CFG_KEY_SPAWN_PROBABILITY + " around every player. There will be no additional"));
            writer.write(ChocoboConfig.getCommentLine("spawning if " + CFG_KEY_SPAWN_TOTAL_MAX + " wild Chocobos are active in an area with the radius of " + CFG_KEY_SPAWN_LIMIT_CHUNK_RADIUS + " chunks."));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_TIME_DELAY, Integer.toString(ModChocoCraft.spawnTimeDelay)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_PROBABILITY, Integer.toString(ModChocoCraft.spawnProbability)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_GROUP_MIN, Integer.toString(ModChocoCraft.spawnGroupMin)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_GROUP_MAX, Integer.toString(ModChocoCraft.spawnGroupMax)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_TOTAL_MAX, Integer.toString(ModChocoCraft.spawnTotalMax)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_LIMIT_CHUNK_RADIUS, Integer.toString(ModChocoCraft.spawnLimitChunkRadius)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_SPAWN_DIST_NEXT_WILD, Integer.toString(ModChocoCraft.spawnDistanceNextWild)));
            writer.write("\n");
            writer.write(ChocoboConfig.getCommentLine("tamed chocobos have a chance of " + CFG_KEY_FEATHER_DROP_CHANCE + " in 100 to drop a feather every"));
            writer.write(ChocoboConfig.getCommentLine(CFG_KEY_FEATHER_DELAY_RANDOM + "/20 to " + CFG_KEY_FEATHER_DELAY_RANDOM + "/20 plus " + CFG_KEY_FEATHER_DELAY_STATIC + "/20 seconds"));
            writer.write(ChocoboConfig.getCommentLine(""));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_FEATHER_DELAY_RANDOM, Integer.toString(ModChocoCraft.featherDelayRandom)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_FEATHER_DELAY_STATIC, Integer.toString(ModChocoCraft.featherDelayStatic)));
            writer.write(ChocoboConfig.getConfigLine(CFG_KEY_FEATHER_DROP_CHANCE, Integer.toString(ModChocoCraft.featherDropChance)));
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String writeCSVBiomeNames(BiomeGenBase[] yellowSpawnBiomes) {
        String biomesNamesCSV = "";
        boolean firstName = true;
        for (BiomeGenBase biomeGenBase : yellowSpawnBiomes) {
            if (!firstName) {
                biomesNamesCSV = biomesNamesCSV + ",";
            }
            biomesNamesCSV = biomesNamesCSV + biomeGenBase.field_76791_y;
            firstName = false;
        }
        return biomesNamesCSV;
    }

    private static String getAllBiomeNames() {
        String bgbNameList = "";
        Boolean firstName = true;
        for (BiomeGenBase bgb : BiomeGenBase.func_150565_n()) {
            if (null == bgb) continue;
            if (!firstName.booleanValue()) {
                bgbNameList = bgbNameList + ", ";
            } else {
                firstName = false;
            }
            bgbNameList = bgbNameList + bgb.field_76791_y;
        }
        return bgbNameList;
    }

    public static String getConfigLine(String key, String value) {
        return key + " = " + value + "\n";
    }

    public static String getConfigLine(String key, ArrayList<String> values) {
        String configLine = key + " = ";
        Boolean firstValue = true;
        for (String value : values) {
            if (!firstValue.booleanValue()) {
                configLine = configLine + ", ";
            } else {
                firstValue = false;
            }
            configLine = configLine + value;
        }
        return configLine;
    }

    public static String getCommentLine(String comment) {
        if (!comment.endsWith("\n")) {
            comment = comment + "\n";
        }
        return CFG_TOKEN_COMMENT + " " + comment;
    }

    public static BufferedReader getConfigReader() throws UnsupportedEncodingException, FileNotFoundException {
        File file = ChocoboConfig.getConfigFile();
        if (file != null) {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        }
        return null;
    }

    private static File getConfigFile() {
        return new File(ChocoboConfig.getConfigFolderName(), ChocoboConfig.getConfigFileName());
    }

    public static String getConfigFolderName() {
        return ModChocoCraft.configFolder.toString();
    }

    public static String getConfigFileName() {
        return CONFIG_FILE_NAME;
    }
}

