/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities;

import chococraft.common.ModChocoCraft;
import chococraft.common.entities.ChocoboNames;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChicobo;
import chococraft.common.entities.EntityChocobo;
import chococraft.common.entities.colours.EntityChocoboBlack;
import chococraft.common.entities.colours.EntityChocoboBlue;
import chococraft.common.entities.colours.EntityChocoboGold;
import chococraft.common.entities.colours.EntityChocoboGreen;
import chococraft.common.entities.colours.EntityChocoboPink;
import chococraft.common.entities.colours.EntityChocoboPurple;
import chococraft.common.entities.colours.EntityChocoboRed;
import chococraft.common.entities.colours.EntityChocoboWhite;
import chococraft.common.entities.colours.EntityChocoboYellow;
import java.util.Random;
import net.minecraft.world.World;

public class FactoryEntityChocobo {
    public static EntityChocobo createNewChocobo(World world, EntityAnimalChocobo.chocoboColor color) {
        EntityChocobo entityChocobo;
        boolean isMale = new Random().nextInt(100) < ModChocoCraft.genderMaleChance;
        String name = ChocoboNames.getRandomName(isMale);
        switch (color) {
            case YELLOW: {
                entityChocobo = new EntityChocoboYellow(world);
                break;
            }
            case GREEN: {
                entityChocobo = new EntityChocoboGreen(world);
                break;
            }
            case BLUE: {
                entityChocobo = new EntityChocoboBlue(world);
                break;
            }
            case WHITE: {
                entityChocobo = new EntityChocoboWhite(world);
                break;
            }
            case BLACK: {
                entityChocobo = new EntityChocoboBlack(world);
                break;
            }
            case GOLD: {
                entityChocobo = new EntityChocoboGold(world);
                break;
            }
            case PINK: {
                entityChocobo = new EntityChocoboPink(world);
                break;
            }
            case RED: {
                entityChocobo = new EntityChocoboRed(world);
                break;
            }
            case PURPLE: {
                entityChocobo = new EntityChocoboPurple(world);
                break;
            }
            default: {
                entityChocobo = new EntityChocoboYellow(world);
            }
        }
        entityChocobo.setIsMale(isMale);
        entityChocobo.setName(name);
        return entityChocobo;
    }

    public static EntityChocobo createChocobo(World world, EntityAnimalChocobo.chocoboColor color, String name, String owner, boolean hidename, boolean tamed, boolean following, boolean wander, boolean male) {
        EntityChocobo chocobo = FactoryEntityChocobo.createNewChocobo(world, color);
        chocobo.setName(name);
        chocobo.func_152115_b(owner);
        chocobo.setHidename(hidename);
        chocobo.func_70903_f(tamed);
        chocobo.setFollowing(following);
        chocobo.setWander(wander);
        chocobo.setIsMale(male);
        return chocobo;
    }

    public static EntityChocobo createChocoboFromChocobo(World world, EntityAnimalChocobo sourceChocobo) {
        EntityChocobo chocobo = FactoryEntityChocobo.createNewChocobo(world, sourceChocobo.color);
        chocobo.setName(sourceChocobo.getName());
        chocobo.func_152115_b(sourceChocobo.func_152113_b());
        chocobo.setHidename(sourceChocobo.isHidename());
        chocobo.func_70903_f(sourceChocobo.func_70909_n());
        chocobo.setFollowing(sourceChocobo.isFollowing());
        chocobo.setWander(sourceChocobo.isWander());
        chocobo.setIsMale(sourceChocobo.isMale());
        return chocobo;
    }

    public static EntityChicobo createNewChicobo(World world, EntityAnimalChocobo.chocoboColor color) {
        boolean isMale = new Random().nextInt(100) < ModChocoCraft.genderMaleChance;
        EntityChicobo chicobo = new EntityChicobo(world);
        chicobo.setColor(color);
        chicobo.setIsMale(isMale);
        chicobo.setName(ChocoboNames.getRandomName(chicobo.isMale()));
        return chicobo;
    }

    public static EntityChicobo createChicobo(World world, EntityAnimalChocobo.chocoboColor color, String name, String owner, boolean hidename, boolean tamed, Boolean following, boolean male) {
        EntityChicobo entityChicobo = FactoryEntityChocobo.createNewChicobo(world, color);
        entityChicobo.setName(name);
        entityChicobo.func_152115_b(owner);
        entityChicobo.setHidename(hidename);
        entityChicobo.func_70903_f(tamed);
        entityChicobo.setFollowing(following);
        entityChicobo.setIsMale(male);
        return entityChicobo;
    }
}

