/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.entities.colours;

import chococraft.common.config.Constants;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocobo;
import chococraft.common.entities.FactoryEntityChocobo;
import chococraft.common.helper.ChocoboParticleHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityChocoboGold
extends EntityChocobo {
    public EntityChocoboGold(World world) {
        super(world);
        this.color = EntityAnimalChocobo.chocoboColor.GOLD;
        this.func_70606_j(this.func_110138_aP());
        this.canClimb = true;
        this.canCrossWater = true;
        this.canFly = true;
        this.canJumpHigh = Constants.CHOCOBO_GOLD_CANJUMPHIGH;
        this.field_70178_ae = false;
        this.landSpeedFactor = Constants.CHOCOBO_GOLD_LANDSPEEDFACT;
        this.waterSpeedFactor = Constants.CHOCOBO_GOLD_WATERSPEEDFACT;
        this.airbornSpeedFactor = Constants.CHOCOBO_GOLD_AIRSPEEDFACT;
    }

    @Override
    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
    }

    @Override
    public String getEntityColourTexture() {
        return "goldchocobo.png";
    }

    @Override
    public void setStepHeight(boolean mounted) {
        this.field_70138_W = mounted ? 2.0f : 0.5f;
    }

    @Override
    public void setLandSpeedFactor(boolean mounted) {
        this.landSpeedFactor = mounted ? Constants.CHOCOBO_GOLD_LANDSPEEDFACT : Constants.CHOCOBO_DEFAULT_LANDSPEEDFACT;
    }

    @Override
    public void setJumpHigh(boolean mounted) {
        this.canJumpHigh = mounted && Constants.CHOCOBO_GOLD_CANJUMPHIGH;
    }

    @Override
    public void setRiderAbilities(boolean mounted) {
    }

    @Override
    public float getChocoboMaxHealth() {
        return 50.0f;
    }

    @Override
    protected void func_70069_a(float fallHeight) {
    }

    @Override
    public EntityAnimalChocobo.chocoboColor getBabyAnimalColor(EntityAgeable otherAnimalParent) {
        if (otherAnimalParent instanceof EntityChocobo) {
            EntityChocobo otherParent = (EntityChocobo)otherAnimalParent;
            boolean bothFedGold = this.fedGold && otherParent.fedGold;
            int randColor = this.field_70146_Z.nextInt(100);
            EntityAnimalChocobo.chocoboColor chicoboColor = EntityAnimalChocobo.chocoboColor.GOLD;
            switch (otherParent.color) {
                case YELLOW: 
                case GREEN: 
                case BLUE: 
                case WHITE: 
                case BLACK: 
                case PURPLE: {
                    chicoboColor = otherParent.color;
                    break;
                }
                case GOLD: 
                case PINK: 
                case RED: {
                    if (bothFedGold && randColor <= 20) break;
                    chicoboColor = EntityAnimalChocobo.chocoboColor.YELLOW;
                }
            }
            return chicoboColor;
        }
        return null;
    }

    @Override
    protected void onPaint(EntityPlayer entityplayer, boolean isPink) {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (this.isServer()) {
            EntityChocobo entitychocobo = FactoryEntityChocobo.createChocobo(this.field_70170_p, isPink ? EntityAnimalChocobo.chocoboColor.PINK : EntityAnimalChocobo.chocoboColor.RED, this.getName(), this.func_152113_b(), this.isHidename(), this.func_70909_n(), this.isFollowing(), this.isWander(), this.isMale());
            entitychocobo.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            entitychocobo.func_70873_a(this.func_70874_b());
            entitychocobo.setSaddled(this.isSaddled());
            entitychocobo.setSaddleBagged(this.isSaddleBagged());
            entitychocobo.setPackBagged(this.isPackBagged());
            entitychocobo.setWander(this.isWander());
            entitychocobo.setFollowing(this.isFollowing());
            entitychocobo.injectInventory(this.bagsInventory);
            this.field_70170_p.func_72838_d((Entity)entitychocobo);
            this.func_70606_j(0.0f);
            this.func_70106_y();
        } else {
            for (int i = 0; i < 20; ++i) {
                ChocoboParticleHelper.showParticleAroundEntityFx(Constants.PARTICLE_EXPLODE, (Entity)this);
            }
        }
        this.useItem(entityplayer);
    }
}

