/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.events;

import chococraft.common.network.PacketRegistry;
import chococraft.common.network.clientSide.ChocoboLocalSetupUpdate;
import chococraft.common.network.clientSide.ChocoboSetupUpdate;
import chococraft.common.utils.UpdateChecker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ChocoboPlayerTracker {
    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.sendSetupUpdate((EntityPlayerMP)event.player);
        try {
            UpdateChecker.VersionInfo latestVersionInfo = UpdateChecker.getResponse().versions.get(0);
            if (latestVersionInfo.modversion.equals("4.1.5")) {
                return;
            }
            ChatStyle styleUnderlined = new ChatStyle().func_150228_d(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.GOLD);
            ChatStyle style = new ChatStyle().func_150238_a(EnumChatFormatting.GOLD);
            IChatComponent text = new ChatComponentText("An update is avilable for Chococraft!, Latest version: " + latestVersionInfo.modversion).func_150255_a(styleUnderlined);
            event.player.func_146105_b(text);
            text = new ChatComponentText("Changes:").func_150255_a(style);
            event.player.func_146105_b(text);
            for (String line : latestVersionInfo.changes) {
                text = new ChatComponentText(line).func_150255_a(style);
                event.player.func_146105_b(text);
            }
            text = new ChatComponentText("Get the latest version at http://minecraft.curseforge.com/mc-mods/225280-chococraft").func_150255_a(style);
            event.player.func_146105_b(text);
        }
        catch (NullPointerException npe) {
            System.out.println("npe choco");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.sendLocalSetupUpdate((EntityPlayerMP)event.player);
    }

    protected void sendSetupUpdate(EntityPlayerMP player) {
        if (!player.field_70170_p.field_72995_K) {
            ChocoboSetupUpdate packet = new ChocoboSetupUpdate();
            PacketRegistry.INSTANCE.sendTo((IMessage)packet, player);
        }
    }

    protected void sendLocalSetupUpdate(EntityPlayerMP player) {
        if (!player.field_70170_p.field_72995_K) {
            ChocoboLocalSetupUpdate packet = new ChocoboLocalSetupUpdate();
            PacketRegistry.INSTANCE.sendTo((IMessage)packet, player);
        }
    }
}

