/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.helper;

import chococraft.common.entities.EntityChocobo;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChocoboEntityHelper {
    public static int countEntities(Class entityClass, World world) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!entityClass.isAssignableFrom(entity.getClass())) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static int countWildChocobos(World world) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || ((EntityChocobo)entity).func_70909_n()) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static int countWildChocobosInChunk(World world, Chunk chunk) {
        int amountEntities = 0;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Chunk entityChunk;
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!(entity instanceof EntityChocobo) || ((EntityChocobo)entity).func_70909_n() || !(entityChunk = world.func_72938_d(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v))).equals(chunk)) continue;
            ++amountEntities;
        }
        return amountEntities;
    }

    public static boolean isEntityViewingUnderWater(World world, EntityLiving entity) {
        Vec3 vector = ActiveRenderInfo.func_74585_b((EntityLivingBase)entity, (double)90.0);
        ChunkPosition chunkPos = new ChunkPosition(vector);
        Block blockFront = world.func_147439_a(chunkPos.field_151329_a, chunkPos.field_151327_b, chunkPos.field_151328_c);
        Block blockAbove = world.func_147439_a(chunkPos.field_151329_a, chunkPos.field_151327_b + 1, chunkPos.field_151328_c);
        if (blockAbove.equals(Blocks.field_150350_a) || blockFront.equals(Blocks.field_150350_a)) {
            return false;
        }
        boolean frontWater = blockFront.func_149688_o().equals(Material.field_151586_h);
        boolean aboveWater = blockAbove.func_149688_o().equals(Material.field_151586_h);
        return frontWater && aboveWater;
    }

    public static boolean isSpaceAroundFree(World world, EntityLiving entity, int radX, int spcY, int radZ) {
        return ChocoboEntityHelper.isSpaceAroundLocationFree(world, (int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v, radX, spcY, radZ);
    }

    public static boolean isSpaceAroundLocationFree(World world, int startX, int startY, int startZ, int radX, int spcY, int radZ) {
        int sPosX = startX - radX;
        int sPosY = startY + 1;
        int sPosZ = startZ - radZ;
        int ePosX = startX + radX;
        int ePosY = startY + spcY;
        int ePosZ = startZ + radZ;
        for (int x = sPosX; x <= ePosX; ++x) {
            for (int y = sPosY; y <= ePosY; ++y) {
                for (int z = sPosZ; z <= ePosZ; ++z) {
                    if (world.func_147437_c(x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

