/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.network.clientSide;

import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.helper.ChocoboParticleHelper;
import chococraft.common.network.PacketHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;

public class ChocoboParticles
implements IMessage {
    public int entityID;
    public String particleName;
    public int particleAmount;
    public int dimensionId;

    public ChocoboParticles() {
    }

    public ChocoboParticles(EntityAnimalChocobo chocobo, String particleName, int particleAmount) {
        this.entityID = chocobo.func_145782_y();
        this.particleName = particleName;
        this.particleAmount = particleAmount;
        this.dimensionId = chocobo.field_70170_p.field_73011_w.field_76574_g;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.particleName);
        buffer.writeInt(this.particleAmount);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.particleName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.particleAmount = buffer.readInt();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboParticles, IMessage> {
        public IMessage onMessage(ChocoboParticles message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null) {
                ChocoboParticleHelper.showParticleAroundEntityFx(message.particleName, (Entity)chocobo, message.particleAmount);
            }
            return null;
        }
    }
}

