/*
 * Decompiled with CFR 0.152.
 */
package chococraft.common.network.serverSide;

import chococraft.common.config.ChocoCraftItems;
import chococraft.common.entities.EntityAnimalChocobo;
import chococraft.common.entities.EntityChocoboRideable;
import chococraft.common.network.PacketHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;

public class ChocoboDropGear
implements IMessage {
    public int entityID;
    public int dimensionId;

    public ChocoboDropGear() {
    }

    public ChocoboDropGear(EntityChocoboRideable chicobo) {
        this.entityID = chicobo.func_145782_y();
        this.dimensionId = chicobo.field_70170_p.field_73011_w.field_76574_g;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.entityID);
        buffer.writeInt(this.dimensionId);
    }

    public void fromBytes(ByteBuf buffer) {
        this.entityID = buffer.readInt();
        this.dimensionId = buffer.readInt();
    }

    public static class Handler
    implements IMessageHandler<ChocoboDropGear, IMessage> {
        public IMessage onMessage(ChocoboDropGear message, MessageContext ctx) {
            EntityAnimalChocobo chocobo = PacketHelper.getChocoboByID(message.entityID, message.dimensionId);
            if (chocobo != null && chocobo instanceof EntityChocoboRideable) {
                EntityChocoboRideable chocoRideable = (EntityChocoboRideable)chocobo;
                if (chocoRideable.isSaddleBagged().booleanValue()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.chocoboSaddleBagsItem, 1), 0.0f);
                    chocoRideable.getChocoBagInventory().dropAllItems();
                    chocoRideable.setSaddleBagged(false);
                }
                if (chocoRideable.isSaddled()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.chocoboSaddleItem, 1), 0.0f);
                    chocoRideable.setSaddled(false);
                }
                if (chocoRideable.isPackBagged().booleanValue()) {
                    chocoRideable.func_70099_a(new ItemStack(ChocoCraftItems.chocoboPackBagsItem, 1), 0.0f);
                    chocoRideable.getChocoBagInventory().dropAllItems();
                    chocoRideable.setPackBagged(false);
                }
            }
            return null;
        }
    }
}

