/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.chococraft.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="chococraft")
@Config(modid="chococraft")
public class ChocoConfig {
    @Config.Comment(value={"World generation related configuration"})
    @Config.Name(value="world")
    public static WorldConfig world = new WorldConfig();
    @Config.Name(value="chocobo")
    public static ChocoboConfig chocobo = new ChocoboConfig();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("chococraft")) {
            if (ChocoConfig.world.chocoboPackSizeMin > ChocoConfig.world.chocoboPackSizeMax) {
                int t = ChocoConfig.world.chocoboPackSizeMax;
                ChocoConfig.world.chocoboPackSizeMax = ChocoConfig.world.chocoboPackSizeMin;
                ChocoConfig.world.chocoboPackSizeMin = t;
            }
            ConfigManager.sync((String)"chococraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ChocoboConfig {
        @Config.RangeDouble(min=0.0, max=1.0)
        public double tameChance = 0.15;
    }

    public static class WorldConfig {
        @Config.RangeInt(min=0, max=99999)
        @Config.Comment(value={"Controls the weight compared to other world gen"})
        @Config.RequiresMcRestart
        public int gysahlGreenSpawnWeight = 3;
        @Config.RangeInt(min=0, max=128)
        public int gysahlGreenPatchSize = 64;
        @Config.RangeDouble(min=0.0, max=1.0)
        public double gysahlGreenSpawnChance = 0.1;
        @Config.RangeInt(min=0, max=99999)
        @Config.RequiresMcRestart
        public int chocoboSpawnWeight = 10;
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int chocoboPackSizeMin = 1;
        @Config.RangeInt(min=0, max=100)
        @Config.RequiresMcRestart
        public int chocoboPackSizeMax = 3;
        @Config.RequiresMcRestart
        public int retrogenId = 1;
    }
}

