/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.chococraft.common.entities;

import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemStackHandler;
import net.xalcon.chococraft.common.ChocoConfig;
import net.xalcon.chococraft.common.entities.properties.ChocoboAbilityInfo;
import net.xalcon.chococraft.common.entities.properties.ChocoboColor;
import net.xalcon.chococraft.common.entities.properties.EntityDataSerializers;
import net.xalcon.chococraft.common.entities.properties.MovementType;
import net.xalcon.chococraft.common.entities.properties.SaddleType;
import net.xalcon.chococraft.common.init.ModItems;
import net.xalcon.chococraft.common.inventory.ContainerSaddleBag;
import net.xalcon.chococraft.common.inventory.SaddleItemStackHandler;
import net.xalcon.chococraft.common.network.PacketManager;
import net.xalcon.chococraft.common.network.packets.PacketOpenChocoboGui;

public class EntityChocobo
extends EntityTameable {
    private static final DataParameter<ChocoboColor> PARAM_VARIANT = EntityDataManager.func_187226_a(EntityChocobo.class, EntityDataSerializers.CHOCOBO_COLOR);
    private static final DataParameter<Boolean> PARAM_IS_MALE = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<MovementType> PARAM_MOVEMENT_TYPE = EntityDataManager.func_187226_a(EntityChocobo.class, EntityDataSerializers.MOVEMENT_TYPE);
    private static final DataParameter<ItemStack> PARAM_SADDLE_ITEM = EntityDataManager.func_187226_a(EntityChocobo.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final ResourceLocation CHOCOBO_LOOTABLE = new ResourceLocation("chococraft", "entities/chocobo");
    public final ItemStackHandler chocoboInventory = new ItemStackHandler();
    public final SaddleItemStackHandler saddleItemStackHandler = new SaddleItemStackHandler(){

        @Override
        protected void onStackChanged() {
            EntityChocobo.this.setSaddleType(this.itemStack);
        }
    };
    private ChocoboAbilityInfo abilityInfo;
    private float wingRotDelta;
    public float wingRotation;
    public float destPos;

    public SaddleType getSaddleType() {
        return ModItems.chocoboSaddle.getSaddleType((ItemStack)this.field_70180_af.func_187225_a(PARAM_SADDLE_ITEM));
    }

    private void setSaddleType(ItemStack saddleStack) {
        SaddleType newType = ModItems.chocoboSaddle.getSaddleType(saddleStack);
        SaddleType oldType = this.getSaddleType();
        if (oldType != newType) {
            this.field_70180_af.func_187227_b(PARAM_SADDLE_ITEM, (Object)saddleStack.func_77946_l());
            this.reconfigureInventory(oldType, newType);
        }
    }

    private void reconfigureInventory(SaddleType oldType, SaddleType newType) {
        if (!this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < this.chocoboInventory.getSlots(); ++i) {
                ItemStack stack = this.chocoboInventory.extractItem(i, Integer.MAX_VALUE, false);
                InventoryHelper.func_180173_a((World)this.func_130014_f_(), (double)this.field_70165_t, (double)(this.field_70163_u + 0.5), (double)this.field_70161_v, (ItemStack)stack);
            }
        }
        this.chocoboInventory.setSize(newType.getInventorySize());
        for (EntityPlayer player : this.field_70170_p.field_73010_i) {
            if (!(player.field_71070_bA instanceof ContainerSaddleBag)) continue;
            ((ContainerSaddleBag)player.field_71070_bA).refreshSlots(this, player);
        }
    }

    public boolean isSaddled() {
        return this.getSaddleType().isRidingSaddle();
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(PARAM_IS_MALE);
    }

    public void setMale(boolean isMale) {
        this.field_70180_af.func_187227_b(PARAM_IS_MALE, (Object)isMale);
    }

    public MovementType getMovementType() {
        return (MovementType)((Object)this.field_70180_af.func_187225_a(PARAM_MOVEMENT_TYPE));
    }

    public void setMovementType(MovementType type) {
        this.field_70180_af.func_187227_b(PARAM_MOVEMENT_TYPE, (Object)type);
    }

    public EntityChocobo(World world) {
        super(world);
        this.func_70105_a(1.3f, 2.3f);
        this.updateStats();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setMale(this.field_70170_p.field_73012_v.nextBoolean());
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, Collections.singleton(ModItems.gysahlGreen)));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    private void updateStats() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_70606_j(this.func_110138_aP());
        this.field_110154_aX = 0.4f;
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.field_110154_aX);
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PARAM_VARIANT, (Object)ChocoboColor.YELLOW);
        this.field_70180_af.func_187214_a(PARAM_IS_MALE, (Object)false);
        this.field_70180_af.func_187214_a(PARAM_MOVEMENT_TYPE, (Object)MovementType.WANDER);
        this.field_70180_af.func_187214_a(PARAM_SADDLE_ITEM, (Object)ItemStack.field_190927_a);
        this.abilityInfo = new ChocoboAbilityInfo(this);
        this.abilityInfo.registerDataParameters();
    }

    public void setColor(ChocoboColor color) {
        this.field_70180_af.func_187227_b(PARAM_VARIANT, (Object)color);
        this.updateStats();
    }

    public ChocoboColor getChocoboColor() {
        return (ChocoboColor)((Object)this.field_70180_af.func_187225_a(PARAM_VARIANT));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return CHOCOBO_LOOTABLE;
    }

    public double func_70042_X() {
        return 1.65;
    }

    public float func_175134_bD() {
        return 0.5f;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.lovelyGysahlGreen;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable entity) {
        EntityChocobo baby = new EntityChocobo(this.func_130014_f_());
        baby.setColor(ChocoboColor.values()[this.field_70146_Z.nextInt(ChocoboColor.values().length)]);
        return baby;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_130014_f_().field_72995_K) {
            return true;
        }
        ItemStack heldItemStack = player.func_184586_b(hand);
        if (this.func_70909_n() && player.func_70093_af()) {
            if (player instanceof EntityPlayerMP) {
                this.displayChocoboInventory((EntityPlayerMP)player);
            }
            return true;
        }
        if (this.isSaddled() && heldItemStack.func_190926_b() && !player.func_70093_af()) {
            player.func_184220_m((Entity)this);
            return true;
        }
        if (!this.func_70909_n() && heldItemStack.func_77973_b() == ModItems.gysahlGreen) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            if ((double)this.field_70170_p.field_73012_v.nextFloat() < ChocoConfig.chocobo.tameChance) {
                this.func_184754_b(player.func_110124_au());
                this.func_70903_f(true);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.tame_success", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.tame_fail", new Object[0]), true);
            }
            return true;
        }
        if (heldItemStack.func_77973_b() == ModItems.chocoboSaddle && this.func_70909_n() && !this.isSaddled()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chococraft.entity_chocobo.saddle_applied", new Object[0]), true);
            this.saddleItemStackHandler.setStackInSlot(0, heldItemStack.func_77946_l().func_77979_a(1));
            this.setSaddleType(heldItemStack);
            this.func_175505_a(player, heldItemStack);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_70909_n();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityPlayer rider = (EntityPlayer)this.func_184179_bs();
        if (rider != null) {
            this.field_70126_B = this.field_70177_z = rider.field_70177_z;
            this.field_70125_A = rider.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = rider.field_70702_br * 0.5f;
            forward = rider.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (rider.field_70703_bu) {
                if (this.abilityInfo.canDive() && this.func_70090_H()) {
                    this.field_70181_x = 0.3;
                } else if (!this.field_70703_bu && this.field_70122_E && !this.abilityInfo.canFly()) {
                    this.field_70181_x += 0.75;
                    this.field_70703_bu = true;
                    this.field_70160_al = true;
                }
            }
            if (this.func_184186_bw()) {
                if (this.abilityInfo.canFly() && rider.field_70703_bu) {
                    double d3 = this.field_70181_x;
                    float f = this.field_70747_aH;
                    this.field_70747_aH = rider.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
                    this.field_70181_x = 0.3;
                    super.func_191986_a(strafe, vertical, forward);
                    this.field_70181_x = d3 * 0.6;
                    this.field_70747_aH = f;
                    this.field_70143_R = 0.0f;
                    this.func_70052_a(7, false);
                } else {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_191986_a(strafe, vertical, forward);
                }
            }
            if (this.field_70122_E) {
                this.field_70703_bu = false;
            }
            if (this.field_70122_E) {
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.field_70165_t - this.field_70169_q;
                double d0 = this.field_70161_v - this.field_70166_s;
                float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
                if (f4 > 1.0f) {
                    f4 = 1.0f;
                }
                this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_184619_aG = 0.0f;
                this.field_70721_aZ = 0.0f;
                this.field_184618_aE = 0.0f;
            }
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70138_W = 1.0f;
        this.field_70143_R = 0.0f;
        if (!(this.field_70122_E || !this.abilityInfo.canGlide() || !(this.field_70181_x < 0.0) || this.func_184207_aI() && this.func_184179_bs().func_70093_af())) {
            this.field_70181_x *= 0.8;
        }
        if (this.func_130014_f_().field_72995_K) {
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.field_70122_E) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            this.wingRotation += this.wingRotDelta * 2.0f;
        }
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return true;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("Color", (byte)this.getChocoboColor().ordinal());
        nbt.func_74757_a("Male", this.isMale());
        nbt.func_74774_a("MovementType", (byte)this.getMovementType().ordinal());
        nbt.func_74782_a("Saddle", (NBTBase)this.saddleItemStackHandler.serializeNBT());
        if (this.getSaddleType() != SaddleType.NONE) {
            nbt.func_74782_a("Inventory", (NBTBase)this.chocoboInventory.serializeNBT());
        }
        nbt.func_74782_a("Stats", (NBTBase)this.abilityInfo.serializeNbt());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setColor(ChocoboColor.values()[nbt.func_74771_c("Color")]);
        this.setMale(nbt.func_74767_n("Male"));
        this.setMovementType(MovementType.values()[nbt.func_74771_c("MovementType")]);
        this.saddleItemStackHandler.deserializeNBT(nbt.func_74775_l("Saddle"));
        if (this.getSaddleType() != SaddleType.NONE) {
            this.chocoboInventory.deserializeNBT(nbt.func_74775_l("Inventory"));
        }
        this.abilityInfo.deserializeNbt(nbt.func_74775_l("Stats"));
    }

    private void displayChocoboInventory(EntityPlayerMP player) {
        player.func_71117_bO();
        player.field_71070_bA = new ContainerSaddleBag(this, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((EntityPlayer)player, player.field_71070_bA));
        PacketManager.INSTANCE.sendTo((IMessage)new PacketOpenChocoboGui(this, player.field_71139_cq), player);
    }
}

