/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.chococraft.common.init;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.xalcon.chococraft.Chococraft;
import net.xalcon.chococraft.common.items.ItemChocoboSaddle;
import net.xalcon.chococraft.common.items.ItemChocoboSpawnEgg;
import net.xalcon.chococraft.common.items.ItemGysahlGreenSeeds;
import net.xalcon.chococraft.utils.inject.ClassInjector;
import net.xalcon.chococraft.utils.inject.InstanceFactoryMethod;
import net.xalcon.chococraft.utils.registration.IItemModelProvider;

@GameRegistry.ObjectHolder(value="chococraft")
@Mod.EventBusSubscriber(modid="chococraft")
public class ModItems {
    @GameRegistry.ObjectHolder(value="chocobo_saddle")
    @ItemSetupParameters(stackSize=4)
    public static ItemChocoboSaddle chocoboSaddle;
    @GameRegistry.ObjectHolder(value="chocobo_spawn_egg")
    public static ItemChocoboSpawnEgg chocoboSpawnEgg;
    @GameRegistry.ObjectHolder(value="gysahl_green_seeds")
    public static ItemGysahlGreenSeeds gysahlGreenSeeds;
    @GameRegistry.ObjectHolder(value="gysahl_green")
    @ItemFoodParameters(amount=1, saturation=1)
    public static ItemFood gysahlGreen;
    @GameRegistry.ObjectHolder(value="lovely_gysahl_green")
    public static Item lovelyGysahlGreen;
    @GameRegistry.ObjectHolder(value="chocobo_drumstick_raw")
    @ItemFoodParameters(amount=2, saturation=2, isWolfFood=true)
    public static ItemFood chocoboDrumStickRaw;
    @GameRegistry.ObjectHolder(value="chocobo_drumstick_cooked")
    @ItemFoodParameters(amount=6, saturation=8, isWolfFood=true)
    public static ItemFood chocoboDrumStickCooked;

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Field field : ModItems.class.getDeclaredFields()) {
            GameRegistry.ObjectHolder objHolder;
            if (!Item.class.isAssignableFrom(field.getType()) || (objHolder = field.getAnnotation(GameRegistry.ObjectHolder.class)) == null) continue;
            Item item = (Item)ClassInjector.createFromField(field);
            String internalName = objHolder.value();
            item.setRegistryName(internalName);
            item.func_77655_b("chococraft." + internalName);
            item.func_77637_a(Chococraft.creativeTab);
            ItemSetupParameters parameters = field.getAnnotation(ItemSetupParameters.class);
            if (parameters != null) {
                ModItems.applyParameters(item, parameters);
            }
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    public static void onRegisterModels(ModelRegistryEvent event) {
        for (Field field : ModItems.class.getDeclaredFields()) {
            if (!Item.class.isAssignableFrom(field.getType())) continue;
            Item item = (Item)ClassInjector.getOrNull(field);
            if (item instanceof IItemModelProvider) {
                ((IItemModelProvider)item).registerItemModel(item);
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @InstanceFactoryMethod
    public static ItemFood createItemFood(ItemFoodParameters parameters) {
        return new ItemFood(parameters.amount(), (float)parameters.saturation(), parameters.isWolfFood());
    }

    private static void applyParameters(Item item, ItemSetupParameters parameters) {
        item.func_77625_d(parameters.stackSize());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface ItemSetupParameters {
        public int stackSize() default 64;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    private static @interface ItemFoodParameters {
        public int amount();

        public int saturation();

        public boolean isWolfFood() default false;
    }
}

