/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.chococraft2.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import uk.co.haxyshideout.chococraft2.config.Additions;
import uk.co.haxyshideout.haxylib.blocks.GenericBush;

public class GysahlStemBlock
extends GenericBush
implements IGrowable {
    public static final Integer MAXSTAGE = 4;
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)MAXSTAGE);

    public GysahlStemBlock() {
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.func_149672_a(field_149779_h);
        this.func_149711_c(0.0f);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Additions.gysahlSeedsItem);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        super.func_180650_b(worldIn, pos, state, rand);
        this.growStem(worldIn, rand, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (state.func_177229_b((IProperty)STAGE) == MAXSTAGE) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            ret.add(this.getGysahlItem(rand));
            int seedAmount = 3 + fortune;
            for (int i = 0; i < seedAmount; ++i) {
                if (rand.nextInt(15) >= 7) continue;
                ret.add(new ItemStack(Additions.gysahlSeedsItem));
            }
        }
        return ret;
    }

    private ItemStack getGysahlItem(Random random) {
        int chance = random.nextInt(200);
        Item item = chance < 10 ? Additions.gysahlGoldenItem : (chance < 30 ? Additions.gysahlLoverlyItem : Additions.gysahlGreenItem);
        return new ItemStack(item);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        super.func_180650_b(worldIn, pos, state, rand);
        this.growStem(worldIn, rand, pos, state);
    }

    private void growStem(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        float growthChance;
        if (worldIn.func_175671_l(pos) >= 9 && (Integer)state.func_177229_b((IProperty)STAGE) < MAXSTAGE && rand.nextInt((int)(25.0f / (growthChance = this.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 2);
        }
    }

    public void setGrowthStage(World world, BlockPos pos, IBlockState state) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)), 2);
    }

    public float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockUnder = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockUnder.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant((IBlockAccess)worldIn, blockUnder.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockUnder.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockNorth = pos.func_177978_c();
        BlockPos blockSouth = pos.func_177968_d();
        BlockPos blockWest = pos.func_177976_e();
        BlockPos blockEast = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockWest).func_177230_c() || blockIn == worldIn.func_180495_p(blockEast).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockNorth).func_177230_c() || blockIn == worldIn.func_180495_p(blockSouth).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockWest.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockEast.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockEast.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockWest.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{STAGE});
    }
}

