/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.chococraft2.client.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import uk.co.haxyshideout.chococraft2.entities.EntityChocobo;
import uk.co.haxyshideout.chococraft2.network.PacketRegistry;
import uk.co.haxyshideout.chococraft2.network.side.server.ChocopediaEditPacket;
import uk.co.haxyshideout.chococraft2.network.side.server.DropGearPacket;

public class ChocopediaGui
extends GuiScreen {
    public EntityChocobo chocobo;
    GuiButton renameButton;
    GuiButton followOwnerButton;
    GuiButton changeOwnerButton;
    GuiButton applyButton;
    GuiButton dropGearButton;
    GuiTextField inputTextField;
    public String owner;
    public String name;
    public EntityChocobo.MovementType movementType;
    InputType currentInputType = InputType.none;

    public ChocopediaGui(EntityChocobo chocobo) {
        this.chocobo = chocobo;
        this.owner = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        this.name = chocobo.func_95999_t();
        this.movementType = chocobo.getMovementType();
    }

    public void func_73866_w_() {
        int componentID = 0;
        int yPos = 24;
        int xPos = this.field_146294_l / 2 - 100;
        this.renameButton = new GuiButton(componentID++, xPos, yPos += 24, 90, 20, "Rename");
        this.followOwnerButton = new GuiButton(componentID++, xPos, yPos += 24, 90, 20, "Follow");
        this.changeOwnerButton = new GuiButton(componentID++, xPos, yPos += 24, 90, 20, "Change Owner");
        this.applyButton = new GuiButton(componentID++, xPos, yPos += 24, 90, 20, "Apply Changes");
        this.dropGearButton = new GuiButton(componentID++, xPos, yPos += 48, 90, 20, "Drop Gear");
        this.inputTextField = new GuiTextField(componentID++, this.field_146289_q, xPos, 24, 100, 20);
        this.inputTextField.func_146189_e(false);
        this.updateMovementButton();
        this.field_146292_n.add(this.renameButton);
        this.field_146292_n.add(this.followOwnerButton);
        this.field_146292_n.add(this.changeOwnerButton);
        this.field_146292_n.add(this.applyButton);
        this.field_146292_n.add(this.dropGearButton);
    }

    public void func_73876_c() {
        if (this.chocobo.field_70128_L) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int yPos = 30;
        int xPos = this.field_146294_l / 2;
        this.func_73731_b(this.field_146289_q, "Name: " + this.name, xPos, yPos += 24, -8355712);
        this.func_73731_b(this.field_146289_q, "Owner: " + this.owner, xPos, yPos += 12, -8355712);
        this.func_73731_b(this.field_146289_q, "Health: " + this.chocobo.func_110143_aJ() + "/" + this.chocobo.func_110138_aP(), xPos, yPos += 12, -8355712);
        this.func_73731_b(this.field_146289_q, "Sex: " + (this.chocobo.isMale() ? "Male" : "Female"), xPos, yPos += 12, -8355712);
        if (this.inputTextField.func_146176_q()) {
            this.inputTextField.func_146194_f();
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.inputTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.inputTextField.func_146201_a(typedChar, keyCode);
        if (keyCode == 28 && this.currentInputType != InputType.none) {
            if (this.currentInputType == InputType.name) {
                this.name = this.inputTextField.func_146179_b();
            } else if (this.currentInputType == InputType.owner) {
                this.owner = this.inputTextField.func_146179_b();
            }
            this.closeInputBox();
        }
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (this.currentInputType != InputType.none) {
            return;
        }
        if (button == this.renameButton) {
            this.displayInputBox(InputType.name);
        }
        if (button == this.followOwnerButton) {
            this.changeMovementType();
        }
        if (button == this.changeOwnerButton) {
            this.displayInputBox(InputType.owner);
        }
        if (button == this.applyButton) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new ChocopediaEditPacket(this));
            this.field_146297_k.func_147108_a(null);
        }
        if (button == this.dropGearButton) {
            PacketRegistry.INSTANCE.sendToServer((IMessage)new DropGearPacket(this.chocobo));
            this.field_146297_k.func_147108_a(null);
        }
    }

    private void changeMovementType() {
        switch (this.movementType) {
            case STANDSTILL: {
                this.movementType = EntityChocobo.MovementType.FOLLOW_OWNER;
                break;
            }
            case FOLLOW_OWNER: {
                this.movementType = EntityChocobo.MovementType.WANDER;
                break;
            }
            case WANDER: {
                this.movementType = EntityChocobo.MovementType.STANDSTILL;
            }
        }
        this.updateMovementButton();
    }

    private void updateMovementButton() {
        switch (this.movementType) {
            case STANDSTILL: {
                this.followOwnerButton.field_146126_j = "Stand Still";
                break;
            }
            case FOLLOW_OWNER: {
                this.followOwnerButton.field_146126_j = "Follow Owner";
                break;
            }
            case WANDER: {
                this.followOwnerButton.field_146126_j = "Wander";
                break;
            }
            default: {
                this.followOwnerButton.field_146126_j = "ERROR";
            }
        }
    }

    private void displayInputBox(InputType name) {
        this.currentInputType = name;
        this.inputTextField.func_146180_a("");
        this.inputTextField.func_146189_e(true);
        this.inputTextField.func_146205_d(false);
        this.inputTextField.func_146195_b(true);
    }

    private void closeInputBox() {
        this.currentInputType = InputType.none;
        this.inputTextField.func_146189_e(false);
        this.inputTextField.func_146205_d(true);
        this.inputTextField.func_146195_b(false);
    }

    public boolean func_73868_f() {
        return false;
    }

    static enum InputType {
        none,
        name,
        owner;

    }
}

