/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.chococraft2.entities;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.lwjgl.input.Keyboard;
import uk.co.haxyshideout.chococraft2.ChocoCraft2;
import uk.co.haxyshideout.chococraft2.config.Additions;
import uk.co.haxyshideout.chococraft2.entities.ChocoboAbilityInfo;
import uk.co.haxyshideout.chococraft2.entities.DefaultNames;
import uk.co.haxyshideout.chococraft2.entities.EntityBabyChocobo;
import uk.co.haxyshideout.chococraft2.entities.RiderState;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIAvoidPlayer;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIFollowLure;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIFollowOwner;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIHealInPen;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIMate;
import uk.co.haxyshideout.chococraft2.entities.ai.ChocoboAIWatchPlayer;
import uk.co.haxyshideout.chococraft2.entities.breeding.Breeding;
import uk.co.haxyshideout.haxylib.utils.InventoryHelper;
import uk.co.haxyshideout.haxylib.utils.RandomHelper;
import uk.co.haxyshideout.haxylib.utils.WorldHelper;

public class EntityChocobo
extends EntityTameable
implements IInvBasic {
    public float wingRotation;
    public float destPos;
    private float wingRotDelta;
    private EntityPlayerMP entityLuring = null;
    private ChocoboAIAvoidPlayer chocoboAIAvoidPlayer;
    private ChocoboAIHealInPen chocoboAIHealInPen;
    private AnimalChest chocoboChest;
    private int ticksUntilNextFeatherDrop;
    private final RiderState riderState;
    public boolean fedGoldenGyshal = false;

    public EntityChocobo(World world) {
        super(world);
        this.func_70105_a(1.3f, 2.3f);
        this.setMale(world.field_73012_v.nextBoolean());
        this.func_96094_a(DefaultNames.getRandomName(this.isMale()));
        this.resetFeatherDropTime();
        this.riderState = new RiderState();
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ChocoboAIFollowOwner(this, 1.0, 5.0f, 5.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ChocoboAIFollowLure(this, 1.0, 5.0f, 5.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new ChocoboAIWatchPlayer((EntityLiving)this, EntityPlayer.class, 5.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ChocoboAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.initChest();
        if (!world.field_72995_K) {
            if (WorldHelper.isHellWorld(world)) {
                this.setColor(ChocoboColor.PURPLE);
            } else {
                this.setColor(ChocoboColor.YELLOW);
            }
        }
        this.field_70178_ae = this.getAbilityInfo().isImmuneToFire();
    }

    public void func_70078_a(Entity entityIn) {
        super.func_70078_a(entityIn);
        if (this.field_70170_p.field_72995_K && Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(entityIn.func_110124_au())) {
            Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
        }
    }

    public void setStats() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getAbilityInfo().getMaxHP());
        this.func_70606_j(this.func_110138_aP());
        this.field_110154_aX = this.getAbilityInfo().getLandSpeed() / 100.0f;
    }

    public RiderState getRiderState() {
        return this.riderState;
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase) {
            this.field_70126_B = this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70125_A = this.field_70153_n.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = ((EntityLivingBase)this.field_70153_n).field_70702_br * 0.5f;
            forward = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            if (this.func_70090_H() && this.getAbilityInfo().canWalkOnWater()) {
                this.field_70181_x = 0.4;
                this.func_70060_a(strafe, forward, 100.0f / this.getAbilityInfo().getWaterSpeed());
                this.func_70637_d(true);
            }
            if (this.riderState.isJumping() && this.getAbilityInfo().getCanFly()) {
                this.field_70703_bu = true;
                this.func_70664_aZ();
                this.func_70060_a(strafe, forward, 100.0f / this.getAbilityInfo().getAirbornSpeed());
            } else if (this.riderState.isJumping() && !this.field_70703_bu && this.field_70122_E) {
                this.field_70181_x += 0.75;
                this.riderState.setJumping(false);
                this.field_70703_bu = true;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_70612_e(strafe, forward);
            }
            this.field_70722_aY = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
            this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
            this.field_70754_ba += this.field_70721_aZ;
        } else {
            super.func_70612_e(strafe, forward);
        }
    }

    public void func_175544_ck() {
        if (this.chocoboAIAvoidPlayer == null) {
            this.chocoboAIAvoidPlayer = new ChocoboAIAvoidPlayer((EntityCreature)this, 10.0f, 1.0, 1.2);
        }
        if (this.chocoboAIHealInPen == null) {
            this.chocoboAIHealInPen = new ChocoboAIHealInPen(this);
        }
        this.field_70714_bg.func_85156_a((EntityAIBase)this.chocoboAIAvoidPlayer);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.chocoboAIHealInPen);
        if (this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.chocoboAIHealInPen);
        } else {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.chocoboAIAvoidPlayer);
        }
    }

    public boolean func_70877_b(ItemStack itemStack) {
        return itemStack.func_77973_b() == Additions.gysahlLoverlyItem || itemStack.func_77973_b() == Additions.gysahlGoldenItem;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.getAbilityInfo().canClimb()) {
            this.field_70138_W = 1.0f;
        }
        this.field_70143_R = 0.0f;
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70153_n != null && this.field_70153_n instanceof EntityPlayer) {
                if (Minecraft.func_71410_x().field_71439_g.func_110124_au().equals(this.field_70153_n.func_110124_au()) && Keyboard.isKeyDown((int)57)) {
                    this.riderState.setJumping(true);
                }
                ChocoCraft2.proxy.updateRiderState((EntityPlayer)this.field_70153_n);
            }
            this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
            this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
            if (!this.field_70122_E) {
                this.wingRotDelta = Math.min(this.wingRotation, 1.0f);
            }
            this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
            if (!this.field_70122_E && this.field_70181_x < 0.0) {
                this.field_70181_x *= 0.8;
            }
            this.wingRotation += this.wingRotDelta * 2.0f;
            return;
        }
        if (--this.ticksUntilNextFeatherDrop <= 0) {
            if (RandomHelper.getChanceResult(ChocoCraft2.instance.getConfig().getChangeForFeather())) {
                this.func_70099_a(new ItemStack(Additions.chocoboFeatherItem), 0.0f);
            }
            this.resetFeatherDropTime();
        }
        if (this.field_70153_n != null) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_70153_n.field_70177_z;
            this.field_70126_B = this.field_70153_n.field_70177_z;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void resetFeatherDropTime() {
        this.ticksUntilNextFeatherDrop = this.field_70146_Z.nextInt(ChocoCraft2.instance.getConfig().getTicksUntilNextFeather());
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74774_a("Color", (byte)this.getChocoboColor().ordinal());
        tagCompound.func_74774_a("BagType", (byte)this.getBagType().ordinal());
        tagCompound.func_74757_a("Saddled", this.isSaddled());
        tagCompound.func_74757_a("Male", this.isMale());
        tagCompound.func_74774_a("MovementType", (byte)this.getMovementType().ordinal());
        if (this.getBagType() != BagType.NONE) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.chocoboChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.chocoboChest.func_70301_a(i);
                if (itemstack == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            tagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        this.setColor(ChocoboColor.values()[tagCompound.func_74771_c("Color")]);
        this.setBag(BagType.values()[tagCompound.func_74771_c("BagType")]);
        this.setSaddled(tagCompound.func_74767_n("Saddled"));
        this.setMale(tagCompound.func_74767_n("Male"));
        this.setMovementType(MovementType.values()[tagCompound.func_74771_c("MovementType")]);
        if (this.getBagType() != BagType.NONE) {
            NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
            this.initChest();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.chocoboChest.func_70302_i_()) continue;
                this.chocoboChest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(31, (Object)0);
        this.field_70180_af.func_75682_a(30, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    public void setColor(ChocoboColor color) {
        this.field_70180_af.func_75692_b(31, (Object)((byte)color.ordinal()));
        this.setStats();
    }

    public ChocoboColor getChocoboColor() {
        return ChocoboColor.values()[this.field_70180_af.func_75683_a(31)];
    }

    public void setBag(BagType bag) {
        this.field_70180_af.func_75692_b(30, (Object)((byte)bag.ordinal()));
        this.initChest();
    }

    public BagType getBagType() {
        return BagType.values()[this.field_70180_af.func_75683_a(30)];
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_75692_b(29, (Object)((byte)(saddled ? 1 : 0)));
    }

    public boolean isSaddled() {
        return this.field_70180_af.func_75683_a(29) == 1;
    }

    public void setMale(boolean isMale) {
        this.field_70180_af.func_75692_b(28, (Object)((byte)(isMale ? 1 : 0)));
    }

    public boolean isMale() {
        return this.field_70180_af.func_75683_a(28) == 1;
    }

    public void setMovementType(MovementType movementType) {
        this.field_70180_af.func_75692_b(27, (Object)((byte)movementType.ordinal()));
    }

    public MovementType getMovementType() {
        return MovementType.values()[this.field_70180_af.func_75683_a(27)];
    }

    public EntityAgeable func_90011_a(EntityAgeable otherParent) {
        EntityBabyChocobo entity = new EntityBabyChocobo(otherParent.field_70170_p);
        entity.setColor(Breeding.getColour(this, (EntityChocobo)otherParent));
        this.fedGoldenGyshal = false;
        ((EntityChocobo)otherParent).fedGoldenGyshal = false;
        return entity;
    }

    protected String func_70673_aS() {
        return "chococraft2:choco_kweh";
    }

    protected String func_70621_aR() {
        return "chococraft2:choco_kweh";
    }

    protected String func_70639_aQ() {
        if (this.field_70146_Z.nextInt(4) == 0) {
            return "chococraft2:choco_kweh";
        }
        return null;
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
        ((WorldServer)this.field_70170_p).func_180505_a(EnumParticleTypes.HEART, false, this.field_70165_t, this.field_70163_u + 2.5, this.field_70161_v, 3, 0.3, 0.0, 0.3, 1.0, new int[0]);
    }

    public double func_70042_X() {
        return 1.65;
    }

    public boolean shouldRiderFaceForward(EntityPlayer player) {
        return true;
    }

    public int func_70627_aG() {
        return 150;
    }

    public boolean func_94059_bO() {
        return this.func_70909_n() && this.field_70153_n == null;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Additions.chocopediaItem && this.func_70909_n() && this.func_70902_q() == player) {
            ChocoCraft2.proxy.openChocopedia(this);
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (player.func_70694_bm() == null && this.isSaddled() && !player.func_70093_af()) {
            player.func_70078_a((Entity)this);
            return true;
        }
        if (player.func_70093_af() && this.getBagType() != BagType.NONE) {
            player.func_71007_a((IInventory)this.chocoboChest);
        }
        if (player.func_70694_bm() == null) {
            return false;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.gysahlGreenItem) {
            if (!this.func_70909_n()) {
                this.func_175505_a(player, player.field_71071_by.func_70448_g());
                player.func_146105_b((IChatComponent)new ChatComponentText("You attempt to tame the wild Chocobo"));
                if (RandomHelper.getChanceResult(10)) {
                    this.func_152115_b(player.func_110124_au().toString());
                    this.func_70903_f(true);
                    InventoryHelper.giveIfMissing(new ItemStack(Additions.chocopediaItem), (EntityPlayerMP)player);
                    player.func_146105_b((IChatComponent)new ChatComponentText("You tamed the Chocobo!"));
                }
            } else if (this.func_70909_n()) {
                if (this.func_110143_aJ() != this.func_110138_aP()) {
                    this.func_175505_a(player, player.field_71071_by.func_70448_g());
                    this.func_70691_i(RandomHelper.getRandomInt(5));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("This Chocobo is already at full health!"));
                }
            }
            return true;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.chocoboFeatherItem) {
            if (this.getMovementType() == MovementType.FOLLOW_LURE && this.entityLuring != null && this.entityLuring == player) {
                this.setMovementType(MovementType.STANDSTILL);
                this.entityLuring = null;
                return true;
            }
            if (this.func_70909_n() && this.func_152113_b().equals(player.func_110124_au().toString()) || !this.func_70909_n()) {
                this.setMovementType(MovementType.FOLLOW_LURE);
                this.entityLuring = (EntityPlayerMP)player;
            }
            return true;
        }
        if (!this.func_70909_n() || this.func_70902_q() != player) {
            return false;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.gysahlGoldenItem) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.fedGoldenGyshal = true;
            this.func_146082_f(player);
        } else if (player.func_70694_bm().func_77973_b() == Additions.gysahlLoverlyItem) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.func_146082_f(player);
        }
        if (player.func_70694_bm().func_77973_b() == Additions.chocoboSaddleItem && !this.isSaddled()) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            player.func_146105_b((IChatComponent)new ChatComponentText("You put saddle on Chocobo"));
            this.setSaddled(true);
            return true;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.chocoboSaddleBagItem && this.getBagType() == BagType.NONE && this.isSaddled()) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.setBag(BagType.SADDLE);
            return true;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.chocoboPackBagItem && this.getBagType() == BagType.NONE) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.setBag(BagType.PACK);
            return true;
        }
        if (player.func_70694_bm().func_77973_b() == Additions.gysahlRedItem) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.setColor(ChocoboColor.RED);
        }
        if (player.func_70694_bm().func_77973_b() == Additions.gysahlPinkItem) {
            this.func_175505_a(player, player.field_71071_by.func_70448_g());
            this.setColor(ChocoboColor.PINK);
        }
        if (player.func_70694_bm().func_77973_b() == Additions.chocoboWhistleItem) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("LinkedChocoboUUID", this.func_110124_au().toString());
            player.func_70694_bm().func_77982_d(tagCompound);
            player.func_70694_bm().func_151001_c(this.func_70005_c_() + "'s Whistle");
            player.func_146105_b((IChatComponent)new ChatComponentText("You linked the whistle to " + this.func_70005_c_()));
        }
        return false;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal.getClass() == ((Object)((Object)this)).getClass() && this.func_70880_s() && otherAnimal.func_70880_s() && ((EntityChocobo)otherAnimal).isMale() != this.isMale();
    }

    public float func_175134_bD() {
        return 0.5f;
    }

    public EntityPlayerMP getEntityLuring() {
        return this.entityLuring;
    }

    protected boolean func_70610_aX() {
        return this.getMovementType() == MovementType.STANDSTILL && this.field_70153_n == null;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.dropGear(null);
        for (int i = 0; i < this.field_70146_Z.nextInt(3); ++i) {
            this.func_70099_a(new ItemStack(Additions.chocoboFeatherItem), 0.0f);
        }
    }

    public void initChest() {
        AnimalChest animalChest = this.chocoboChest;
        this.chocoboChest = new AnimalChest("ChocoboChest", this.getChestSize());
        this.chocoboChest.func_110133_a(this.func_95999_t());
        if (animalChest != null) {
            animalChest.func_110132_b((IInvBasic)this);
            int i = Math.min(animalChest.func_70302_i_(), this.chocoboChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = animalChest.func_70301_a(j);
                if (itemstack == null) continue;
                this.chocoboChest.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.chocoboChest.func_110134_a((IInvBasic)this);
    }

    public int getChestSize() {
        if (this.getBagType() == BagType.NONE) {
            return 0;
        }
        if (this.getBagType() == BagType.PACK) {
            return 54;
        }
        if (this.getBagType() == BagType.SADDLE) {
            return 27;
        }
        return 0;
    }

    public void func_76316_a(InventoryBasic inventoryBasic) {
    }

    public void dropGear(@Nullable EntityPlayerMP player) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.chocoboChest != null) {
            for (int slot = 0; slot < this.chocoboChest.func_70302_i_(); ++slot) {
                ItemStack itemStack = this.chocoboChest.func_70301_a(slot);
                if (itemStack == null) continue;
                if (player != null) {
                    InventoryHelper.giveOrDropStack(itemStack, player);
                    continue;
                }
                this.func_70099_a(itemStack, 0.0f);
            }
        }
        if (this.isSaddled()) {
            this.setSaddled(false);
            if (player != null) {
                InventoryHelper.giveOrDropStack(new ItemStack(Additions.chocoboSaddleItem), player);
            } else {
                this.func_70099_a(new ItemStack(Additions.chocoboSaddleItem), 0.0f);
            }
        }
        if (this.getBagType() == BagType.SADDLE) {
            this.setBag(BagType.NONE);
            if (player != null) {
                InventoryHelper.giveOrDropStack(new ItemStack(Additions.chocoboSaddleBagItem), player);
            } else {
                this.func_70099_a(new ItemStack(Additions.chocoboSaddleBagItem), 0.0f);
            }
        }
        if (this.getBagType() == BagType.PACK) {
            this.setBag(BagType.NONE);
            if (player != null) {
                InventoryHelper.giveOrDropStack(new ItemStack(Additions.chocoboPackBagItem), player);
            } else {
                this.func_70099_a(new ItemStack(Additions.chocoboPackBagItem), 0.0f);
            }
        }
    }

    public ChocoboAbilityInfo getAbilityInfo() {
        return ChocoboAbilityInfo.getAbilityInfo(this.getChocoboColor());
    }

    public static enum MovementType {
        WANDER,
        FOLLOW_OWNER,
        STANDSTILL,
        FOLLOW_LURE;

    }

    public static enum BagType {
        NONE,
        SADDLE,
        PACK;

    }

    public static enum ChocoboColor {
        YELLOW,
        GREEN,
        BLUE,
        WHITE,
        BLACK,
        GOLD,
        PINK,
        RED,
        PURPLE;

    }
}

