/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.shaded.ninja.leaping.configurate.hocon;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.ConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.ConfigurationOptions;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader.CommentHandler;
import uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader.CommentHandlers;

public class HoconConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    public static final Pattern CRLF_MATCH = Pattern.compile("\r\n?");
    private final ConfigRenderOptions render;
    private final ConfigParseOptions parse;
    private static final Class<? extends ConfigValue> VALUE_CLASS;
    private static final Class<? extends ConfigOrigin> ORIGIN_CLASS;
    private static final Field VALUE_ORIGIN;
    private static final Method ORIGIN_SET_COMMENTS;

    public static Builder builder() {
        return new Builder();
    }

    private HoconConfigurationLoader(CharSource source, CharSink sink, ConfigRenderOptions render, ConfigParseOptions parse, boolean preservesHeader) {
        super(source, sink, new CommentHandler[]{CommentHandlers.HASH, CommentHandlers.DOUBLE_SLASH}, preservesHeader);
        this.render = render;
        this.parse = parse;
    }

    @Override
    public void loadInternal(CommentedConfigurationNode node, BufferedReader reader) throws IOException {
        Config hoconConfig = ConfigFactory.parseReader(reader, this.parse);
        for (Map.Entry ent : hoconConfig.root().entrySet()) {
            this.readConfigValue((ConfigValue)ent.getValue(), node.getNode(ent.getKey()));
        }
    }

    private void readConfigValue(ConfigValue value, CommentedConfigurationNode node) {
        if (!value.origin().comments().isEmpty()) {
            node.setComment(CRLF_MATCH.matcher(Joiner.on('\n').join(value.origin().comments())).replaceAll("\n"));
        }
        switch (value.valueType()) {
            case OBJECT: {
                if (((ConfigObject)value).isEmpty()) {
                    node.setValue(ImmutableMap.of());
                    break;
                }
                for (Map.Entry ent : ((ConfigObject)value).entrySet()) {
                    this.readConfigValue((ConfigValue)ent.getValue(), node.getNode(ent.getKey()));
                }
                break;
            }
            case LIST: {
                ConfigList values = (ConfigList)value;
                for (int i = 0; i < values.size(); ++i) {
                    this.readConfigValue((ConfigValue)values.get(i), node.getNode(i));
                }
                break;
            }
            case NULL: {
                return;
            }
            default: {
                node.setValue(value.unwrapped());
            }
        }
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        if (!node.hasMapChildren()) {
            if (node.getValue() == null) {
                writer.write(LINE_SEPARATOR);
                return;
            }
            throw new IOException("HOCON cannot write nodes not in map format!");
        }
        ConfigValue value = ConfigValueFactory.fromAnyRef(node.getValue(), "configurate-hocon");
        this.traverseForComments(value, node);
        String renderedValue = value.render(this.render);
        writer.write(renderedValue);
    }

    @Override
    public CommentedConfigurationNode createEmptyNode(ConfigurationOptions options) {
        options = options.setAcceptedTypes(ImmutableSet.of(Map.class, List.class, Double.class, Long.class, Integer.class, Boolean.class, new Class[]{String.class, Number.class}));
        return SimpleCommentedConfigurationNode.root(options);
    }

    private void traverseForComments(ConfigValue value, ConfigurationNode node) throws IOException {
        this.potentialComment(value, node);
        switch (value.valueType()) {
            case OBJECT: {
                for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
                    ConfigValue child = ((ConfigObject)value).get(ent.getKey().toString());
                    if (child == null) continue;
                    this.traverseForComments(child, ent.getValue());
                }
                break;
            }
            case LIST: {
                List<? extends ConfigurationNode> nodes = node.getChildrenList();
                for (int i = 0; i < nodes.size(); ++i) {
                    this.traverseForComments((ConfigValue)((ConfigList)value).get(i), nodes.get(i));
                }
                break;
            }
        }
    }

    private ConfigValue potentialComment(ConfigValue value, ConfigurationNode node) throws IOException {
        if (!(node instanceof CommentedConfigurationNode)) {
            return value;
        }
        CommentedConfigurationNode commentedNode = (CommentedConfigurationNode)node;
        Optional<String> comment = commentedNode.getComment();
        if (!comment.isPresent()) {
            return value;
        }
        try {
            Object o = ORIGIN_SET_COMMENTS.invoke((Object)value.origin(), ImmutableList.copyOf(LINE_SPLITTER.split(comment.get())));
            VALUE_ORIGIN.set(value, o);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Unable to set comments for config value" + value);
        }
        catch (InvocationTargetException e) {
            throw new IOException("Unable to set comments for config value" + value);
        }
        return value;
    }

    static {
        try {
            VALUE_CLASS = Class.forName("com.typesafe.config.impl.AbstractConfigValue").asSubclass(ConfigValue.class);
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        ORIGIN_CLASS = ConfigValueFactory.fromAnyRef("a").origin().getClass();
        try {
            VALUE_ORIGIN = VALUE_CLASS.getDeclaredField("origin");
            ORIGIN_SET_COMMENTS = ORIGIN_CLASS.getDeclaredMethod("setComments", List.class);
            VALUE_ORIGIN.setAccessible(true);
            ORIGIN_SET_COMMENTS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private ConfigRenderOptions render = ConfigRenderOptions.defaults().setOriginComments(false).setJson(false);
        private ConfigParseOptions parse = ConfigParseOptions.defaults();

        protected Builder() {
        }

        public ConfigRenderOptions getRenderOptions() {
            return this.render;
        }

        public ConfigParseOptions getParseOptions() {
            return this.parse;
        }

        public Builder setRenderOptions(ConfigRenderOptions options) {
            this.render = options;
            return this;
        }

        public Builder setParseOptions(ConfigParseOptions options) {
            this.parse = options;
            return this;
        }

        @Override
        public HoconConfigurationLoader build() {
            return new HoconConfigurationLoader(this.source, this.sink, this.render, this.parse, this.preserveHeader);
        }
    }
}

