/*
 * Decompiled with CFR 0.152.
 */
package uk.co.haxyshideout.shaded.ninja.leaping.configurate.loader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class AtomicFileOutputStream
extends FilterOutputStream {
    private static final boolean NIO_PATH_SUPPORTED;
    private final File targetFile;
    private final File writeFile;
    private final File oldFile;

    public AtomicFileOutputStream(File file) throws IOException {
        super(null);
        this.writeFile = File.createTempFile(file.getPath().replaceAll("\\\\|/|:", "-"), null, file.getCanonicalFile().getParentFile());
        this.targetFile = file;
        this.oldFile = new File(this.targetFile.getName() + ".old");
        this.out = new FileOutputStream(this.writeFile);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (NIO_PATH_SUPPORTED) {
            this.handleMoveJava7();
        } else {
            this.handleMoveJava6();
        }
    }

    private void handleMoveJava6() throws IOException {
        if (!this.writeFile.renameTo(this.targetFile)) {
            this.oldFile.delete();
            if (!this.targetFile.exists() || this.targetFile.renameTo(this.oldFile)) {
                if (!this.writeFile.renameTo(this.targetFile)) {
                    throw new IOException("Unable to overwrite file with temporary file! New file is at " + this.writeFile + ", old config at " + this.oldFile + ", target at " + this.targetFile);
                }
                if (!this.oldFile.delete()) {
                    throw new IOException("Unable to delete old file " + this.oldFile);
                }
            }
        }
    }

    @IgnoreJRERequirement
    private void handleMoveJava7() throws IOException {
        Path writePath = this.writeFile.toPath();
        Path targetPath = this.targetFile.toPath();
        Files.move(writePath, targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    static {
        boolean pathSupported;
        try {
            Class.forName("java.nio.file.Path");
            pathSupported = true;
        }
        catch (ClassNotFoundException e) {
            pathSupported = false;
        }
        NIO_PATH_SUPPORTED = pathSupported;
    }
}

