/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.io.File;
import javax.swing.JFileChooser;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;

class DirPreferences {
    private LuytenPreferences luytenPrefs;

    public DirPreferences(LuytenPreferences luytenPrefs) {
        this.luytenPrefs = luytenPrefs;
    }

    void retrieveOpenDialogDir(JFileChooser fc) {
        try {
            File currentDir;
            String currentDirStr = this.luytenPrefs.getFileOpenCurrentDirectory();
            if (currentDirStr != null && currentDirStr.trim().length() > 0 && (currentDir = new File(currentDirStr)).exists() && currentDir.isDirectory()) {
                fc.setCurrentDirectory(currentDir);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    void saveOpenDialogDir(JFileChooser fc) {
        try {
            File currentDir = fc.getCurrentDirectory();
            if (currentDir != null && currentDir.exists() && currentDir.isDirectory()) {
                this.luytenPrefs.setFileOpenCurrentDirectory(currentDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    void retrieveSaveDialogDir(JFileChooser fc) {
        try {
            File currentDir;
            String currentDirStr = this.luytenPrefs.getFileSaveCurrentDirectory();
            if (currentDirStr != null && currentDirStr.trim().length() > 0 && (currentDir = new File(currentDirStr)).exists() && currentDir.isDirectory()) {
                fc.setCurrentDirectory(currentDir);
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }

    void saveSaveDialogDir(JFileChooser fc) {
        try {
            File currentDir = fc.getCurrentDirectory();
            if (currentDir != null && currentDir.exists() && currentDir.isDirectory()) {
                this.luytenPrefs.setFileSaveCurrentDirectory(currentDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Luyten.showExceptionDialog("Exception!", e);
        }
    }
}

