/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.MainWindow;

public class DropListener
implements DropTargetListener {
    private MainWindow mainWindow;

    public DropListener(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        event.acceptDrop(1);
        Transferable transferable = event.getTransferable();
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            DataFlavor[] flavors;
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                try {
                    if (!flavor.isFlavorJavaFileListType()) continue;
                    List files = (List)transferable.getTransferData(flavor);
                    if (files.size() > 1) {
                        event.rejectDrop();
                        return;
                    }
                    if (files.size() != 1) continue;
                    this.mainWindow.onFileDropped((File)files.get(0));
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
            event.dropComplete(true);
        } else {
            DataFlavor[] flavors = transferable.getTransferDataFlavors();
            boolean handled = false;
            for (int zz = 0; zz < flavors.length; ++zz) {
                if (!flavors[zz].isRepresentationClassReader()) continue;
                try {
                    Reader reader = flavors[zz].getReaderForText(transferable);
                    BufferedReader br = new BufferedReader(reader);
                    ArrayList<File> list = new ArrayList<File>();
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        try {
                            if (new String("\u0000").equals(line)) continue;
                            File file = new File(new URI(line));
                            list.add(file);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (list.size() > 1) {
                        event.rejectDrop();
                        return;
                    }
                    if (list.size() == 1) {
                        this.mainWindow.onFileDropped((File)list.get(0));
                    }
                    event.getDropTargetContext().dropComplete(true);
                    handled = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            if (!handled) {
                event.rejectDrop();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent arg0) {
    }

    @Override
    public void dragExit(DropTargetEvent arg0) {
    }

    @Override
    public void dragOver(DropTargetDragEvent arg0) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent arg0) {
    }
}

