/*
 * Decompiled with CFR 0.152.
 */
package us.deathmarine.luyten;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import us.deathmarine.luyten.ConfigSaver;
import us.deathmarine.luyten.DirPreferences;
import us.deathmarine.luyten.Luyten;
import us.deathmarine.luyten.LuytenPreferences;

public class FileDialog {
    private final DirPreferences dirPreferences;
    private ConfigSaver configSaver;
    private Component parent;
    private JFileChooser fcOpen;
    private JFileChooser fcSave;
    private JFileChooser fcSaveAll;

    public FileDialog(Component parent) {
        this.parent = parent;
        this.configSaver = ConfigSaver.getLoadedInstance();
        LuytenPreferences luytenPrefs = this.configSaver.getLuytenPreferences();
        this.dirPreferences = new DirPreferences(luytenPrefs);
        new Thread(){

            @Override
            public void run() {
                try {
                    FileDialog.this.initOpenDialog();
                    Thread.sleep(500L);
                    FileDialog.this.initSaveAllDialog();
                    Thread.sleep(500L);
                    FileDialog.this.initSaveDialog();
                }
                catch (Exception e) {
                    Luyten.showExceptionDialog("Exception!", e);
                }
            }
        }.start();
    }

    public File doOpenDialog() {
        File selectedFile = null;
        this.initOpenDialog();
        this.dirPreferences.retrieveOpenDialogDir(this.fcOpen);
        int returnVal = this.fcOpen.showOpenDialog(this.parent);
        this.dirPreferences.saveOpenDialogDir(this.fcOpen);
        if (returnVal == 0) {
            selectedFile = this.fcOpen.getSelectedFile();
        }
        return selectedFile;
    }

    public File doSaveDialog(String recommendedFileName) {
        File selectedFile = null;
        this.initSaveDialog();
        this.dirPreferences.retrieveSaveDialogDir(this.fcSave);
        this.fcSave.setSelectedFile(new File(recommendedFileName));
        int returnVal = this.fcSave.showSaveDialog(this.parent);
        this.dirPreferences.saveSaveDialogDir(this.fcSave);
        if (returnVal == 0) {
            selectedFile = this.fcSave.getSelectedFile();
        }
        return selectedFile;
    }

    public File doSaveAllDialog(String recommendedFileName) {
        File selectedFile = null;
        this.initSaveAllDialog();
        this.dirPreferences.retrieveSaveDialogDir(this.fcSaveAll);
        this.fcSaveAll.setSelectedFile(new File(recommendedFileName));
        int returnVal = this.fcSaveAll.showSaveDialog(this.parent);
        this.dirPreferences.saveSaveDialogDir(this.fcSaveAll);
        if (returnVal == 0) {
            selectedFile = this.fcSaveAll.getSelectedFile();
        }
        return selectedFile;
    }

    public synchronized void initOpenDialog() {
        if (this.fcOpen == null) {
            this.fcOpen = this.createFileChooser("*.jar", "*.zip", "*.class");
            this.dirPreferences.retrieveOpenDialogDir(this.fcOpen);
        }
    }

    public synchronized void initSaveDialog() {
        if (this.fcSave == null) {
            this.fcSave = this.createFileChooser("*.txt", "*.java");
            this.dirPreferences.retrieveSaveDialogDir(this.fcSave);
        }
    }

    public synchronized void initSaveAllDialog() {
        if (this.fcSaveAll == null) {
            this.fcSaveAll = this.createFileChooser("*.jar", "*.zip");
            this.dirPreferences.retrieveSaveDialogDir(this.fcSaveAll);
        }
    }

    private JFileChooser createFileChooser(String ... fileFilters) {
        JFileChooser fc = new JFileChooser();
        for (String fileFilter : fileFilters) {
            fc.addChoosableFileFilter(new FileChooserFileFilter(fileFilter));
        }
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        return fc;
    }

    public class FileChooserFileFilter
    extends FileFilter {
        String objType;

        public FileChooserFileFilter(String string) {
            this.objType = string;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(this.objType.substring(1));
        }

        @Override
        public String getDescription() {
            return this.objType;
        }
    }
}

