/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockUpdateDetector;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAbstractBase
extends TileEntity
implements IBlockUpdateDetector {
    private boolean isFirstTick = true;
    public static final ForgeDirection[] UP_DIRECTIONS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    private final HashMap<Object, Integer> installedUpgrades = new HashMap(10);
    private final HashMap<Object, Integer> maxUpgrades = new HashMap(10);

    public void func_145845_h() {
        super.func_145845_h();
        if (this.isFirstTick) {
            this.isFirstTick = false;
            this.onFirstUpdateTick();
        }
    }

    protected void onFirstUpdateTick() {
    }

    @Override
    public void updatedNeighbours() {
    }

    protected boolean isOnPlanet() {
        return this.field_145850_b.field_73011_w.field_76574_g == 0;
    }

    protected void updateMetadata(int metadata) {
        if (this.func_145832_p() != metadata) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 2);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static ItemStack copyWithSize(ItemStack itemStack, int newSize) {
        ItemStack ret = itemStack.func_77946_l();
        ret.field_77994_a = newSize;
        return ret;
    }

    public static Collection<IInventory> getConnectedInventories(TileEntity tileEntityConnection) {
        ArrayList<IInventory> result = new ArrayList<IInventory>(6);
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = tileEntityConnection.func_145831_w().func_147438_o(tileEntityConnection.field_145851_c + side.offsetX, tileEntityConnection.field_145848_d + side.offsetY, tileEntityConnection.field_145849_e + side.offsetZ);
            if (tileEntity == null || !(tileEntity instanceof IInventory)) continue;
            result.add((IInventory)tileEntity);
            if (!(tileEntity instanceof TileEntityChest)) continue;
            TileEntityChest tileEntityChest = (TileEntityChest)tileEntity;
            tileEntityChest.func_145979_i();
            if (tileEntityChest.field_145991_k != null) {
                result.add((IInventory)tileEntityChest.field_145991_k);
                continue;
            }
            if (tileEntityChest.field_145990_j != null) {
                result.add((IInventory)tileEntityChest.field_145990_j);
                continue;
            }
            if (tileEntityChest.field_145992_i != null) {
                result.add((IInventory)tileEntityChest.field_145992_i);
                continue;
            }
            if (tileEntityChest.field_145988_l == null) continue;
            result.add((IInventory)tileEntityChest.field_145988_l);
        }
        return result;
    }

    protected boolean addToConnectedInventories(ItemStack itemStack) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(1);
        itemStacks.add(itemStack);
        return this.addToInventories(itemStacks, TileEntityAbstractBase.getConnectedInventories(this));
    }

    protected boolean addToConnectedInventories(List<ItemStack> itemStacks) {
        return this.addToInventories(itemStacks, TileEntityAbstractBase.getConnectedInventories(this));
    }

    protected boolean addToInventories(List<ItemStack> itemStacks, Collection<IInventory> inventories) {
        boolean overflow = false;
        if (itemStacks != null) {
            for (ItemStack itemStack : itemStacks) {
                IInventory inventory;
                if (itemStack.func_77973_b() == null) {
                    WarpDrive.logger.error(this + "Invalid itemStack with null item...");
                    continue;
                }
                int qtyLeft = itemStack.field_77994_a;
                ItemStack itemStackLeft = itemStack.func_77946_l();
                Iterator<IInventory> iterator = inventories.iterator();
                while (iterator.hasNext() && (qtyLeft = TileEntityAbstractBase.addToInventory(itemStack, inventory = iterator.next())) > 0) {
                    itemStackLeft.field_77994_a = qtyLeft;
                }
                if (qtyLeft <= 0) continue;
                if (WarpDriveConfig.LOGGING_COLLECTION) {
                    WarpDrive.logger.info(this + " Overflow detected");
                }
                overflow = true;
                while (qtyLeft > 0) {
                    int transfer = Math.min(qtyLeft, itemStackLeft.func_77976_d());
                    ItemStack itemStackDrop = TileEntityAbstractBase.copyWithSize(itemStackLeft, transfer);
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, itemStackDrop);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                    qtyLeft -= transfer;
                }
            }
        }
        return overflow;
    }

    private static int addToInventory(ItemStack itemStackSource, IInventory inventory) {
        if (itemStackSource == null || itemStackSource.func_77973_b() == null) {
            return 0;
        }
        int qtyLeft = itemStackSource.field_77994_a;
        if (inventory != null) {
            int transfer;
            ItemStack itemStack;
            int i;
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) == null || !itemStack.func_77969_a(itemStackSource)) continue;
                transfer = Math.min(qtyLeft, itemStack.func_77976_d() - itemStack.field_77994_a);
                itemStack.field_77994_a += transfer;
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
            for (i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!inventory.func_94041_b(i, itemStackSource) || (itemStack = inventory.func_70301_a(i)) != null) continue;
                transfer = Math.min(qtyLeft, itemStackSource.func_77976_d());
                ItemStack dest = TileEntityAbstractBase.copyWithSize(itemStackSource, transfer);
                inventory.func_70299_a(i, dest);
                if ((qtyLeft -= transfer) > 0) continue;
                return 0;
            }
        }
        return qtyLeft;
    }

    public static Set<VectorI> getConnectedBlocks(World world, VectorI start, ForgeDirection[] directions, HashSet<Block> whitelist, int maxRange, VectorI ... ignore) {
        return TileEntityAbstractBase.getConnectedBlocks(world, Arrays.asList(start), directions, whitelist, maxRange, ignore);
    }

    public static Set<VectorI> getConnectedBlocks(World world, Collection<VectorI> start, ForgeDirection[] directions, HashSet<Block> whitelist, int maxRange, VectorI ... ignore) {
        HashSet<VectorI> toIgnore = new HashSet<VectorI>();
        if (ignore != null) {
            toIgnore.addAll(Arrays.asList(ignore));
        }
        HashSet<VectorI> toIterate = new HashSet<VectorI>();
        toIterate.addAll(start);
        HashSet<VectorI> iterated = new HashSet<VectorI>();
        for (int range = 0; !toIterate.isEmpty() && range < maxRange; ++range) {
            HashSet<VectorI> toIterateNext = new HashSet<VectorI>();
            for (VectorI current : toIterate) {
                if (whitelist.contains(current.getBlock_noChunkLoading((IBlockAccess)world))) {
                    iterated.add(current);
                }
                for (ForgeDirection direction : directions) {
                    VectorI next = current.clone(direction);
                    if (iterated.contains(next) || toIgnore.contains(next) || toIterate.contains(next) || toIterateNext.contains(next) || !whitelist.contains(next.getBlock_noChunkLoading((IBlockAccess)world))) continue;
                    toIterateNext.add(next);
                }
            }
            toIterate = toIterateNext;
        }
        return iterated;
    }

    protected static int toInt(double d) {
        return (int)Math.round(d);
    }

    protected static int toInt(Object object) {
        return TileEntityAbstractBase.toInt(TileEntityAbstractBase.toDouble(object));
    }

    protected static double toDouble(Object object) {
        return Double.parseDouble(object.toString());
    }

    protected static float toFloat(Object object) {
        return Float.parseFloat(object.toString());
    }

    protected static boolean toBool(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        String string = object.toString();
        return string.equals("true") || string.equals("1.0") || string.equals("1") || string.equals("y") || string.equals("yes");
    }

    protected static int clamp(int min, int max, int value) {
        return Math.min(max, Math.max(value, min));
    }

    protected static float clamp(float min, float max, float value) {
        return Math.min(max, Math.max(value, min));
    }

    protected static double clamp(double min, double max, double value) {
        return Math.min(max, Math.max(value, min));
    }

    protected boolean isBlockBreakCanceled(EntityPlayer entityPlayer, World world, int eventX, int eventY, int eventZ) {
        return WarpDrive.proxy.isBlockBreakCanceled(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e, world, eventX, eventY, eventZ);
    }

    protected boolean isBlockPlaceCanceled(EntityPlayer entityPlayer, World world, int eventX, int eventY, int eventZ, Block block, int metadata) {
        return WarpDrive.proxy.isBlockPlaceCanceled(entityPlayer, this.field_145851_c, this.field_145848_d, this.field_145849_e, world, eventX, eventY, eventZ, block, metadata);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("upgrades")) {
            NBTTagCompound nbtTagCompoundUpgrades = tag.func_74775_l("upgrades");
            Set keys = nbtTagCompoundUpgrades.func_150296_c();
            for (String key : keys) {
                Object object = this.getUpgradeFromString(key);
                byte value = nbtTagCompoundUpgrades.func_74771_c(key);
                if (object == null) {
                    WarpDrive.logger.error("Found an unknown upgrade named '" + key + "' in " + this);
                    object = key;
                }
                this.installedUpgrades.put(object, Integer.valueOf(value));
            }
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (!this.installedUpgrades.isEmpty()) {
            NBTTagCompound nbtTagCompoundUpgrades = new NBTTagCompound();
            for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
                String key = this.getUpgradeAsString(entry.getKey());
                nbtTagCompoundUpgrades.func_74774_a(key, (byte)entry.getValue().intValue());
            }
            tagCompound.func_74782_a("upgrades", (NBTBase)nbtTagCompoundUpgrades);
        }
    }

    public NBTTagCompound writeItemDropNBT(NBTTagCompound nbtTagCompound) {
        this.func_145841_b(nbtTagCompound);
        nbtTagCompound.func_82580_o("x");
        nbtTagCompound.func_82580_o("y");
        nbtTagCompound.func_82580_o("z");
        return nbtTagCompound;
    }

    protected String getUpgradeStatus() {
        String strUpgrades = this.getUpgradesAsString();
        if (strUpgrades.isEmpty()) {
            return StatCollector.func_74837_a((String)"warpdrive.upgrade.statusLine.none", (Object[])new Object[]{strUpgrades});
        }
        return StatCollector.func_74837_a((String)"warpdrive.upgrade.statusLine.valid", (Object[])new Object[]{strUpgrades});
    }

    public String getStatus() {
        if (this.field_145850_b == null) {
            return "";
        }
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)this.func_145838_q()), 1, this.func_145832_p());
        return StatCollector.func_74837_a((String)"warpdrive.guide.prefix", (Object[])new Object[]{StatCollector.func_74837_a((String)(itemStack.func_77977_a() + ".name"), (Object[])new Object[0])});
    }

    public boolean hasUpgrade(Object upgrade) {
        return this.getUpgradeCount(upgrade) > 0;
    }

    private String getUpgradeAsString(Object object) {
        if (object instanceof Item) {
            return Item.field_150901_e.func_148750_c(object);
        }
        if (object instanceof Block) {
            return Block.field_149771_c.func_148750_c(object);
        }
        if (object instanceof ItemStack) {
            return Item.field_150901_e.func_148750_c((Object)((ItemStack)object).func_77973_b()) + ":" + ((ItemStack)object).func_77960_j();
        }
        return object.toString();
    }

    private Object getUpgradeFromString(String name) {
        for (Object object : this.maxUpgrades.keySet()) {
            if (!this.getUpgradeAsString(object).equals(name)) continue;
            return object;
        }
        return null;
    }

    public Object getFirstUpgradeOfType(Class clazz, Object defaultValue) {
        for (Object object : this.installedUpgrades.keySet()) {
            if (clazz == null || !clazz.isInstance(object)) continue;
            return object;
        }
        return defaultValue;
    }

    public Map<Object, Integer> getUpgradesOfType(Class clazz) {
        if (clazz == null) {
            return this.installedUpgrades;
        }
        HashMap<Object, Integer> mapResult = new HashMap<Object, Integer>(this.installedUpgrades.size());
        for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
            if (!clazz.isInstance(entry.getKey())) continue;
            mapResult.put(entry.getKey(), entry.getValue());
        }
        return mapResult;
    }

    public int getUpgradeCount(Object upgrade) {
        Integer value = this.installedUpgrades.get(upgrade);
        return value == null ? 0 : value;
    }

    public int getUpgradeMaxCount(Object upgrade) {
        Integer value = this.maxUpgrades.get(upgrade);
        return value == null ? 0 : value;
    }

    protected String getUpgradesAsString() {
        String message = "";
        for (Map.Entry<Object, Integer> entry : this.installedUpgrades.entrySet()) {
            if (!message.isEmpty()) {
                message = message + ", ";
            }
            Object key = entry.getKey();
            String keyName = key.toString();
            if (key instanceof Item) {
                keyName = ((Item)key).func_77658_a();
            } else if (key instanceof Block) {
                keyName = ((Block)key).func_149739_a();
            }
            if (entry.getValue() == 1) {
                message = message + keyName;
                continue;
            }
            message = message + entry.getValue() + " x " + keyName;
        }
        return message;
    }

    protected void setUpgradeMaxCount(Object upgrade, int value) {
        this.maxUpgrades.put(upgrade, value);
    }

    public boolean canUpgrade(Object upgrade) {
        return this.getUpgradeMaxCount(upgrade) >= this.getUpgradeCount(upgrade) + 1;
    }

    public boolean mountUpgrade(Object upgrade) {
        if (this.canUpgrade(upgrade)) {
            this.installedUpgrades.put(upgrade, this.getUpgradeCount(upgrade) + 1);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean dismountUpgrade(Object upgrade) {
        int count = this.getUpgradeCount(upgrade);
        if (count > 1) {
            this.installedUpgrades.put(upgrade, count - 1);
            this.func_70296_d();
            return true;
        }
        if (count > 0) {
            this.installedUpgrades.remove(upgrade);
            this.func_70296_d();
            return true;
        }
        return false;
    }
}

