/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractInterfaced;
import cr0s.warpdrive.config.WarpDriveConfig;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHCore"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2API"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2API")})
public abstract class TileEntityAbstractEnergy
extends TileEntityAbstractInterfaced
implements IEnergyHandler,
IEnergySink,
IEnergySource {
    private boolean addedToEnergyNet = false;
    private int energyStored_internal = 0;
    private static final double EU_PER_INTERNAL = 1.0;
    private static final double RF_PER_INTERNAL = 4.114285714285714;
    protected int IC2_sinkTier = 3;
    protected int IC2_sourceTier = 3;
    private static final int SCAN_INTERVAL_TICKS = 20;
    private int scanTickCount = 20;
    private Object[] cofhEnergyReceivers;

    public TileEntityAbstractEnergy() {
        if (WarpDriveConfig.isCoFHCoreLoaded) {
            this.CoFH_initialiseAPI();
        }
        this.addMethods(new String[]{"energy"});
    }

    protected static int convertInternalToRF_ceil(int energy) {
        return (int)Math.ceil((double)energy * 4.114285714285714);
    }

    protected static int convertInternalToRF_floor(int energy) {
        return (int)Math.floor((double)energy * 4.114285714285714);
    }

    protected static int convertRFtoInternal_ceil(int energy) {
        return (int)Math.ceil((double)energy / 4.114285714285714);
    }

    protected static int convertRFtoInternal_floor(int energy) {
        return (int)Math.floor((double)energy / 4.114285714285714);
    }

    protected static double convertInternalToEU_ceil(int energy) {
        return Math.ceil((double)energy * 1.0);
    }

    protected static double convertInternalToEU_floor(int energy) {
        return Math.floor((double)energy * 1.0);
    }

    protected static int convertEUtoInternal_ceil(double amount) {
        return (int)Math.ceil(amount / 1.0);
    }

    protected static int convertEUtoInternal_floor(double amount) {
        return (int)Math.floor(amount / 1.0);
    }

    public int energy_getEnergyStored() {
        return TileEntityAbstractEnergy.clamp(0, this.energy_getMaxStorage(), this.energyStored_internal);
    }

    public int energy_getMaxStorage() {
        return 0;
    }

    public int energy_getPotentialOutput() {
        return 0;
    }

    protected void energy_outputDone(int energyOutput_internal) {
        this.energy_consume(energyOutput_internal);
    }

    public boolean energy_canInput(ForgeDirection from) {
        return false;
    }

    public boolean energy_canOutput(ForgeDirection to) {
        return false;
    }

    public boolean energy_consume(int amount_internal, boolean simulate) {
        if (this.energy_getEnergyStored() >= amount_internal) {
            if (!simulate) {
                this.energy_consume(amount_internal);
            }
            return true;
        }
        return false;
    }

    public void energy_consume(int amount_internal) {
        this.energyStored_internal -= amount_internal;
    }

    public Object[] energy() {
        return new Object[]{this.energy_getEnergyStored(), this.energy_getMaxStorage()};
    }

    public String getEnergyStatus() {
        if (this.energy_getMaxStorage() == 0) {
            return "";
        }
        return StatCollector.func_74837_a((String)"warpdrive.energy.statusLine", (Object[])new Object[]{WarpDrive.format((long)TileEntityAbstractEnergy.convertInternalToEU_floor(this.energy_getEnergyStored())), WarpDrive.format((long)TileEntityAbstractEnergy.convertInternalToEU_floor(this.energy_getMaxStorage()))});
    }

    @Override
    public String getStatus() {
        String strEnergyStatus = this.getEnergyStatus();
        return super.getStatus() + (strEnergyStatus.isEmpty() ? "" : "\n" + strEnergyStatus);
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] energy(Context context, Arguments arguments) {
        return this.energy();
    }

    @Override
    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
        String methodName = this.getMethodName(method);
        if (methodName.equals("energy")) {
            return this.energy();
        }
        return super.callMethod(computer, context, method, arguments);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " updateEntity");
        }
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_addToEnergyNet();
        }
        if (WarpDriveConfig.isCoFHCoreLoaded) {
            --this.scanTickCount;
            if (this.scanTickCount <= 0) {
                this.scanTickCount = 20;
                this.CoFH_scanForEnergyHandlers();
            }
            this.CoFH_outputEnergy();
        }
    }

    @Override
    public void onChunkUnload() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_removeFromEnergyNet();
        }
        super.func_145843_s();
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return Math.max(0.0, TileEntityAbstractEnergy.convertInternalToEU_floor(this.energy_getMaxStorage() - this.energy_getEnergyStored()));
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection from, double amount_EU, double voltage) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [IC2]injectEnergy from " + from + "(" + this.energy_canInput(from) + ") amount " + amount_EU + " voltage " + voltage);
        }
        if (this.energy_canInput(from)) {
            int leftover_internal = 0;
            this.energyStored_internal += TileEntityAbstractEnergy.convertEUtoInternal_floor(amount_EU);
            if (this.energyStored_internal > this.energy_getMaxStorage()) {
                leftover_internal = this.energyStored_internal - this.energy_getMaxStorage();
                this.energyStored_internal = this.energy_getMaxStorage();
            }
            return TileEntityAbstractEnergy.convertInternalToEU_floor(leftover_internal);
        }
        return amount_EU;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection from) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [IC2]acceptsEnergyFrom emitter " + emitter + " from " + from + " => " + this.energy_canInput(from));
        }
        return this.energy_canInput(from);
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return TileEntityAbstractEnergy.convertInternalToEU_floor(this.energy_getPotentialOutput());
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount_EU) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [IC2]drawEnergy amount_EU " + amount_EU);
        }
        this.energy_outputDone(TileEntityAbstractEnergy.convertEUtoInternal_ceil(amount_EU));
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection to) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [IC2]emitsEnergyTo receiver " + receiver + " to " + to + " => " + this.energy_canOutput(to));
        }
        return this.energy_canOutput(to);
    }

    @Optional.Method(modid="IC2")
    private void IC2_addToEnergyNet() {
        if (!this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnergyNet = true;
        }
    }

    @Optional.Method(modid="IC2")
    private void IC2_removeFromEnergyNet() {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnergyNet = false;
        }
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.IC2_sinkTier;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return this.IC2_sourceTier;
    }

    @Optional.Method(modid="CoFHCore")
    public int receiveEnergy(ForgeDirection from, int maxReceive_RF, boolean simulate) {
        if (!this.energy_canInput(from)) {
            return 0;
        }
        int maxStored_RF = this.getMaxEnergyStored(from);
        if (maxStored_RF == 0) {
            return 0;
        }
        int energyStored_RF = this.getEnergyStored(from);
        int toAdd_RF = Math.min(maxReceive_RF, maxStored_RF - energyStored_RF);
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [CoFH]receiveEnergy from " + from + " maxReceive_RF " + maxReceive_RF + " simulate " + simulate + " energy_RF " + energyStored_RF + "/" + maxStored_RF + " toAdd_RF " + toAdd_RF);
        }
        if (!simulate) {
            this.energyStored_internal = Math.min(this.energy_getMaxStorage(), this.energy_getEnergyStored() + TileEntityAbstractEnergy.convertRFtoInternal_floor(toAdd_RF));
        }
        return toAdd_RF;
    }

    @Optional.Method(modid="CoFHCore")
    public int extractEnergy(ForgeDirection from, int maxExtract_RF, boolean simulate) {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [CoFH]extractEnergy from " + from + " maxExtract_RF " + maxExtract_RF + " simulate " + simulate);
        }
        if (!this.energy_canOutput(from)) {
            return 0;
        }
        int potentialEnergyOutput_internal = this.energy_getPotentialOutput();
        int energyExtracted_internal = Math.min(TileEntityAbstractEnergy.convertRFtoInternal_ceil(maxExtract_RF), potentialEnergyOutput_internal);
        if (!simulate) {
            this.energy_outputDone(energyExtracted_internal);
        }
        return TileEntityAbstractEnergy.convertInternalToRF_floor(energyExtracted_internal);
    }

    @Optional.Method(modid="CoFHCore")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energy_getMaxStorage() != 0 && (this.energy_canInput(from) || this.energy_canOutput(from));
    }

    @Optional.Method(modid="CoFHCore")
    public int getEnergyStored(ForgeDirection from) {
        return this.canConnectEnergy(from) ? TileEntityAbstractEnergy.convertInternalToRF_floor(this.energy_getEnergyStored()) : 0;
    }

    @Optional.Method(modid="CoFHCore")
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.canConnectEnergy(from) ? TileEntityAbstractEnergy.convertInternalToRF_floor(this.energy_getMaxStorage()) : 0;
    }

    @Optional.Method(modid="CoFHCore")
    private void CoFH_outputEnergy(ForgeDirection from, IEnergyReceiver energyReceiver) {
        if (energyReceiver == null || this.field_145850_b.func_147438_o(this.field_145851_c + from.offsetX, this.field_145848_d + from.offsetY, this.field_145849_e + from.offsetZ) == null) {
            return;
        }
        if (!this.energy_canOutput(from)) {
            return;
        }
        int potentialEnergyOutput_internal = this.energy_getPotentialOutput();
        if (potentialEnergyOutput_internal > 0) {
            int potentialEnergyOutput_RF = TileEntityAbstractEnergy.convertInternalToRF_floor(potentialEnergyOutput_internal);
            int energyToOutput_RF = energyReceiver.receiveEnergy(from.getOpposite(), potentialEnergyOutput_RF, true);
            if (energyToOutput_RF > 0) {
                int energyOutputted_RF = energyReceiver.receiveEnergy(from.getOpposite(), energyToOutput_RF, false);
                this.energy_outputDone(TileEntityAbstractEnergy.convertRFtoInternal_ceil(energyOutputted_RF));
            }
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void CoFH_outputEnergy() {
        for (ForgeDirection from : ForgeDirection.VALID_DIRECTIONS) {
            if (this.cofhEnergyReceivers[from.ordinal()] == null) continue;
            this.CoFH_outputEnergy(from, (IEnergyReceiver)this.cofhEnergyReceivers[from.ordinal()]);
        }
    }

    @Optional.Method(modid="CoFHCore")
    private void CoFH_initialiseAPI() {
        this.cofhEnergyReceivers = new IEnergyReceiver[ForgeDirection.VALID_DIRECTIONS.length];
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energyStored_internal = tag.func_74762_e("energy");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energy", this.energy_getEnergyStored());
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound = super.writeItemDropNBT(nbtTagCompound);
        nbtTagCompound.func_82580_o("energy");
        return nbtTagCompound;
    }

    @Override
    public void updatedNeighbours() {
        super.updatedNeighbours();
        if (WarpDriveConfig.isCoFHCoreLoaded) {
            this.CoFH_scanForEnergyHandlers();
        }
    }

    protected void energy_resetConnections(EnumFacing facing) {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            this.IC2_removeFromEnergyNet();
        }
        this.scanTickCount = -1;
    }

    @Optional.Method(modid="CoFHCore")
    private void CoFH_scanForEnergyHandlers() {
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(this + " [CoFH]CoFH_scanForEnergyHandlers");
        }
        for (ForgeDirection from : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyReceiver energyReceiver;
            TileEntity tileEntity;
            boolean energyReceiverFound = false;
            if (this.canConnectEnergy(from) && (tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + from.offsetX, this.field_145848_d + from.offsetY, this.field_145849_e + from.offsetZ)) != null && tileEntity instanceof IEnergyReceiver && (energyReceiver = (IEnergyReceiver)tileEntity).canConnectEnergy(from.getOpposite())) {
                energyReceiverFound = true;
                this.cofhEnergyReceivers[from.ordinal()] = energyReceiver;
            }
            if (energyReceiverFound) continue;
            this.cofhEnergyReceivers[from.ordinal()] = null;
        }
    }
}

