/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.detection;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.SirenSound;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.block.detection.BlockSiren;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.ResourceLocation;

public class TileEntitySiren
extends TileEntityAbstractBase {
    private SirenState state = SirenState.STOPPED;
    private boolean isRaidSiren = false;
    private float range = 0.0f;
    private int timeToLastUpdate = 0;
    @SideOnly(value=Side.CLIENT)
    private SirenSound sound;

    @Override
    protected void onFirstUpdateTick() {
        super.onFirstUpdateTick();
        this.range = BlockSiren.getRange(this.func_145832_p());
        this.isRaidSiren = BlockSiren.getIsRaid(this.func_145832_p());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.timeToLastUpdate > 0) {
            --this.timeToLastUpdate;
            return;
        }
        this.timeToLastUpdate = 10;
        if (!this.func_145830_o() || !this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.sound == null) {
            this.setSound();
        }
        switch (this.state) {
            case STOPPED: {
                if (this.isPlaying()) {
                    this.state = SirenState.STOPPING;
                }
                if (!this.isPowered()) break;
                this.state = SirenState.STARTING;
                break;
            }
            case STARTING: {
                if (this.startSound()) {
                    this.state = SirenState.STARTED;
                    break;
                }
                this.state = SirenState.STOPPING;
                break;
            }
            case STARTED: {
                if (!this.isPowered()) {
                    this.state = SirenState.STOPPING;
                    break;
                }
                if (this.isPlaying()) break;
                this.state = SirenState.STARTING;
                break;
            }
            case STOPPING: {
                if (this.isPlaying()) {
                    this.stopSound();
                    break;
                }
                this.state = SirenState.STOPPED;
                break;
            }
            default: {
                this.state = this.isPlaying() ? SirenState.STOPPING : SirenState.STOPPED;
            }
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K && this.isPlaying()) {
            this.stopSound();
        }
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (this.field_145850_b.field_72995_K && this.isPlaying()) {
            this.stopSound();
        }
        super.func_145843_s();
    }

    @SideOnly(value=Side.CLIENT)
    private void setSound() {
        String resource = "WarpDrive:siren_" + (this.isRaidSiren ? "raid" : "industrial");
        this.sound = new SirenSound(new ResourceLocation(resource), this.range, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean startSound() {
        if (!this.isPlaying()) {
            try {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    void stopSound() {
        Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
    }

    @SideOnly(value=Side.CLIENT)
    boolean isPlaying() {
        return Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.sound);
    }

    private boolean isPowered() {
        return this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public static enum SirenState {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

