/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.forcefield;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.BlockAbstractForceField;
import cr0s.warpdrive.block.forcefield.TileEntityForceFieldProjector;
import cr0s.warpdrive.data.EnumForceFieldShape;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.item.ItemForceFieldShape;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockForceFieldProjector
extends BlockAbstractForceField {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockForceFieldProjector(byte tier) {
        super(tier, Material.field_151573_f);
        this.isRotating = true;
        this.func_149663_c("warpdrive.forcefield.projector" + tier);
        this.func_149658_d("warpdrive:forcefield/projector");
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[11];
        this.icons[0] = iconRegister.func_94245_a("warpdrive:forcefield/projectorSide_notConnected");
        this.icons[1] = iconRegister.func_94245_a("warpdrive:forcefield/projectorSide_connectedNotPowered");
        this.icons[2] = iconRegister.func_94245_a("warpdrive:forcefield/projectorSide_connectedPowered");
        this.icons[3] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_none");
        this.icons[4] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_sphere");
        this.icons[5] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_cylinder_h");
        this.icons[6] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_cylinder_v");
        this.icons[7] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_cube");
        this.icons[8] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_plane");
        this.icons[9] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_tube");
        this.icons[10] = iconRegister.func_94245_a("warpdrive:forcefield/projectorShape_tunnel");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityForceFieldProjector)) {
            return this.icons[0];
        }
        if (side == (metadata & 7) || ((TileEntityForceFieldProjector)tileEntity).isDoubleSided && ForgeDirection.OPPOSITES[side] == (metadata & 7)) {
            return this.icons[3 + ((TileEntityForceFieldProjector)tileEntity).getShape().ordinal()];
        }
        if (((TileEntityForceFieldProjector)tileEntity).isConnected) {
            if (((TileEntityForceFieldProjector)tileEntity).isPowered) {
                return this.icons[2];
            }
            return this.icons[1];
        }
        return this.icons[0];
    }

    public IIcon func_149691_a(int side, int metadata) {
        return side == 3 ? this.icons[4] : this.icons[2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149643_k(World world, int x, int y, int z) {
        super.func_149643_k(world, x, y, z);
        TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)world.func_147438_o(x, y, z);
        return tileEntityForceFieldProjector.isDoubleSided ? 1 : 0;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
        TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)world.func_147438_o(x, y, z);
        if (!itemStack.func_77942_o()) {
            tileEntityForceFieldProjector.isDoubleSided = itemStack.func_77960_j() == 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof TileEntityForceFieldProjector)) {
            return false;
        }
        TileEntityForceFieldProjector tileEntityForceFieldProjector = (TileEntityForceFieldProjector)tileEntity;
        ItemStack itemStackHeld = entityPlayer.func_70694_bm();
        int metadata = world.func_72805_g(x, y, z);
        EnumForceFieldUpgrade enumForceFieldUpgrade = EnumForceFieldUpgrade.NONE;
        if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof ItemForceFieldUpgrade) {
            enumForceFieldUpgrade = EnumForceFieldUpgrade.get(itemStackHeld.func_77960_j());
        }
        if (entityPlayer.func_70093_af()) {
            if (itemStackHeld != null && itemStackHeld.func_77973_b() instanceof ItemForceFieldUpgrade || tileEntityForceFieldProjector.getShape() == EnumForceFieldShape.NONE || side != (metadata & 7) && (!tileEntityForceFieldProjector.isDoubleSided || ForgeDirection.OPPOSITES[side] != (metadata & 7))) {
                if (!tileEntityForceFieldProjector.hasUpgrade(enumForceFieldUpgrade)) {
                    enumForceFieldUpgrade = (EnumForceFieldUpgrade)tileEntityForceFieldProjector.getFirstUpgradeOfType(EnumForceFieldUpgrade.class, EnumForceFieldUpgrade.NONE);
                }
                if (enumForceFieldUpgrade == EnumForceFieldUpgrade.NONE) {
                    WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.noUpgradeToDismount", (Object[])new Object[0]));
                    return true;
                }
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = ItemForceFieldUpgrade.getItemStackNoCache(enumForceFieldUpgrade, 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.field_145804_b = 0;
                    world.func_72838_d((Entity)entityItem);
                }
                tileEntityForceFieldProjector.dismountUpgrade(enumForceFieldUpgrade);
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.dismounted", (Object[])new Object[]{enumForceFieldUpgrade.name()}));
                return false;
            }
            if (tileEntityForceFieldProjector.getShape() == EnumForceFieldShape.NONE) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.noShapeToDismount", (Object[])new Object[0]));
                return true;
            }
            if (side == (metadata & 7) || tileEntityForceFieldProjector.isDoubleSided && ForgeDirection.OPPOSITES[side] == (metadata & 7)) {
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    ItemStack itemStackDrop = ItemForceFieldShape.getItemStackNoCache(tileEntityForceFieldProjector.getShape(), tileEntityForceFieldProjector.isDoubleSided ? 2 : 1);
                    EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                    entityItem.field_145804_b = 0;
                    world.func_72838_d((Entity)entityItem);
                }
                tileEntityForceFieldProjector.setShape(EnumForceFieldShape.NONE);
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.shapeDismounted", (Object[])new Object[0]));
                return false;
            }
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.wrongShapeSide", (Object[])new Object[0]));
            return true;
        }
        if (itemStackHeld == null) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, tileEntityForceFieldProjector.getStatus());
            return true;
        }
        if (itemStackHeld.func_77973_b() instanceof ItemForceFieldShape) {
            if (side == (metadata & 7) || ((TileEntityForceFieldProjector)tileEntity).isDoubleSided && ForgeDirection.OPPOSITES[side] == (metadata & 7)) {
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    if (itemStackHeld.field_77994_a < (tileEntityForceFieldProjector.isDoubleSided ? 2 : 1)) {
                        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)(tileEntityForceFieldProjector.isDoubleSided ? "warpdrive.upgrade.result.notEnoughShapes.double" : "warpdrive.upgrade.result.notEnoughShapes.single"), (Object[])new Object[0]));
                        return true;
                    }
                    itemStackHeld.field_77994_a = itemStackHeld.field_77994_a - (tileEntityForceFieldProjector.isDoubleSided ? 2 : 1);
                    if (tileEntityForceFieldProjector.getShape() != EnumForceFieldShape.NONE) {
                        ItemStack itemStackDrop = ItemForceFieldShape.getItemStackNoCache(tileEntityForceFieldProjector.getShape(), tileEntityForceFieldProjector.isDoubleSided ? 2 : 1);
                        EntityItem entityItem = new EntityItem(world, entityPlayer.field_70165_t, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v, itemStackDrop);
                        entityItem.field_145804_b = 0;
                        world.func_72838_d((Entity)entityItem);
                    }
                }
                tileEntityForceFieldProjector.setShape(EnumForceFieldShape.get(itemStackHeld.func_77960_j()));
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.shapeMounted", (Object[])new Object[0]));
                return false;
            }
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.wrongShapeSide", (Object[])new Object[0]));
            return true;
        }
        if (!(itemStackHeld.func_77973_b() instanceof ItemForceFieldUpgrade)) return false;
        if (tileEntityForceFieldProjector.getUpgradeMaxCount(enumForceFieldUpgrade) <= 0) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.invalidProjectorUpgrade", (Object[])new Object[0]));
            return true;
        }
        if (!tileEntityForceFieldProjector.canUpgrade(enumForceFieldUpgrade)) {
            WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.tooManyUpgrades", (Object[])new Object[]{tileEntityForceFieldProjector.getUpgradeMaxCount(enumForceFieldUpgrade)}));
            return true;
        }
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            if (itemStackHeld.field_77994_a < 1) {
                WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.notEnoughUpgrades", (Object[])new Object[0]));
                return true;
            }
            --itemStackHeld.field_77994_a;
        }
        tileEntityForceFieldProjector.mountUpgrade(enumForceFieldUpgrade);
        WarpDrive.addChatMessage((ICommandSender)entityPlayer, StatCollector.func_74837_a((String)"warpdrive.upgrade.result.mounted", (Object[])new Object[]{enumForceFieldUpgrade}));
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityForceFieldProjector();
    }
}

