/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.hull;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IDamageReceiver;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHullGlass
extends BlockColored
implements IDamageReceiver {
    final byte tier;

    public BlockHullGlass(byte tier) {
        super(Material.field_151592_s);
        this.tier = tier;
        this.func_149711_c(WarpDriveConfig.HULL_HARDNESS[tier - 1]);
        this.func_149752_b(WarpDriveConfig.HULL_BLAST_RESISTANCE[tier - 1] * 5.0f / 3.0f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149647_a(WarpDrive.creativeTabWarpDrive);
        this.func_149663_c("warpdrive.hull" + tier + ".glass.");
        this.func_149658_d("warpdrive:hull/glass");
        this.func_149715_a(0.6666667f);
    }

    public int func_149656_h() {
        return 2;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_147437_c(x, y, z)) {
            return true;
        }
        ForgeDirection direction = ForgeDirection.getOrientation((int)side).getOpposite();
        Block sideBlock = world.func_147439_a(x, y, z);
        if (sideBlock instanceof BlockGlass || sideBlock instanceof BlockHullGlass) {
            return world.func_72805_g(x, y, z) != world.func_72805_g(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
        }
        return !world.isSideSolid(x, y, z, direction, false);
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public float getBlockHardness(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        return WarpDriveConfig.HULL_HARDNESS[this.tier - 1];
    }

    @Override
    public int applyDamage(World world, int x, int y, int z, DamageSource damageSource, int damageParameter, Vector3 damageDirection, int damageLevel) {
        if (damageLevel <= 0) {
            return 0;
        }
        if (this.tier == 1) {
            world.func_147468_f(x, y, z);
        } else {
            int metadata = world.func_72805_g(x, y, z);
            world.func_147465_d(x, y, z, WarpDrive.blockHulls_glass[this.tier - 2], metadata, 2);
        }
        return 0;
    }
}

