/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class CompatBotania
implements IBlockTransformer {
    private static Class<?> classBlockModContainer;
    private static Class<?> classBlockAvatar;
    private static Class<?> classBlockFelPumpkin;
    private static Class<?> classBlockSpecialFlower;
    private static final int[] mrotAvatar;
    private static final int[] mrotFelPumpkin;

    public static void register() {
        try {
            classBlockModContainer = Class.forName("vazkii.botania.common.block.BlockModContainer");
            classBlockAvatar = Class.forName("vazkii.botania.common.block.BlockAvatar");
            classBlockFelPumpkin = Class.forName("vazkii.botania.common.block.BlockFelPumpkin");
            classBlockSpecialFlower = Class.forName("vazkii.botania.common.block.BlockSpecialFlower");
            WarpDriveConfig.registerBlockTransformer("Botania", new CompatBotania());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockModContainer.isInstance(block) || classBlockFelPumpkin.isInstance(block) || classBlockSpecialFlower.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagCompound nbtSubTileCmp;
        byte rotationSteps = transformation.getRotationSteps();
        if (classBlockAvatar.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotAvatar[metadata];
                }
                case 2: {
                    return mrotAvatar[mrotAvatar[metadata]];
                }
                case 3: {
                    return mrotAvatar[mrotAvatar[mrotAvatar[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockFelPumpkin.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFelPumpkin[metadata];
                }
                case 2: {
                    return mrotFelPumpkin[mrotFelPumpkin[metadata]];
                }
                case 3: {
                    return mrotFelPumpkin[mrotFelPumpkin[mrotFelPumpkin[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("bindX") && nbtTileEntity.func_74764_b("bindY") && nbtTileEntity.func_74764_b("bindZ")) {
            ChunkCoordinates targetBind = transformation.apply(nbtTileEntity.func_74762_e("bindX"), nbtTileEntity.func_74762_e("bindY"), nbtTileEntity.func_74762_e("bindZ"));
            nbtTileEntity.func_74768_a("bindX", targetBind.field_71574_a);
            nbtTileEntity.func_74768_a("bindY", targetBind.field_71572_b);
            nbtTileEntity.func_74768_a("bindZ", targetBind.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("subTileCmp") && (nbtSubTileCmp = nbtTileEntity.func_74775_l("subTileCmp")).func_74764_b("collectorX") && nbtSubTileCmp.func_74764_b("collectorY") && nbtSubTileCmp.func_74764_b("collectorZ")) {
            ChunkCoordinates targetCollector = transformation.apply(nbtSubTileCmp.func_74762_e("collectorX"), nbtSubTileCmp.func_74762_e("collectorY"), nbtSubTileCmp.func_74762_e("collectorZ"));
            nbtSubTileCmp.func_74768_a("collectorX", targetCollector.field_71574_a);
            nbtSubTileCmp.func_74768_a("collectorY", targetCollector.field_71572_b);
            nbtSubTileCmp.func_74768_a("collectorZ", targetCollector.field_71573_c);
        }
        if (nbtTileEntity.func_74764_b("rotationX")) {
            float rotationX = nbtTileEntity.func_74762_e("rotationX");
            nbtTileEntity.func_74776_a("rotationX", (rotationX + 270.0f * (float)rotationSteps) % 360.0f);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotAvatar = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotFelPumpkin = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

