/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatCarpentersBlocks
implements IBlockTransformer {
    private static Class<?> blockCoverable;
    private static Class<?> blockCarpentersBed;
    private static Class<?> blockCarpentersButton;
    private static Class<?> blockCarpentersCollapsibleBlock;
    private static Class<?> blockCarpentersDoor;
    private static Class<?> blockCarpentersGarageDoor;
    private static Class<?> blockCarpentersGate;
    private static Class<?> blockCarpentersHatch;
    private static Class<?> blockCarpentersLadder;
    private static Class<?> blockCarpentersLever;
    private static Class<?> blockCarpentersPressurePlate;
    private static Class<?> blockCarpentersSafe;
    private static Class<?> blockCarpentersSlope;
    private static Class<?> blockCarpentersStairs;
    private static Class<?> blockCarpentersTorch;
    private static final int[] rotBed;
    private static final byte[] rotButton;
    private static final int[] rotDoor;
    private static final int[] rotGate;
    private static final int[] rotHatch;
    private static final byte[] rotLadder;
    private static final byte[] rotLever;
    private static final byte[] rotSafe;
    private static final byte[] rotSlope;
    private static final byte[] rotStair;

    public static void register() {
        try {
            blockCoverable = Class.forName("com.carpentersblocks.block.BlockCoverable");
            blockCarpentersBed = Class.forName("com.carpentersblocks.block.BlockCarpentersBed");
            blockCarpentersButton = Class.forName("com.carpentersblocks.block.BlockCarpentersButton");
            blockCarpentersCollapsibleBlock = Class.forName("com.carpentersblocks.block.BlockCarpentersCollapsibleBlock");
            blockCarpentersDoor = Class.forName("com.carpentersblocks.block.BlockCarpentersDoor");
            blockCarpentersGarageDoor = Class.forName("com.carpentersblocks.block.BlockCarpentersGarageDoor");
            blockCarpentersGate = Class.forName("com.carpentersblocks.block.BlockCarpentersGate");
            blockCarpentersHatch = Class.forName("com.carpentersblocks.block.BlockCarpentersHatch");
            blockCarpentersLadder = Class.forName("com.carpentersblocks.block.BlockCarpentersLadder");
            blockCarpentersLever = Class.forName("com.carpentersblocks.block.BlockCarpentersLever");
            blockCarpentersPressurePlate = Class.forName("com.carpentersblocks.block.BlockCarpentersPressurePlate");
            blockCarpentersSafe = Class.forName("com.carpentersblocks.block.BlockCarpentersSafe");
            blockCarpentersSlope = Class.forName("com.carpentersblocks.block.BlockCarpentersSlope");
            blockCarpentersStairs = Class.forName("com.carpentersblocks.block.BlockCarpentersStairs");
            blockCarpentersTorch = Class.forName("com.carpentersblocks.block.BlockCarpentersTorch");
            WarpDriveConfig.registerBlockTransformer("CarpentersBlocks", new CompatCarpentersBlocks());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return blockCoverable.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (blockCarpentersBed.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int rotation = metadataNBT >> 13 & 7;
            int state = metadataNBT & 0x1FFF;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotBed[rotation] << 13);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotBed[rotBed[rotation]] << 13);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotBed[rotBed[rotBed[rotation]]] << 13);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersButton.isInstance(block) || blockCarpentersPressurePlate.isInstance(block) || blockCarpentersTorch.isInstance(block)) {
            byte metadataNBT = nbtTileEntity.func_74771_c("cbMetadata");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotButton[metadataNBT]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotButton[rotButton[metadataNBT]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotButton[rotButton[rotButton[metadataNBT]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersCollapsibleBlock.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int state = metadataNBT & 7;
            int weightXPZP = (metadataNBT & 0x7FFF07) >> 3;
            int weightXNZP = (metadataNBT & 0x7C1FFF) >> 13;
            int weightXNZN = (metadataNBT & 0x3FFFF) >> 18;
            int weightXPZN = (metadataNBT & 0x7FE0FF) >> 8;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | weightXPZP << 13 | weightXNZP << 18 | weightXNZN << 8 | weightXPZN << 3);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | weightXPZP << 18 | weightXNZP << 8 | weightXNZN << 3 | weightXPZN << 13);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | weightXPZP << 8 | weightXNZP << 3 | weightXNZN << 13 | weightXPZN << 18);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersDoor.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int rotation = metadataNBT >> 4 & 0xF;
            int state = metadataNBT & 0xFF0F;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotDoor[rotation] << 4);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotDoor[rotDoor[rotation]] << 4);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotDoor[rotDoor[rotDoor[rotation]]] << 4);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersGarageDoor.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int rotation = metadataNBT >> 4 & 7;
            int state = metadataNBT & 0xFF8F;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotButton[rotation] << 4);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotButton[rotButton[rotation]] << 4);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotButton[rotButton[rotButton[rotation]]] << 4);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersGate.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int rotation = metadataNBT >> 4 & 7;
            int state = metadataNBT & 0xFF8F;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotGate[rotation] << 4);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotGate[rotGate[rotation]] << 4);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotGate[rotGate[rotGate[rotation]]] << 4);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersHatch.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            int rotation = metadataNBT >> 3 & 0xF;
            int state = metadataNBT & 0xFF87;
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotHatch[rotation] << 3);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotHatch[rotHatch[rotation]] << 3);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("cbMetadata", state | rotHatch[rotHatch[rotHatch[rotation]]] << 3);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersLadder.isInstance(block)) {
            byte metadataNBT = nbtTileEntity.func_74771_c("cbMetadata");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotLadder[metadataNBT]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotLadder[rotLadder[metadataNBT]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotLadder[rotLadder[rotLadder[metadataNBT]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersLever.isInstance(block)) {
            int metadataNBT = nbtTileEntity.func_74762_e("cbMetadata");
            metadataNBT = metadataNBT >= 64 ? metadataNBT - 48 : metadataNBT;
            switch (rotationSteps) {
                case 1: {
                    metadataNBT = rotLever[metadataNBT];
                    metadataNBT = metadataNBT >= 16 ? metadataNBT + 48 : metadataNBT;
                    nbtTileEntity.func_74768_a("cbMetadata", metadataNBT);
                    return metadata;
                }
                case 2: {
                    metadataNBT = rotLever[rotLever[metadataNBT]];
                    metadataNBT = metadataNBT >= 16 ? metadataNBT + 48 : metadataNBT;
                    nbtTileEntity.func_74768_a("cbMetadata", metadataNBT);
                    return metadata;
                }
                case 3: {
                    metadataNBT = rotLever[rotLever[rotLever[metadataNBT]]];
                    metadataNBT = metadataNBT >= 16 ? metadataNBT + 48 : metadataNBT;
                    nbtTileEntity.func_74768_a("cbMetadata", metadataNBT);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersSafe.isInstance(block)) {
            byte metadataNBT = nbtTileEntity.func_74771_c("cbMetadata");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSafe[metadataNBT]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSafe[rotSafe[metadataNBT]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSafe[rotSafe[rotSafe[metadataNBT]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersSlope.isInstance(block)) {
            byte metadataNBT = nbtTileEntity.func_74771_c("cbMetadata");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSlope[metadataNBT]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSlope[rotSlope[metadataNBT]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotSlope[rotSlope[rotSlope[metadataNBT]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (blockCarpentersStairs.isInstance(block)) {
            byte metadataNBT = nbtTileEntity.func_74771_c("cbMetadata");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotStair[metadataNBT]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotStair[rotStair[metadataNBT]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("cbMetadata", rotStair[rotStair[rotStair[metadataNBT]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotBed = new int[]{1, 2, 3, 0, 5, 6, 7, 4};
        rotButton = new byte[]{0, 1, 5, 4, 2, 3};
        rotDoor = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 13, 14, 15, 12};
        rotGate = new int[]{2, 1, 0, 3, 7, 6, 4, 5};
        rotHatch = new int[]{12, 13, 14, 15, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7};
        rotLadder = new byte[]{1, 0, 5, 4, 2, 3};
        rotLever = new byte[]{16, 17, 2, 3, 18, 19, 6, 7, 24, 25, 10, 11, 26, 27, 14, 15, 0, 1, 5, 4, 20, 21, 22, 23, 8, 9, 13, 12, 28, 29, 30, 31, 32};
        rotSafe = new byte[]{1, 2, 3, 0};
        rotSlope = new byte[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13, 19, 18, 16, 17, 23, 22, 20, 21, 27, 26, 24, 25, 31, 30, 28, 29, 35, 34, 32, 33, 39, 38, 36, 37, 43, 42, 40, 41, 44, 45, 49, 48, 46, 47, 51, 50, 55, 54, 52, 53, 59, 58, 56, 57, 60, 64, 63, 61, 62};
        rotStair = new byte[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13, 19, 18, 16, 17, 23, 22, 20, 21, 27, 26, 24, 25, 31, 30, 28, 29, 35, 34, 32, 33, 39, 38, 36, 37, 43, 42, 40, 41, 44, 45, 49, 48, 46, 47, 51, 50, 55, 54, 52, 53, 59, 58, 56, 57, 60, 64, 63, 61, 62};
    }
}

