/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class CompatTConstruct
implements IBlockTransformer {
    private static Class<?> classBlockDryingRack;
    private static Class<?> classTileFurnaceLogic;
    private static Class<?> classTileFaucetLogic;
    private static Class<?> classTileSmelteryDrainLogic;
    private static Class<?> classTileSmelteryLogic;
    private static final int[] mrotDryingRack;
    private static final byte[] rotDirection;

    public static void register() {
        try {
            classBlockDryingRack = Class.forName("tconstruct.armor.blocks.DryingRack");
            classTileFurnaceLogic = Class.forName("tconstruct.tools.logic.FurnaceLogic");
            classTileFaucetLogic = Class.forName("tconstruct.smeltery.logic.FaucetLogic");
            classTileSmelteryDrainLogic = Class.forName("tconstruct.smeltery.logic.SmelteryDrainLogic");
            classTileSmelteryLogic = Class.forName("tconstruct.smeltery.logic.SmelteryLogic");
            WarpDriveConfig.registerBlockTransformer("TConstruct", new CompatTConstruct());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockDryingRack.isInstance(block) || classTileFurnaceLogic.isInstance(tileEntity) || classTileFaucetLogic.isInstance(tileEntity) || classTileSmelteryDrainLogic.isInstance(tileEntity) || classTileSmelteryLogic.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, StringBuilder reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(TileEntity tileEntity) {
        return null;
    }

    @Override
    public void remove(TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockDryingRack.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotDryingRack[metadata];
                }
                case 2: {
                    return mrotDryingRack[mrotDryingRack[metadata]];
                }
                case 3: {
                    return mrotDryingRack[mrotDryingRack[mrotDryingRack[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Direction")) {
            short direction = nbtTileEntity.func_74771_c("Direction");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("Direction", rotDirection[direction]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("Direction", rotDirection[rotDirection[direction]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("Direction", rotDirection[rotDirection[rotDirection[direction]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotDryingRack = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotDirection = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

